/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.jdt.internal.ui.preferences.EditTemplateDialog;
import org.eclipse.jdt.internal.ui.preferences.JavaSourcePreviewerUpdater;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.preferences.TemplateEditorSourceViewerConfiguration;
import org.eclipse.jdt.internal.ui.text.template.preferences.TemplateVariableProcessor;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplatePersistenceData;
import org.eclipse.jface.text.templates.persistence.TemplateReaderWriter;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CodeTemplateBlock {
    private static final int IDX_EDIT = 0;
    private static final int IDX_IMPORT = 2;
    private static final int IDX_EXPORT = 3;
    private static final int IDX_EXPORTALL = 4;
    protected static final Object COMMENT_NODE = PreferencesMessages.CodeTemplateBlock_templates_comment_node;
    protected static final Object CODE_NODE = PreferencesMessages.CodeTemplateBlock_templates_code_node;
    private TreeListDialogField fCodeTemplateTree;
    protected ProjectTemplateStore fTemplateStore;
    private PixelConverter fPixelConverter;
    private SourceViewer fPatternViewer;
    private Control fSWTWidget;
    private TemplateVariableProcessor fTemplateProcessor;
    private final IProject fProject;

    public CodeTemplateBlock(IProject project) {
        this.fProject = project;
        this.fTemplateStore = new ProjectTemplateStore(project);
        try {
            this.fTemplateStore.load();
        }
        catch (IOException e) {
            JavaPlugin.log(e);
        }
        this.fTemplateProcessor = new TemplateVariableProcessor();
        CodeTemplateAdapter adapter = new CodeTemplateAdapter();
        String[] stringArray = new String[5];
        stringArray[0] = PreferencesMessages.CodeTemplateBlock_templates_edit_button;
        stringArray[2] = PreferencesMessages.CodeTemplateBlock_templates_import_button;
        stringArray[3] = PreferencesMessages.CodeTemplateBlock_templates_export_button;
        stringArray[4] = PreferencesMessages.CodeTemplateBlock_templates_exportall_button;
        String[] buttonLabels = stringArray;
        this.fCodeTemplateTree = new TreeListDialogField(adapter, buttonLabels, (ILabelProvider)new CodeTemplateLabelProvider());
        this.fCodeTemplateTree.setDialogFieldListener(adapter);
        this.fCodeTemplateTree.setLabelText(PreferencesMessages.CodeTemplateBlock_templates_label);
        this.fCodeTemplateTree.setViewerSorter(adapter);
        this.fCodeTemplateTree.enableButton(3, false);
        this.fCodeTemplateTree.enableButton(0, false);
        this.fCodeTemplateTree.addElement(COMMENT_NODE);
        this.fCodeTemplateTree.addElement(CODE_NODE);
        this.fCodeTemplateTree.selectFirstElement();
    }

    public void postSetSelection(Object element) {
        this.fCodeTemplateTree.postSetSelection((ISelection)new StructuredSelection(element));
    }

    public boolean hasProjectSpecificOptions(IProject project) {
        if (project != null) {
            return ProjectTemplateStore.hasProjectSpecificTempates(project);
        }
        return false;
    }

    protected Control createContents(Composite parent) {
        this.fPixelConverter = new PixelConverter((Control)parent);
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        this.fCodeTemplateTree.doFillIntoGrid(composite, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fCodeTemplateTree.getLabelControl(null), 2);
        LayoutUtil.setHorizontalGrabbing(this.fCodeTemplateTree.getTreeControl(null));
        this.fPatternViewer = this.createViewer(composite, 2);
        return composite;
    }

    private Shell getShell() {
        if (this.fSWTWidget != null) {
            return this.fSWTWidget.getShell();
        }
        return JavaPlugin.getActiveWorkbenchShell();
    }

    private SourceViewer createViewer(Composite parent, int nColumns) {
        Label label = new Label(parent, 0);
        label.setText(PreferencesMessages.CodeTemplateBlock_preview);
        GridData data = new GridData();
        data.horizontalSpan = nColumns;
        label.setLayoutData((Object)data);
        Document document = new Document();
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        tools.setupJavaDocumentPartitioner((IDocument)document, "___java_partitioning");
        IPreferenceStore store = JavaPlugin.getDefault().getCombinedPreferenceStore();
        JavaSourceViewer viewer = new JavaSourceViewer(parent, null, null, false, 2816, store);
        TemplateEditorSourceViewerConfiguration configuration = new TemplateEditorSourceViewerConfiguration(tools.getColorManager(), store, null, this.fTemplateProcessor);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setEditable(false);
        viewer.setDocument((IDocument)document);
        Font font = JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont");
        viewer.getTextWidget().setFont(font);
        new JavaSourcePreviewerUpdater((SourceViewer)viewer, configuration, store);
        Control control = viewer.getControl();
        data = new GridData(1296);
        data.horizontalSpan = nColumns;
        data.heightHint = this.fPixelConverter.convertHeightInCharsToPixels(5);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected TemplatePersistenceData[] getTemplateOfCategory(boolean isComment) {
        ArrayList<TemplatePersistenceData> res = new ArrayList<TemplatePersistenceData>();
        TemplatePersistenceData[] templates = this.fTemplateStore.getTemplateData();
        int i = 0;
        while (i < templates.length) {
            TemplatePersistenceData curr = templates[i];
            if (isComment == curr.getTemplate().getName().endsWith("comment")) {
                res.add(curr);
            }
            ++i;
        }
        return res.toArray(new TemplatePersistenceData[res.size()]);
    }

    protected static boolean canEdit(List selected) {
        return selected.size() == 1 && selected.get(0) instanceof TemplatePersistenceData;
    }

    protected void updateSourceViewerInput(List selection) {
        if (this.fPatternViewer == null || this.fPatternViewer.getTextWidget().isDisposed()) {
            return;
        }
        if (selection.size() == 1 && selection.get(0) instanceof TemplatePersistenceData) {
            TemplatePersistenceData data = (TemplatePersistenceData)selection.get(0);
            Template template = data.getTemplate();
            TemplateContextType type = JavaPlugin.getDefault().getCodeTemplateContextRegistry().getContextType(template.getContextTypeId());
            this.fTemplateProcessor.setContextType(type);
            this.fPatternViewer.getDocument().set(template.getPattern());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void doButtonPressed(int buttonIndex, List selected) {
        if (buttonIndex == 0) {
            this.edit((TemplatePersistenceData)selected.get(0));
        } else if (buttonIndex == 3) {
            this.export(selected);
        } else if (buttonIndex == 4) {
            this.exportAll();
        } else if (buttonIndex == 2) {
            this.import_();
        }
    }

    private void edit(TemplatePersistenceData data) {
        Template newTemplate = new Template(data.getTemplate());
        EditTemplateDialog dialog = new EditTemplateDialog(this.getShell(), newTemplate, true, false, JavaPlugin.getDefault().getCodeTemplateContextRegistry());
        if (dialog.open() == 0) {
            data.setTemplate(dialog.getTemplate());
            this.fCodeTemplateTree.refresh(data);
            this.fCodeTemplateTree.selectElements((ISelection)new StructuredSelection((Object)data));
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void import_() {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(PreferencesMessages.CodeTemplateBlock_import_title);
        dialog.setFilterExtensions(new String[]{PreferencesMessages.CodeTemplateBlock_import_extension});
        String path = dialog.open();
        if (path == null) {
            return;
        }
        try {
            TemplateReaderWriter reader = new TemplateReaderWriter();
            File file = new File(path);
            if (file.exists()) {
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                try {
                    TemplatePersistenceData[] datas = reader.read((InputStream)input, null);
                    int i = 0;
                    while (i < datas.length) {
                        this.updateTemplate(datas[i]);
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    try {
                        ((InputStream)input).close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var8_12 = null;
                }
                try {}
                catch (IOException iOException) {}
                ((InputStream)input).close();
            }
            this.fCodeTemplateTree.refresh();
            this.updateSourceViewerInput(this.fCodeTemplateTree.getSelectedElements());
            return;
        }
        catch (FileNotFoundException e) {
            this.openReadErrorDialog(e);
            return;
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void updateTemplate(TemplatePersistenceData data) {
        TemplatePersistenceData[] datas = this.fTemplateStore.getTemplateData();
        int i = 0;
        while (i < datas.length) {
            String id = datas[i].getId();
            if (id != null && id.equals(data.getId())) {
                datas[i].setTemplate(data.getTemplate());
                break;
            }
            ++i;
        }
    }

    private void exportAll() {
        this.export(this.fTemplateStore.getTemplateData());
    }

    private void export(List selected) {
        HashSet datas = new HashSet();
        int i = 0;
        while (i < selected.size()) {
            Object curr = selected.get(i);
            if (curr instanceof TemplatePersistenceData) {
                datas.add(curr);
            } else {
                TemplatePersistenceData[] cat = this.getTemplateOfCategory(curr == COMMENT_NODE);
                datas.addAll(Arrays.asList(cat));
            }
            ++i;
        }
        this.export(datas.toArray(new TemplatePersistenceData[datas.size()]));
    }

    private void export(TemplatePersistenceData[] templates) {
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(Messages.format(PreferencesMessages.CodeTemplateBlock_export_title, String.valueOf(templates.length)));
        dialog.setFilterExtensions(new String[]{PreferencesMessages.CodeTemplateBlock_export_extension});
        dialog.setFileName(PreferencesMessages.CodeTemplateBlock_export_filename);
        String path = dialog.open();
        if (path == null) {
            return;
        }
        File file = new File(path);
        if (file.isHidden()) {
            String title = PreferencesMessages.CodeTemplateBlock_export_error_title;
            String message = Messages.format(PreferencesMessages.CodeTemplateBlock_export_error_hidden, file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (file.exists() && !file.canWrite()) {
            String title = PreferencesMessages.CodeTemplateBlock_export_error_title;
            String message = Messages.format(PreferencesMessages.CodeTemplateBlock_export_error_canNotWrite, file.getAbsolutePath());
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
            return;
        }
        if (!file.exists() || this.confirmOverwrite(file)) {
            OutputStream output = null;
            try {
                output = new BufferedOutputStream(new FileOutputStream(file));
                TemplateReaderWriter writer = new TemplateReaderWriter();
                writer.save(templates, output);
                output.close();
            }
            catch (IOException e) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                this.openWriteErrorDialog(e);
            }
        }
    }

    private boolean confirmOverwrite(File file) {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)PreferencesMessages.CodeTemplateBlock_export_exists_title, (String)Messages.format(PreferencesMessages.CodeTemplateBlock_export_exists_message, file.getAbsolutePath()));
    }

    public void performDefaults() {
        this.fTemplateStore.restoreDefaults();
        this.fCodeTemplateTree.refresh();
        this.updateSourceViewerInput(this.fCodeTemplateTree.getSelectedElements());
    }

    public boolean performOk(boolean enabled) {
        if (this.fProject != null) {
            TemplatePersistenceData[] templateData = this.fTemplateStore.getTemplateData();
            int i = 0;
            while (i < templateData.length) {
                this.fTemplateStore.setProjectSpecific(templateData[i].getId(), enabled);
                ++i;
            }
        }
        try {
            this.fTemplateStore.save();
        }
        catch (IOException e) {
            JavaPlugin.log(e);
            this.openWriteErrorDialog(e);
        }
        return true;
    }

    public void performCancel() {
        try {
            this.fTemplateStore.revertChanges();
        }
        catch (IOException e) {
            this.openReadErrorDialog(e);
        }
    }

    private void openReadErrorDialog(Exception e) {
        String title = PreferencesMessages.CodeTemplateBlock_error_read_title;
        String message = e.getLocalizedMessage();
        message = message != null ? Messages.format(PreferencesMessages.CodeTemplateBlock_error_parse_message, message) : PreferencesMessages.CodeTemplateBlock_error_read_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private void openWriteErrorDialog(Exception e) {
        String title = PreferencesMessages.CodeTemplateBlock_error_write_title;
        String message = PreferencesMessages.CodeTemplateBlock_error_write_message;
        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
    }

    private class CodeTemplateAdapter
    extends ViewerSorter
    implements ITreeListAdapter,
    IDialogFieldListener {
        private final Object[] NO_CHILDREN = new Object[0];

        private CodeTemplateAdapter() {
        }

        public void customButtonPressed(TreeListDialogField field, int index) {
            CodeTemplateBlock.this.doButtonPressed(index, field.getSelectedElements());
        }

        public void selectionChanged(TreeListDialogField field) {
            List selected = field.getSelectedElements();
            field.enableButton(0, CodeTemplateBlock.canEdit(selected));
            field.enableButton(3, !selected.isEmpty());
            CodeTemplateBlock.this.updateSourceViewerInput(selected);
        }

        public void doubleClicked(TreeListDialogField field) {
            List selected = field.getSelectedElements();
            if (CodeTemplateBlock.canEdit(selected)) {
                CodeTemplateBlock.this.doButtonPressed(0, selected);
            }
        }

        public Object[] getChildren(TreeListDialogField field, Object element) {
            if (element == COMMENT_NODE || element == CODE_NODE) {
                return CodeTemplateBlock.this.getTemplateOfCategory(element == COMMENT_NODE);
            }
            return this.NO_CHILDREN;
        }

        public Object getParent(TreeListDialogField field, Object element) {
            if (element instanceof TemplatePersistenceData) {
                TemplatePersistenceData data = (TemplatePersistenceData)element;
                if (data.getTemplate().getName().endsWith("comment")) {
                    return COMMENT_NODE;
                }
                return CODE_NODE;
            }
            return null;
        }

        public boolean hasChildren(TreeListDialogField field, Object element) {
            return element == COMMENT_NODE || element == CODE_NODE;
        }

        public void dialogFieldChanged(DialogField field) {
        }

        public void keyPressed(TreeListDialogField field, KeyEvent event) {
        }

        public int category(Object element) {
            if (element == COMMENT_NODE) {
                return 1;
            }
            if (element == CODE_NODE) {
                return 2;
            }
            TemplatePersistenceData data = (TemplatePersistenceData)element;
            String id = data.getId();
            if ("org.eclipse.jdt.ui.text.codetemplates.newtype".equals(id)) {
                return 101;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.classbody".equals(id)) {
                return 102;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.interfacebody".equals(id)) {
                return 103;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.enumbody".equals(id)) {
                return 104;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.annotationbody".equals(id)) {
                return 105;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.methodbody".equals(id)) {
                return 106;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.constructorbody".equals(id)) {
                return 107;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.getterbody".equals(id)) {
                return 108;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.setterbody".equals(id)) {
                return 109;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.catchblock".equals(id)) {
                return 110;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.filecomment".equals(id)) {
                return 1;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.typecomment".equals(id)) {
                return 2;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.fieldcomment".equals(id)) {
                return 3;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.constructorcomment".equals(id)) {
                return 4;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.methodcomment".equals(id)) {
                return 5;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.overridecomment".equals(id)) {
                return 6;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.delegatecomment".equals(id)) {
                return 7;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.gettercomment".equals(id)) {
                return 8;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.settercomment".equals(id)) {
                return 9;
            }
            return 1000;
        }
    }

    private static class CodeTemplateLabelProvider
    extends LabelProvider {
        private CodeTemplateLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element == COMMENT_NODE || element == CODE_NODE) {
                return (String)element;
            }
            TemplatePersistenceData data = (TemplatePersistenceData)element;
            String id = data.getId();
            if ("org.eclipse.jdt.ui.text.codetemplates.catchblock".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_catchblock_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.methodbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_methodstub_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.constructorbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_constructorstub_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.getterbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_getterstub_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.setterbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_setterstub_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.newtype".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_newtype_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.classbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_classbody_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.interfacebody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_interfacebody_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.enumbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_enumbody_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.annotationbody".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_annotationbody_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.filecomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_filecomment_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.typecomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_typecomment_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.fieldcomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_fieldcomment_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.methodcomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_methodcomment_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.overridecomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_overridecomment_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.delegatecomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_delegatecomment_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.constructorcomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_constructorcomment_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.gettercomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_gettercomment_label;
            }
            if ("org.eclipse.jdt.ui.text.codetemplates.settercomment".equals(id)) {
                return PreferencesMessages.CodeTemplateBlock_settercomment_label;
            }
            return data.getTemplate().getDescription();
        }
    }
}

