/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.functions;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.php.internal.core.phpModel.parser.PHPWorkspaceModelManager;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.explorer.PHPTreeViewer;
import org.eclipse.php.internal.ui.functions.PHPFunctionsContentProvider;
import org.eclipse.php.internal.ui.functions.PHPFunctionsLabelProvider;
import org.eclipse.php.internal.ui.util.EditorUtility;
import org.eclipse.php.internal.ui.util.PHPElementLabels;
import org.eclipse.php.internal.ui.util.PHPManualFactory;
import org.eclipse.php.internal.ui.util.StatusBarUpdater;
import org.eclipse.php.internal.ui.workingset.FunctionsViewGroup;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPFunctionsPart
extends ViewPart
implements IMenuListener,
IPartListener {
    private PHPTreeViewer fViewer;
    private PHPFunctionsContentProvider fContentProvider;
    private PHPFunctionsLabelProvider fLabelProvider;
    private Menu fContextMenu;
    private String fWorkingSetName;
    private Action showFunctionHelpAction;
    private FunctionsViewGroup actionGroup;
    private boolean shouldRefresh = true;

    public void createPartControl(Composite composite) {
        this.fViewer = this.createViewer(composite);
        this.fViewer.setUseHashlookup(true);
        this.setProviders();
        this.setUpPopupMenu();
        this.actionGroup = new FunctionsViewGroup(this);
        this.addDoubleClickListener();
        this.addMouseTrackListener();
        this.getSite().getPage().addPartListener((IPartListener)this);
        IStatusLineManager iStatusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fViewer.addSelectionChangedListener(new StatusBarUpdater(iStatusLineManager));
        this.fViewer.getTree().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                Display.getCurrent().asyncExec(new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        if (!PHPFunctionsPart.access$0(1.access$0(this.this$1)).getTree().isDisposed() && (PHPFunctionsPart.access$1(1.access$0(this.this$1)) || PHPFunctionsPart.access$0(1.access$0(this.this$1)).getTree().getItems().length == 0)) {
                            PHPFunctionsPart.access$0(1.access$0(this.this$1)).refresh();
                            PHPFunctionsPart.access$2(1.access$0(this.this$1), false);
                        }
                    }
                });
            }

            public void focusLost(FocusEvent focusEvent) {
            }

            static /* synthetic */ PHPFunctionsPart access$0(1 var0) {
                return var0.PHPFunctionsPart.this;
            }
        });
        this.updateTitle();
    }

    private void setUpPopupMenu() {
        this.showFunctionHelpAction = new ShowFunctionHelpAction();
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener((IMenuListener)this);
        this.fContextMenu = menuManager.createContextMenu((Control)this.fViewer.getTree());
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                IStructuredSelection iStructuredSelection;
                ISelection iSelection = PHPFunctionsPart.this.fViewer.getSelection();
                if (!iSelection.isEmpty() && (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement() instanceof PHPFunctionData) {
                    iMenuManager.add((IAction)PHPFunctionsPart.this.showFunctionHelpAction);
                }
            }
        });
        this.fViewer.getTree().setMenu(this.fContextMenu);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        iWorkbenchPartSite.registerContextMenu(menuManager, (ISelectionProvider)this.fViewer);
        iWorkbenchPartSite.setSelectionProvider((ISelectionProvider)this.fViewer);
    }

    private void updateInputForCurrentEditor(IEditorPart iEditorPart) {
        this.actionGroup.handleUpdateInput(iEditorPart);
    }

    private PHPTreeViewer createViewer(Composite composite) {
        return new PHPTreeViewer(composite, 772);
    }

    private void addMouseTrackListener() {
        final Tree tree = this.fViewer.getTree();
        tree.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent mouseEvent) {
                Object object;
                TreeItem treeItem = tree.getItem(new Point(mouseEvent.x, mouseEvent.y));
                if (treeItem != null && (object = treeItem.getData()) instanceof PHPCodeData) {
                    tree.setToolTipText(PHPFunctionsPart.this.fLabelProvider.getTooltipText(object));
                }
            }
        });
    }

    private void addDoubleClickListener() {
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                PHPStructuredEditor pHPStructuredEditor = EditorUtility.getPHPStructuredEditor((IWorkbenchPart)PHPFunctionsPart.this.getViewSite().getPage().getActiveEditor());
                StructuredSelection structuredSelection = (StructuredSelection)PHPFunctionsPart.this.fViewer.getSelection();
                if (pHPStructuredEditor != null && pHPStructuredEditor instanceof ITextEditor && structuredSelection != null && !structuredSelection.isEmpty() && structuredSelection.getFirstElement() instanceof PHPCodeData) {
                    PHPCodeData pHPCodeData = (PHPCodeData)structuredSelection.getFirstElement();
                    ITextEditor iTextEditor = (ITextEditor)pHPStructuredEditor;
                    int n = ((ITextSelection)iTextEditor.getSelectionProvider().getSelection()).getOffset();
                    IDocument iDocument = iTextEditor.getDocumentProvider().getDocument((Object)iTextEditor.getEditorInput());
                    try {
                        iDocument.replace(n, 0, pHPCodeData.getName());
                    }
                    catch (BadLocationException badLocationException) {
                        Logger.logException(badLocationException);
                    }
                    iTextEditor.setFocus();
                    iTextEditor.getSelectionProvider().setSelection((ISelection)new TextSelection(iDocument, n + pHPCodeData.getName().length(), 0));
                }
            }
        });
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    private void setProviders() {
        this.fContentProvider = this.createContentProvider();
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fLabelProvider = this.createLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
    }

    void projectStateChanged(Object object) {
        Control control = this.fViewer.getControl();
        if (control != null && !control.isDisposed()) {
            this.fViewer.refresh(object, true);
            this.fViewer.setSelection(this.fViewer.getSelection());
        }
    }

    public PHPFunctionsContentProvider createContentProvider() {
        return new PHPFunctionsContentProvider();
    }

    private PHPFunctionsLabelProvider createLabelProvider() {
        return new PHPFunctionsLabelProvider(1090519051, 3, this.fContentProvider);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener((IPartListener)this);
        if (this.fContextMenu != null && !this.fContextMenu.isDisposed()) {
            this.fContextMenu.dispose();
        }
        super.dispose();
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart.equals((Object)this)) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    PHPFunctionsPart.this.setFocus();
                }
            });
        }
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
    }

    public void partClosed(IWorkbenchPart iWorkbenchPart) {
    }

    public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
    }

    public void partOpened(IWorkbenchPart object) {
        if (object.equals((Object)this) && this.getViewer().getInput() == null) {
            this.updateInputForCurrentEditor(null);
            this.setFocus();
        }
        object = EditorUtility.getPHPStructuredEditor(object);
        if (this.getViewer().getTree().getVisible() && object != null) {
            this.updateInputForCurrentEditor((IEditorPart)object);
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        PHPUiPlugin.createStandardGroups(iMenuManager);
    }

    void editorActivated(IEditorPart iEditorPart) {
    }

    public TreeViewer getViewer() {
        return this.fViewer;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collapseAll() {
        try {
            this.fViewer.getControl().setRedraw(false);
            this.fViewer.collapseToLevel(this.getViewPartInput(), -1);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.fViewer.getControl().setRedraw(true);
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.fViewer.getControl().setRedraw(true);
    }

    public Object getViewPartInput() {
        if (this.fViewer != null) {
            return this.fViewer.getInput();
        }
        return null;
    }

    String getFrameName(Object object) {
        if (object instanceof PHPCodeData) {
            return ((PHPCodeData)object).getName();
        }
        return this.fLabelProvider.getText(object);
    }

    String getToolTipText(Object object) {
        Object object2;
        String string = !(object instanceof IResource) ? (object instanceof PHPWorkspaceModelManager ? PHPUIMessages.PHPExplorerPart_workspace : (object instanceof PHPCodeData ? PHPElementLabels.getTextLabel(object, 1090519051L) : this.fLabelProvider.getText(object))) : ((object2 = ((IResource)object).getFullPath()).isRoot() ? PHPUIMessages.PHPExplorer_title : object2.makeRelative().toString());
        if (this.fWorkingSetName == null) {
            return string;
        }
        object2 = MessageFormat.format(PHPUIMessages.PHPExplorer_toolTip, this.fWorkingSetName);
        if (string.length() == 0) {
            return object2;
        }
        return MessageFormat.format(PHPUIMessages.PHPExplorer_toolTip2, string, this.fWorkingSetName);
    }

    void updateTitle() {
        Object object = this.fViewer.getInput();
        if (object == null || object instanceof PHPWorkspaceModelManager) {
            this.setContentDescription("");
            this.setTitleToolTip("");
        } else {
            String string = PHPElementLabels.getTextLabel(object, 1090519051L);
            this.setContentDescription(string);
            this.setTitleToolTip(this.getToolTipText(object));
        }
    }

    static /* synthetic */ boolean access$1(PHPFunctionsPart pHPFunctionsPart) {
        return pHPFunctionsPart.shouldRefresh;
    }

    static /* synthetic */ void access$2(PHPFunctionsPart pHPFunctionsPart, boolean bl) {
        pHPFunctionsPart.shouldRefresh = bl;
    }

    class ShowFunctionHelpAction
    extends Action {
        private final Pattern METHOD_PATTERN;

        public ShowFunctionHelpAction() {
            super("Open Manual");
            this.METHOD_PATTERN = Pattern.compile("([A-Z])");
        }

        public void run() {
            IStructuredSelection iStructuredSelection;
            ISelection iSelection = PHPFunctionsPart.this.fViewer.getSelection();
            if (!iSelection.isEmpty() && (iStructuredSelection = (IStructuredSelection)iSelection).getFirstElement() instanceof PHPFunctionData) {
                PHPFunctionData pHPFunctionData = (PHPFunctionData)iStructuredSelection.getFirstElement();
                PHPCodeData pHPCodeData = pHPFunctionData.getContainer();
                String string = "";
                if (pHPCodeData instanceof PHPClassData) {
                    Matcher matcher = this.METHOD_PATTERN.matcher(pHPFunctionData.getName());
                    string = String.valueOf(pHPCodeData.getName()) + "-" + matcher.replaceAll("-$1");
                } else {
                    string = pHPFunctionData.getName();
                }
                PHPManualFactory.getManual().showFunctionHelp(string);
            }
        }
    }
}

