/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.debugger.Breakpoint;

public class PHPLineBreakpoint
extends LineBreakpoint {
    protected Breakpoint fBreakpoint;
    protected boolean fConditionChanged = false;

    public PHPLineBreakpoint() {
    }

    public PHPLineBreakpoint(final IResource iResource, final int n) throws CoreException {
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                IMarker iMarker = iResource.createMarker("org.eclipse.php.debug.core.PHPConditionalBreakpointMarker");
                iMarker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
                iMarker.setAttribute("lineNumber", n);
                iMarker.setAttribute("org.eclipse.debug.core.id", (Object)PHPLineBreakpoint.this.getModelIdentifier());
                iMarker.setAttribute("message", (Object)MessageFormat.format(PHPDebugCoreMessages.LineBreakPointMessage_1, iResource.getName(), Integer.toString(n)));
                PHPLineBreakpoint.this.setMarker(iMarker);
                PHPLineBreakpoint.this.setEnabled(true);
                PHPLineBreakpoint.this.register(true);
            }
        };
        this.run(this.getMarkerRule(iResource), iWorkspaceRunnable);
    }

    protected void register(boolean bl) throws CoreException {
        if (bl) {
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    public String getModelIdentifier() {
        return "org.eclipse.php.debug.core";
    }

    protected void createRuntimeBreakpoint(IMarker iMarker) throws CoreException {
        Object object;
        IResource iResource = iMarker.getResource();
        String string = "";
        if (iResource instanceof IWorkspaceRoot) {
            string = (String)iMarker.getAttribute("org.eclipse.php.debug.core.Include_Storage");
        } else {
            object = (IFile)iResource;
            IPath iPath = object.getFullPath();
            string = iPath.lastSegment();
        }
        object = (Integer)iMarker.getAttribute("lineNumber");
        this.fBreakpoint = new Breakpoint(string, (Integer)object);
        this.fBreakpoint.setEnable(true);
    }

    public Breakpoint getRuntimeBreakpoint() {
        return this.fBreakpoint;
    }

    public void setMarker(IMarker iMarker) throws CoreException {
        super.setMarker(iMarker);
        this.createRuntimeBreakpoint(iMarker);
    }

    public void setEnabled(boolean bl) throws CoreException {
        super.setEnabled(bl);
    }

    public void setConditionChanged(boolean bl) {
        this.fConditionChanged = bl;
    }

    public boolean isConditionChanged() {
        return this.fConditionChanged;
    }
}

