/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaBuildingTools;
import org.w3c.dom.Text;

public class AddXSDModelGroupDefinitionCommand
extends BaseCommand {
    XSDConcreteComponent parent;
    boolean isReference;

    public AddXSDModelGroupDefinitionCommand(String label, XSDConcreteComponent parent, boolean isReference) {
        super(label);
        this.parent = parent;
        this.isReference = isReference;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        if (this.parent instanceof XSDSchema) {
            AddXSDModelGroupDefinitionCommand.ensureSchemaElement((XSDSchema)this.parent);
        }
        try {
            this.beginRecording(this.parent.getElement());
            if (!this.isReference) {
                XSDModelGroupDefinition def = this.createXSDModelGroupDefinition();
                this.addedXSDConcreteComponent = def;
            } else {
                XSDFactory factory = XSDSchemaBuildingTools.getXSDFactory();
                XSDModelGroupDefinition def = factory.createXSDModelGroupDefinition();
                XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
                particle.setContent((XSDParticleContent)def);
                EList list = this.parent.getSchema().getModelGroupDefinitions();
                if (list.size() > 0) {
                    def.setResolvedModelGroupDefinition((XSDModelGroupDefinition)list.get(0));
                } else {
                    XSDModelGroupDefinition newGroupDef = this.createXSDModelGroupDefinition();
                    def.setResolvedModelGroupDefinition(newGroupDef);
                }
                if (this.parent instanceof XSDModelGroup) {
                    ((XSDModelGroup)this.parent).getContents().add((Object)particle);
                }
                this.formatChild(def.getElement());
                this.addedXSDConcreteComponent = def;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.endRecording();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        this.endRecording();
    }

    protected XSDModelGroupDefinition createXSDModelGroupDefinition() {
        XSDFactory factory = XSDSchemaBuildingTools.getXSDFactory();
        XSDModelGroupDefinition def = factory.createXSDModelGroupDefinition();
        EList list = this.parent.getSchema().getModelGroupDefinitions();
        String newName = XSDCommonUIUtils.createUniqueElementName("ModelGroupDefinition", (List)list);
        def.setName(newName);
        XSDModelGroup modelGroup = this.createModelGroup();
        def.setModelGroup(modelGroup);
        Text textNode = this.parent.getSchema().getDocument().createTextNode("\n");
        this.parent.getSchema().getElement().appendChild(textNode);
        this.parent.getSchema().getContents().add((Object)def);
        this.formatChild(def.getElement());
        return def;
    }

    protected XSDModelGroup createModelGroup() {
        XSDFactory factory = XSDSchemaBuildingTools.getXSDFactory();
        XSDParticle particle = factory.createXSDParticle();
        XSDModelGroup modelGroup = factory.createXSDModelGroup();
        modelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        particle.setContent((XSDParticleContent)modelGroup);
        return modelGroup;
    }
}

