/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.internal.core.project.options.PHPProjectOptions;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.wizards.NewPhpTemplatesWizardPage;
import org.eclipse.php.internal.ui.wizards.PHPFileCreationWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class PHPFileCreationWizard
extends Wizard
implements INewWizard {
    protected PHPFileCreationWizardPage phpFileCreationWizardPage;
    private ISelection selection;
    protected NewPhpTemplatesWizardPage newPhpTemplatesWizardPage;

    public PHPFileCreationWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.phpFileCreationWizardPage = new PHPFileCreationWizardPage(this.selection);
        this.addPage((IWizardPage)this.phpFileCreationWizardPage);
        this.newPhpTemplatesWizardPage = new NewPhpTemplatesWizardPage();
        this.addPage((IWizardPage)this.newPhpTemplatesWizardPage);
    }

    public boolean performFinish() {
        final String string = this.phpFileCreationWizardPage.getContainerName();
        final String string2 = this.phpFileCreationWizardPage.getFileName();
        final String string3 = this.newPhpTemplatesWizardPage.getTemplateString();
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    try {
                        PHPFileCreationWizard.this.doFinish(string, string2, iProgressMonitor, string3);
                    }
                    catch (CoreException coreException) {
                        throw new InvocationTargetException(coreException);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    iProgressMonitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                iProgressMonitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)throwable.getMessage());
            return false;
        }
        return true;
    }

    protected void doFinish(String string, String string2, IProgressMonitor iProgressMonitor, String string3) throws CoreException {
        InputStream inputStream;
        iProgressMonitor.beginTask(NLS.bind((String)PHPUIMessages.newPhpFile_create, (Object)string2), 2);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource iResource = iWorkspaceRoot.findMember((IPath)new Path(string));
        if (!iResource.exists() || !(iResource instanceof IContainer)) {
            this.throwCoreException("Container \"" + string + "\" does not exist.");
        }
        IContainer iContainer = (IContainer)iResource;
        final IFile iFile = iContainer.getFile((IPath)new Path(string2));
        try {
            inputStream = this.openContentStream(string3);
            if (iFile.exists()) {
                iFile.setContents(inputStream, true, true, iProgressMonitor);
            } else {
                iFile.create(inputStream, true, iProgressMonitor);
            }
            inputStream.close();
        }
        catch (IOException iOException) {}
        if (iContainer instanceof IProject && (inputStream = PHPProjectOptions.forProject((IProject)((IProject)iContainer))) != null) {
            String string4 = (String)inputStream.getOption("org.eclipse.php.core.defaultEncoding");
            if (string4 == null || string4.length() == 0) {
                string4 = iContainer.getDefaultCharset();
            }
            iFile.setCharset(string4, iProgressMonitor);
        }
        iProgressMonitor.worked(1);
        iProgressMonitor.setTaskName(NLS.bind((String)PHPUIMessages.newPhpFile_openning, (Object)string2));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)iFile, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        iProgressMonitor.worked(1);
    }

    private InputStream openContentStream(String string) {
        if (string == null) {
            string = "";
        }
        return new ByteArrayInputStream(string.getBytes());
    }

    private void throwCoreException(String string) throws CoreException {
        Status status = new Status(4, "TestProject", 0, string, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.selection = iStructuredSelection;
    }
}

