/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.documentModel.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Segment;
import org.eclipse.core.resources.IProject;
import org.eclipse.php.internal.core.documentModel.parser.Scanner;
import org.eclipse.php.internal.core.documentModel.parser.StateStack;
import org.eclipse.php.internal.core.documentModel.parser.regions.PHPRegionTypes;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.preferences.TaskPatternsProvider;
import org.eclipse.php.internal.core.util.collections.IntHashtable;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public abstract class PhpLexer
implements Scanner,
PHPRegionTypes {
    private static final IntHashtable lexerStates = new IntHashtable(100);
    public static final int ST_PHP_BACKQUOTE = 8;
    public static final int ST_PHP_COMMENT = 16;
    public static final int ST_PHP_DOC_COMMENT = 18;
    public static final int ST_PHP_DOUBLE_QUOTES = 4;
    public static final int ST_PHP_HEREDOC = 12;
    public static final int ST_PHP_IN_SCRIPTING = 2;
    public static final int ST_PHP_LINE_COMMENT = 20;
    public static final int ST_PHP_SINGLE_QUOTE = 6;
    public static final int YYEOF = -1;
    protected boolean asp_tags = true;
    protected int defaultReturnValue = -1;
    protected int firstPos = -1;
    protected String heredoc = null;
    protected int heredoc_len = 0;
    protected StateStack phpStack;
    public LinkedList bufferedTokens = null;
    public int bufferedLength;
    public Object bufferedState;
    private Pattern[] todos;

    protected abstract char[] getYy_buffer();

    protected abstract int getYy_endRead();

    protected abstract int getYy_lexical_state();

    protected abstract int getYy_markedPos();

    protected abstract int getYy_pushBackPosition();

    protected abstract int getYy_startRead();

    protected abstract void pushBack(int var1);

    public abstract void yybegin(int var1);

    public abstract int yylength();

    public abstract String yytext();

    public abstract void reset(Reader var1, char[] var2, int[] var3);

    public abstract int yystate();

    public abstract int[] getParamenters();

    protected static final boolean isLowerCase(String string) {
        if (string == null) {
            return false;
        }
        int n = 0;
        while (n < string.length()) {
            if (!Character.isLowerCase(string.charAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private int buildStateKey() {
        int n = this.getYy_lexical_state();
        int n2 = 0;
        while (n2 < this.phpStack.size()) {
            n = 31 * n + this.phpStack.get(n2);
            ++n2;
        }
        if (this.heredoc != null) {
            n2 = 0;
            while (n2 < this.heredoc.length()) {
                n = 31 * n + this.heredoc.charAt(n2);
                ++n2;
            }
        }
        return n;
    }

    public Object createLexicalStateMemento() {
        if (this.bufferedTokens != null && !this.bufferedTokens.isEmpty()) {
            return this.bufferedState;
        }
        int n = this.buildStateKey();
        Object object = lexerStates.get(n);
        if (object == null) {
            object = new BasicLexerState();
            if (this.getYy_lexical_state() == 12) {
                object = new HeredocState((BasicLexerState)object);
            }
            lexerStates.put(n, object);
        }
        return object;
    }

    public boolean getAspTags() {
        return this.asp_tags;
    }

    public Object getEndingState() throws IOException {
        this.lexToEnd();
        return this.createLexicalStateMemento();
    }

    public int getFirstIndex() {
        return this.firstPos;
    }

    public int getMarkedPos() {
        return this.getYy_markedPos();
    }

    public void getText(int n, int n2, Segment segment) {
        if (n + n2 > this.getYy_endRead()) {
            throw new RuntimeException("bad segment !!");
        }
        segment.array = this.getYy_buffer();
        segment.offset = n;
        segment.count = n2;
    }

    public int getTokenStart() {
        return this.getYy_startRead() - this.getYy_pushBackPosition();
    }

    public void reset(Segment segment) {
        this.reset(segment.array, segment.offset, segment.count);
    }

    public void initialize(int n) {
        this.phpStack = new StateStack();
        this.yybegin(n);
    }

    public String lexToEnd() throws IOException {
        String string;
        String string2 = string = this.yylex();
        while (string != null) {
            string2 = string;
            string = this.yylex();
        }
        return string2;
    }

    public String lexToTokenAt(int n) throws IOException {
        if (this.firstPos + n < this.getYy_markedPos()) {
            throw new RuntimeException("Bad offset");
        }
        String string = this.yylex();
        while (this.getYy_markedPos() < this.firstPos + n && string != null) {
            string = this.yylex();
        }
        return string;
    }

    protected void popState() {
        this.yybegin(this.phpStack.popStack());
    }

    protected void pushState(int n) {
        this.phpStack.pushStack(this.getYy_lexical_state());
        this.yybegin(n);
    }

    public void setAspTags(boolean bl) {
        this.asp_tags = bl;
    }

    public void setState(Object object) {
        ((Scanner.LexerState)object).restoreState(this);
    }

    public int yystart() {
        return this.getYy_startRead();
    }

    public String getNextToken() throws IOException {
        if (this.bufferedTokens != null) {
            if (this.bufferedTokens.isEmpty()) {
                this.bufferedTokens = null;
            } else {
                return this.removeFromBuffer();
            }
        }
        this.bufferedState = this.createLexicalStateMemento();
        String string = this.yylex();
        if (PHPPartitionTypes.isPHPDocCommentState(string)) {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (PHPPartitionTypes.isPHPDocCommentState(string)) {
                stringBuffer.append(this.yytext());
                string = this.yylex();
                ++n;
            }
            this.bufferedTokens = new LinkedList();
            this.checkForTodo(this.bufferedTokens, "PHPDOC_COMMENT", 0, n, stringBuffer.toString());
            this.bufferedTokens.add(new ContextRegion(string, 0, this.yylength(), this.yylength()));
            string = this.removeFromBuffer();
        } else if (PHPPartitionTypes.isPHPCommentState(string)) {
            this.bufferedTokens = new LinkedList();
            this.checkForTodo(this.bufferedTokens, string, 0, this.yylength(), this.yytext());
            string = this.removeFromBuffer();
        }
        if (string == "PHP_CLOSETAG") {
            this.pushBack(this.getLength());
        }
        return string;
    }

    private String removeFromBuffer() {
        ITextRegion iTextRegion = (ITextRegion)this.bufferedTokens.removeFirst();
        this.bufferedLength = iTextRegion.getLength();
        return iTextRegion.getType();
    }

    public int getLength() {
        return this.bufferedTokens == null ? this.yylength() : this.bufferedLength;
    }

    public void setPatterns(IProject iProject) {
        this.todos = iProject != null ? TaskPatternsProvider.getInstance().getPatternsForProject(iProject) : TaskPatternsProvider.getInstance().getPetternsForWorkspace();
    }

    private void checkForTodo(List list, String string, int n, int n2, String string2) {
        int n3;
        ArrayList arrayList = this.createMatcherList(string2);
        int n4 = 0;
        Matcher matcher = this.getMinimalMatcher(arrayList, n4);
        ContextRegion contextRegion = null;
        while (matcher != null) {
            n3 = matcher.start();
            int n5 = matcher.end();
            if (n3 != n4) {
                contextRegion = new ContextRegion(string, n + n4, n3 - n4, n3 - n4);
                list.add(contextRegion);
            }
            contextRegion = new ContextRegion("TASK", n + n3, n5 - n3, n5 - n3);
            list.add(contextRegion);
            n4 = n5;
            matcher = this.getMinimalMatcher(arrayList, n4);
        }
        n3 = n2 - n4;
        list.add(new ContextRegion(string, n + n4, n3, n3));
    }

    private ArrayList createMatcherList(String string) {
        ArrayList<Matcher> arrayList = new ArrayList<Matcher>(this.todos.length);
        int n = 0;
        while (n < this.todos.length) {
            arrayList.add(n, this.todos[n].matcher(string));
            ++n;
        }
        return arrayList;
    }

    private Matcher getMinimalMatcher(ArrayList arrayList, int n) {
        Matcher matcher = null;
        int n2 = arrayList.size();
        int n3 = 0;
        while (n3 < n2) {
            Matcher matcher2 = (Matcher)arrayList.get(n3);
            if (matcher2.find(n)) {
                if (matcher == null || matcher2.start() < matcher.start()) {
                    matcher = matcher2;
                }
                ++n3;
                continue;
            }
            arrayList.remove(n3);
            --n2;
        }
        return matcher;
    }

    private class BasicLexerState
    implements Scanner.LexerState {
        private final byte lexicalState;
        private StateStack phpStack;

        public BasicLexerState() {
            this.lexicalState = (byte)PhpLexer.this.getYy_lexical_state();
            if (!PhpLexer.this.phpStack.isEmpty()) {
                this.phpStack = PhpLexer.this.phpStack.createClone();
            }
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof BasicLexerState)) {
                return false;
            }
            BasicLexerState basicLexerState = (BasicLexerState)object;
            if (basicLexerState.lexicalState != this.lexicalState) {
                return false;
            }
            if (this.phpStack != null && !this.phpStack.equals(basicLexerState.phpStack)) {
                return false;
            }
            return this.phpStack == basicLexerState.phpStack;
        }

        public boolean equalsCurrentStack(Scanner.LexerState lexerState) {
            StateStack stateStack;
            if (lexerState == this) {
                return true;
            }
            if (lexerState == null) {
                return false;
            }
            if (!(lexerState instanceof BasicLexerState)) {
                return false;
            }
            BasicLexerState basicLexerState = (BasicLexerState)lexerState;
            if (basicLexerState.lexicalState != this.lexicalState) {
                return false;
            }
            StateStack stateStack2 = this.getActiveStack();
            return stateStack2 == (stateStack = basicLexerState.getActiveStack()) || stateStack2 != null && stateStack2.equals(stateStack);
        }

        public boolean equalsTop(Scanner.LexerState lexerState) {
            return lexerState != null && lexerState.getTopState() == this.lexicalState;
        }

        protected StateStack getActiveStack() {
            return this.phpStack;
        }

        public int getTopState() {
            return this.lexicalState;
        }

        public boolean isSubstateOf(int n) {
            if (this.lexicalState == n) {
                return true;
            }
            StateStack stateStack = this.getActiveStack();
            if (stateStack == null) {
                return false;
            }
            return stateStack.contains(n);
        }

        public void restoreState(Scanner scanner) {
            PhpLexer phpLexer = (PhpLexer)scanner;
            if (this.phpStack == null) {
                phpLexer.phpStack.clear();
            } else {
                phpLexer.phpStack.copyFrom(this.phpStack);
            }
            phpLexer.yybegin(this.lexicalState);
        }

        public String toString() {
            StateStack stateStack = this.getActiveStack();
            String string = stateStack == null ? "null" : stateStack.toString();
            return "Stack: " + string + ", currState: " + this.lexicalState;
        }
    }

    private class HeredocState
    implements Scanner.LexerState {
        private String myHeredoc;
        private BasicLexerState theState;

        public HeredocState(BasicLexerState basicLexerState) {
            this.theState = basicLexerState;
            this.myHeredoc = PhpLexer.this.heredoc;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            HeredocState heredocState = (HeredocState)object;
            if (this.myHeredoc == null ? heredocState.myHeredoc != null : !this.myHeredoc.equals(heredocState.myHeredoc)) {
                return false;
            }
            return !(this.theState == null ? heredocState.theState != null : !this.theState.equals(heredocState.theState));
        }

        public boolean equalsCurrentStack(Scanner.LexerState lexerState) {
            if (lexerState == this) {
                return true;
            }
            if (lexerState == null) {
                return false;
            }
            if (!(lexerState instanceof HeredocState)) {
                return false;
            }
            return this.theState.equals(((HeredocState)lexerState).theState);
        }

        public boolean equalsTop(Scanner.LexerState lexerState) {
            return this.theState.equalsTop(lexerState);
        }

        public int getTopState() {
            return this.theState.getTopState();
        }

        public boolean isSubstateOf(int n) {
            return this.theState.isSubstateOf(n);
        }

        public void restoreState(Scanner scanner) {
            PhpLexer phpLexer = (PhpLexer)scanner;
            this.theState.restoreState(phpLexer);
            phpLexer.heredoc = this.myHeredoc;
            phpLexer.heredoc_len = this.myHeredoc.length();
        }
    }
}

