/*******************************************************************************
 * Copyright (c) 2006 Zend Corporation and IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zend and IBM - Initial implementation
 *******************************************************************************/
/* The following code was generated by JFlex 1.3.5 on 13:44 17/11/05 */

package org.eclipse.php.internal.core.phpModel.parser.phpdoc;

import java.io.IOException;
import java.util.ArrayList;

import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.phpModel.phpElementData.BasicPHPDocTag;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlock;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPDocBlockImp;



/**
 * This class is a scanner generated by 
 * <a href="http://www.jflex.de/">JFlex</a> 1.3.5
 * on 13:44 17/11/05 from the specification file
 * <tt>file:/C:/Java/StudioEclipse/com.zend.ide/src/com/zend/ide/classbrowser/phpdoc/documentor_scanner.flex</tt>
 */
public class DocumentorLexer {

  /** This character denotes the end of file */
  final public static int YYEOF = -1;

  /** initial size of the lookahead buffer */
  final private static int YY_BUFFERSIZE = 16384;

  /** lexical states */
  final public static int ST_IN_TAGS = 6;
  final public static int YYINITIAL = 0;
  final public static int ST_IN_SHORT_DESC = 2;
  final public static int ST_IN_LONG_DESC = 4;

  /**
   * YY_LEXSTATE[l] is the state in the DFA for the lexical state l
   * YY_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private final static int YY_LEXSTATE[] = { 
     0,  1,  2,  3,  4,  5,  6, 7
  };

  /** 
   * Translates characters to character classes
   */
  final private static String yycmap_packed = 
    "\11\0\1\1\1\2\2\0\1\3\22\0\1\1\11\0\1\4\3\0"+
    "\1\6\1\5\20\0\1\7\1\10\1\11\1\15\1\26\1\16\1\32"+
    "\1\22\1\20\1\25\1\0\1\34\1\31\1\30\1\33\1\21\1\24"+
    "\1\0\1\14\1\12\1\13\1\17\1\35\1\0\1\27\1\23\7\0"+
    "\1\10\1\11\1\15\1\26\1\16\1\32\1\22\1\20\1\25\1\0"+
    "\1\34\1\31\1\30\1\33\1\21\1\24\1\0\1\14\1\12\1\13"+
    "\1\17\1\35\1\0\1\27\1\23\uff86\0";

  /** 
   * Translates characters to character classes
   */
  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);

  /** 
   * Translates a state to a row index in the transition table
   */
  final private static int yy_rowMap [] = { 
        0,    30,    60,    90,   120,   150,   180,   210,   240,   270, 
      300,   240,   330,   360,   390,   420,   240,   450,   480,   510, 
      540,   240,   570,   600,   630,   660,   690,   720,   750,   780, 
      810,   840,   300,   360,   240,   240,   870,   900,   420,   480, 
      510,   930,   240,   960,   990,  1020,  1050,  1080,  1110,  1140, 
     1170,  1200,  1230,  1260,  1290,  1320,  1350,  1380,   540,   600, 
      240,  1410,   690,   720,   240,   810,  1440,  1470,  1500,  1530, 
     1560,  1590,  1620,  1650,  1680,  1710,  1740,  1770,  1800,  1830, 
     1860,  1890,  1920,  1950,  1980,  2010,  2040,  2070,  2100,  2130, 
     2160,  2190,  2220,  2250,  2280,  2310,  2340,  2370,  2400,  2430, 
     2460,  2490,  2520,  2550,  2580,  2610,  2640,  2670,  2700,  2730, 
     2760,  2790,  2820,  2850,  2880,  2910,  2940,  2970,  3000,  3030, 
     3060,  3090,  3120,  3150,  3180,  3210,  3240,  3270,  3300,  3330, 
     3360,   240,  3390,  3420,  3450,  3480,  3510,   240,  3540,  3570, 
     3600,  3630,  3660,  3690,  3720,  3750,  3780,  3810,  3840,  3870, 
     3900,  3930,  3960,  3990,  4020,  4050,  4080,  4110,  4140,   240, 
     4170,  4200,  4230,  4260,  4290,   240,  4320,  4350,  4380,  4410, 
     4440,  4470,  4500,  4530,  4560,  4590,  4620,  4650,  4680,  4710, 
     4740,  4770,  4800,  4830,  4860,  4890,  4920,   240,  4950,  4980, 
     5010,  5040,  5070,  5100,  5130,  5160,   240,  5190,  5220,  5250, 
     5280,   240,  5310,  5340,  5370,  5400,  5430,   240,  5460,  5490, 
      240,  5520,  5550,   240,  5580,  5610,  5640,  5670,  5700,  5730, 
     5760,  5790,   240,  5820,  5850,  5880,  5910,   240,  5940,  5970, 
     6000,  6030,  6060,   240,  6090,  6120,   240,  6150,  6180,   240, 
     6210,  6240,  6270,  6300,  6330,  6360,   240,  6390,  6420,  6450, 
     6480,  6510,  6540,   240,  6570,  6600,  6630,  6660,  6690,  6720, 
      240,  6750,  6780,  6810,  6840,  6870,  6900,   240,  6930,  6960, 
     6990,  7020,  7050,  7080,   240,  7110,  7140,  7170,  7200,  7230, 
     7260,   240,  7290,  7320,   240,   240,  7350,  7380,  7410,   240, 
     7440,  7470,  7500,   240,  7530,   240,  7560,  7590,  7620,  7650, 
     7680,  7710,   240,   240,  7740,  7770,  7800,   240,  7830,  7860, 
     7890,   240,  7920,   240,  7950,  7980,  8010,  8040,  8070,  8100, 
     8130,  8160,  8190,  8220,  8250,   240,   240,  8280,  8310,   240, 
     8340,   240,  8370,  8400,  8430,  8460,  8490,  8520,   240,   240, 
     8550,  8580,   240,  8610,   240,   240,  8640,  8670,   240,   240, 
     8700,   240,  8730,  8760,   240,  8790,  8820,   240,   240,  8850, 
      240,  8880,  8910,   240,  8940,   240,  8970,  9000,   240,  9030, 
      240,  9060,  9090,   240,   240,   240,   240,   240,   240
  };

  /** 
   * The packed transition table of the DFA (part 0)
   */
  final private static String yy_packed0 = 
    "\43\11\1\12\31\11\1\13\1\14\1\15\1\16\1\11"+
    "\1\17\30\11\1\20\1\21\1\22\1\23\1\11\1\17"+
    "\1\24\27\11\1\25\1\26\1\27\1\30\32\11\1\31"+
    "\1\26\1\27\1\32\2\11\1\24\27\11\1\33\1\26"+
    "\1\27\1\34\32\11\1\35\1\26\1\27\1\36\2\11"+
    "\1\37\26\11\42\0\1\40\32\0\1\41\2\0\1\42"+
    "\1\0\1\43\31\0\1\14\40\0\1\44\31\0\1\45"+
    "\1\43\1\46\33\0\1\47\1\21\1\22\1\50\1\0"+
    "\1\43\1\51\30\0\1\21\34\0\1\52\1\21\1\22"+
    "\1\0\1\53\1\0\1\51\36\0\1\54\1\0\1\55"+
    "\1\56\1\57\1\60\1\61\1\62\2\0\1\63\1\0"+
    "\1\64\1\65\1\66\2\0\1\67\1\70\1\71\1\0"+
    "\1\72\1\0\1\73\2\0\1\74\33\0\1\26\40\0"+
    "\1\75\31\0\1\31\2\0\1\32\2\0\1\51\27\0"+
    "\1\76\3\0\1\75\1\0\1\51\27\0\1\77\2\0"+
    "\1\100\36\0\1\101\31\0\1\35\2\0\1\36\2\0"+
    "\1\102\27\0\1\103\3\0\1\101\1\0\1\102\36\0"+
    "\1\104\1\0\1\105\1\106\1\107\1\110\1\111\1\112"+
    "\2\0\1\113\1\0\1\114\1\115\1\116\2\0\1\117"+
    "\1\120\1\121\1\0\1\122\4\0\1\123\32\0\1\45"+
    "\36\0\1\43\34\0\1\52\1\21\1\22\3\0\1\51"+
    "\37\0\1\124\3\0\1\125\1\0\1\126\31\0\1\127"+
    "\2\0\1\130\1\131\5\0\1\132\27\0\1\133\1\0"+
    "\1\134\32\0\1\135\27\0\1\136\10\0\1\137\43\0"+
    "\1\140\20\0\1\141\54\0\1\142\14\0\1\143\47\0"+
    "\1\144\10\0\1\145\20\0\1\146\44\0\1\147\35\0"+
    "\1\150\20\0\1\151\35\0\1\152\5\0\1\153\20\0"+
    "\1\76\5\0\1\51\27\0\1\103\5\0\1\102\37\0"+
    "\1\154\3\0\1\155\1\0\1\156\31\0\1\157\2\0"+
    "\1\160\1\161\5\0\1\162\27\0\1\163\1\0\1\164"+
    "\32\0\1\165\27\0\1\166\10\0\1\167\43\0\1\170"+
    "\20\0\1\171\54\0\1\172\14\0\1\173\47\0\1\174"+
    "\10\0\1\175\20\0\1\176\44\0\1\177\35\0\1\200"+
    "\20\0\1\201\35\0\1\202\5\0\1\203\20\0\1\123"+
    "\1\204\1\205\44\0\1\206\40\0\1\207\33\0\1\210"+
    "\32\0\1\211\43\0\1\212\30\0\1\213\57\0\1\214"+
    "\15\0\1\215\50\0\1\216\22\0\1\217\35\0\1\220"+
    "\46\0\1\221\21\0\1\222\43\0\1\223\40\0\1\224"+
    "\30\0\1\225\1\226\53\0\1\227\15\0\1\230\34\0"+
    "\1\231\11\0\1\232\26\0\1\233\15\0\1\234\33\0"+
    "\1\235\1\0\1\236\32\0\1\237\21\0\1\240\35\0"+
    "\1\241\33\0\1\242\40\0\1\243\33\0\1\244\32\0"+
    "\1\245\43\0\1\246\30\0\1\247\57\0\1\250\15\0"+
    "\1\251\50\0\1\252\22\0\1\253\35\0\1\254\46\0"+
    "\1\255\21\0\1\256\43\0\1\257\40\0\1\260\30\0"+
    "\1\261\1\262\53\0\1\263\15\0\1\264\34\0\1\265"+
    "\11\0\1\266\26\0\1\267\15\0\1\270\33\0\1\271"+
    "\1\0\1\272\32\0\1\273\21\0\1\274\35\0\1\275"+
    "\23\0\1\204\46\0\1\276\40\0\1\277\37\0\1\300"+
    "\30\0\1\301\46\0\1\302\26\0\1\303\41\0\1\304"+
    "\35\0\1\305\33\0\1\306\34\0\1\307\42\0\1\310"+
    "\42\0\1\311\17\0\1\312\34\0\1\313\34\0\1\314"+
    "\61\0\1\315\22\0\1\316\32\0\1\317\34\0\1\320"+
    "\34\0\1\321\37\0\1\322\53\0\1\323\17\0\1\324"+
    "\27\0\1\325\43\0\1\326\31\0\1\327\36\0\1\330"+
    "\40\0\1\331\37\0\1\332\30\0\1\333\46\0\1\334"+
    "\26\0\1\335\41\0\1\336\35\0\1\337\33\0\1\340"+
    "\34\0\1\341\42\0\1\342\42\0\1\343\17\0\1\344"+
    "\34\0\1\345\34\0\1\346\61\0\1\347\22\0\1\350"+
    "\32\0\1\351\34\0\1\352\34\0\1\353\37\0\1\354"+
    "\53\0\1\355\17\0\1\356\27\0\1\357\43\0\1\360"+
    "\31\0\1\361\37\0\1\362\33\0\1\363\44\0\1\364"+
    "\41\0\1\365\20\0\1\366\43\0\1\367\33\0\1\370"+
    "\35\0\1\371\43\0\1\372\27\0\1\373\45\0\1\374"+
    "\21\0\1\375\55\0\1\376\15\0\1\377\41\0\1\u0100"+
    "\35\0\1\u0101\37\0\1\u0102\52\0\1\u0103\14\0\1\u0104"+
    "\54\0\1\u0105\31\0\1\u0106\24\0\1\u0107\33\0\1\u0108"+
    "\44\0\1\u0109\41\0\1\u010a\20\0\1\u010b\43\0\1\u010c"+
    "\33\0\1\u010d\35\0\1\u010e\43\0\1\u010f\27\0\1\u0110"+
    "\45\0\1\u0111\21\0\1\u0112\55\0\1\u0113\15\0\1\u0114"+
    "\41\0\1\u0115\35\0\1\u0116\37\0\1\u0117\52\0\1\u0118"+
    "\14\0\1\u0119\54\0\1\u011a\31\0\1\u011b\20\0\1\u011c"+
    "\37\0\1\u011d\37\0\1\u011e\36\0\1\u011f\35\0\1\u0120"+
    "\45\0\1\u0121\43\0\1\u0122\23\0\1\u0123\41\0\1\u0124"+
    "\41\0\1\u0125\35\0\1\u0126\26\0\1\u0127\31\0\1\u0128"+
    "\52\0\1\u0129\17\0\1\u012a\32\0\1\u012b\44\0\1\u012c"+
    "\35\0\1\u012d\24\0\1\u012e\37\0\1\u012f\37\0\1\u0130"+
    "\36\0\1\u0131\35\0\1\u0132\45\0\1\u0133\43\0\1\u0134"+
    "\23\0\1\u0135\41\0\1\u0136\41\0\1\u0137\35\0\1\u0138"+
    "\26\0\1\u0139\31\0\1\u013a\52\0\1\u013b\17\0\1\u013c"+
    "\32\0\1\u013d\44\0\1\u013e\35\0\1\u013f\31\0\1\u0140"+
    "\55\0\1\u0141\34\0\1\u0142\11\0\1\u0143\41\0\1\u0144"+
    "\43\0\1\u0145\31\0\1\u0146\35\0\1\u0147\27\0\1\u0148"+
    "\35\0\1\u0149\43\0\1\u014a\36\0\1\u014b\51\0\1\u014c"+
    "\17\0\1\u014d\55\0\1\u014e\34\0\1\u014f\11\0\1\u0150"+
    "\41\0\1\u0151\43\0\1\u0152\31\0\1\u0153\35\0\1\u0154"+
    "\27\0\1\u0155\35\0\1\u0156\43\0\1\u0157\36\0\1\u0158"+
    "\51\0\1\u0159\15\0\1\u015a\32\0\1\u015b\35\0\1\u015c"+
    "\56\0\1\u015d\27\0\1\u015e\32\0\1\u015f\46\0\1\u0160"+
    "\17\0\1\u0161\36\0\1\u0162\34\0\1\u0163\32\0\1\u0164"+
    "\35\0\1\u0165\56\0\1\u0166\27\0\1\u0167\32\0\1\u0168"+
    "\46\0\1\u0169\17\0\1\u016a\36\0\1\u016b\35\0\1\u016c"+
    "\43\0\1\u016d\26\0\1\u016e\40\0\1\u016f\34\0\1\u0170"+
    "\34\0\1\u0171\43\0\1\u0172\26\0\1\u0173\40\0\1\u0174"+
    "\34\0\1\u0175\36\0\1\u0176\45\0\1\u0177\25\0\1\u0178"+
    "\35\0\1\u0179\45\0\1\u017a\25\0\1\u017b\17\0";

  /** 
   * The transition table of the DFA
   */
  final private static int yytrans [] = yy_unpack();


  /* error codes */
  final private static int YY_UNKNOWN_ERROR = 0;
  final private static int YY_ILLEGAL_STATE = 1;
  final private static int YY_NO_MATCH = 2;
  final private static int YY_PUSHBACK_2BIG = 3;

  /* error messages for the codes above */
  final private static String YY_ERROR_MSG[] = {
    "Unkown internal scanner error",
    "Internal error: unknown state",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private final static byte YY_ATTRIBUTE[] = {
     0,  0,  0,  1,  0,  1,  0,  1,  9,  1,  1,  9,  1,  1,  1,  1, 
     9,  1,  1,  1,  1,  9,  1,  1,  1,  1,  1,  1,  1,  1,  1,  0, 
     0,  0,  9,  9,  1,  1,  1,  1,  0,  1,  9,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  9,  1,  0,  0, 
     9,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  9,  1,  0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  9, 
     0,  0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0, 
     0,  0,  0,  0,  9,  0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  9, 
     0,  0,  9,  0,  0,  9,  0,  0,  0,  0,  0,  0,  0,  0,  9,  0, 
     0,  0,  0,  9,  0,  0,  0,  0,  0,  9,  0,  0,  9,  0,  0,  9, 
     0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  9,  0,  0, 
     0,  0,  0,  0,  9,  0,  0,  0,  0,  0,  0,  9,  0,  0,  0,  0, 
     0,  0,  9,  0,  0,  0,  0,  0,  0,  9,  0,  0,  9,  9,  1,  0, 
     0,  9,  0,  0,  0,  9,  0,  9,  0,  0,  0,  0,  0,  0,  9,  9, 
     1,  0,  0,  9,  0,  0,  0,  9,  0,  9,  0,  0,  0,  0,  0,  0, 
     0,  0,  0,  0,  0,  9,  9,  0,  0,  9,  0,  9,  0,  0,  0,  0, 
     0,  0,  9,  9,  0,  0,  9,  0,  9,  9,  0,  0,  9,  9,  0,  9, 
     0,  0,  9,  0,  0,  9,  9,  0,  9,  0,  0,  9,  0,  9,  0,  0, 
     9,  0,  9,  0,  0,  9,  9,  9,  9,  9,  9
  };

  /** the input device */
  private java.io.Reader yy_reader;

  /** the current state of the DFA */
  private int yy_state;

  /** the current lexical state */
  private int yy_lexical_state = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private char yy_buffer[] = new char[YY_BUFFERSIZE];

  /** the textposition at the last accepting state */
  private int yy_markedPos;

  /** the textposition at the last state to be included in yytext */
  private int yy_pushbackPos;

  /** the current text position in the buffer */
  private int yy_currentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int yy_startRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int yy_endRead;

  /** number of newlines encountered up to the start of the matched text */
  private int yyline;

  /** the number of characters up to the start of the matched text */
  private int yychar;

  /**
   * the number of characters from the last newline up to the start of the 
   * matched text
   */
  private int yycolumn; 

  /** 
   * yy_atBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean yy_atBOL = true;

  /** yy_atEOF == true <=> the scanner is at the EOF */
  private boolean yy_atEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean yy_eof_done;

  /* user code: */
    private String shortDesc = null;
    private String longDesc = null;
    private ArrayList tagList = null;
    private int currTagId = 0;
    private StringBuffer sBuffer = null;
    private int numOfLines = 0;
    private int startPos = 0;

    public PHPDocBlock parse (){

        longDesc = "";
        tagList = new ArrayList();
        sBuffer = new StringBuffer();
        numOfLines = 1;

        //start parsing
        while ( !yy_atEOF )
            try {
                next_token();
            } catch (IOException e) {
                Logger.logException(e);
            }

        BasicPHPDocTag[] tags = new BasicPHPDocTag[tagList.size()];
        tagList.toArray(tags);

        PHPDocBlockImp rv = new PHPDocBlockImp(shortDesc, longDesc, tags, 0);

        return rv;

    }

    private void startTagsState(String firstState){
        updateStartPos();
        hendleDesc();
        currTagId = BasicPHPDocTag.getID(firstState);
        sBuffer = new StringBuffer();
        yybegin(ST_IN_TAGS);
    }

    private void setNewTag(String newTag){
       updateStartPos();
       setTagValue();

       sBuffer = new StringBuffer();
       currTagId = BasicPHPDocTag.getID(newTag);
    }

    private void setTagValue(){
        String value = sBuffer.toString().trim();
        // special case for backward compatibility
        if (currTagId == BasicPHPDocTag.DESC) {
            shortDesc = shortDesc + value;
            return;
        }

        BasicPHPDocTag basicPHPDocTag = new BasicPHPDocTag(currTagId,value);
        tagList.add(basicPHPDocTag);
    }

    private void appendText(){
       sBuffer.append(yy_buffer, startPos, yy_markedPos-startPos);
       updateStartPos();
    }

    private void hendleDesc() {
        if(yy_lexical_state == ST_IN_SHORT_DESC){
            shortDesc = sBuffer.toString().trim();
        }
        else{
            longDesc = sBuffer.toString().trim();
        }

        sBuffer = new StringBuffer();
    }

    private void startLongDescState() {
        hendleDesc();
        updateStartPos();
        yybegin(ST_IN_LONG_DESC);
    }

    private void hendleNewLine() {
        appendText();
        if(numOfLines==4){
            int firstLineEnd = sBuffer.indexOf("\n",1);
            shortDesc = sBuffer.substring(0,firstLineEnd);
            shortDesc = shortDesc.trim();
            sBuffer.delete(0,firstLineEnd);
            yybegin(ST_IN_LONG_DESC);
        }
        else{
          numOfLines++;
        }
    }

    private void appendLastText(){
       sBuffer.append(yy_buffer, startPos, yy_markedPos-startPos-2);
       updateStartPos();
    }

    int maxNumberofLines = 4;

    private void handleDocEnd_shortDesc() {
        appendLastText();
        if(numOfLines==maxNumberofLines){
            int firstLineEnd = sBuffer.indexOf("\n",1);
            shortDesc = sBuffer.substring(0,firstLineEnd);
            shortDesc = shortDesc.trim();
            sBuffer.delete(0,firstLineEnd);
            longDesc = sBuffer.toString().trim();
        }
        else{
            shortDesc = sBuffer.toString().trim();
        }
    }

    private void handleDocEnd_longDesc() {
       appendLastText();
       longDesc = sBuffer.toString().trim();
    }

    private void handleDocEnd_inTags() {
        appendLastText();
        setTagValue();
    }


    private void updateStartPos(){
        startPos = yy_markedPos;
    }


  /**
   * Creates a new scanner
   * There is also a java.io.InputStream version of this constructor.
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public DocumentorLexer(java.io.Reader in) {
    this.yy_reader = in;
  }

  /**
   * Creates a new scanner.
   * There is also java.io.Reader version of this constructor.
   *
   * @param   in  the java.io.Inputstream to read input from.
   */
  public DocumentorLexer(java.io.InputStream in) {
    this(new java.io.InputStreamReader(in));
  }

  /** 
   * Unpacks the split, compressed DFA transition table.
   *
   * @return the unpacked transition table
   */
  private static int [] yy_unpack() {
    int [] trans = new int[9120];
    int offset = 0;
    offset = yy_unpack(yy_packed0, offset, trans);
    return trans;
  }

  /** 
   * Unpacks the compressed DFA transition table.
   *
   * @param packed   the packed transition table
   * @return         the index of the last entry
   */
  private static int yy_unpack(String packed, int offset, int [] trans) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do trans[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** 
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] yy_unpack_cmap(String packed) {
    char [] map = new char[0x10000];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < 132) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }


  /**
   * Refills the input buffer.
   *
   * @return      <code>false</code>, iff there was new input.
   * 
   * @exception   IOException  if any I/O-Error occurs
   */
  private boolean yy_refill() throws java.io.IOException {

    /* first: make room (if you can) */
    if (yy_startRead > 0) {
      System.arraycopy(yy_buffer, yy_startRead, 
                       yy_buffer, 0, 
                       yy_endRead-yy_startRead);

      /* translate stored positions */
      yy_endRead-= yy_startRead;
      yy_currentPos-= yy_startRead;
      yy_markedPos-= yy_startRead;
      yy_pushbackPos-= yy_startRead;
      yy_startRead = 0;
    }

    /* is the buffer big enough? */
    if (yy_currentPos >= yy_buffer.length) {
      /* if not: blow it up */
      char newBuffer[] = new char[yy_currentPos*2];
      System.arraycopy(yy_buffer, 0, newBuffer, 0, yy_buffer.length);
      yy_buffer = newBuffer;
    }

    /* finally: fill the buffer with new input */
    int numRead = yy_reader.read(yy_buffer, yy_endRead, 
                                            yy_buffer.length-yy_endRead);

    if (numRead < 0) {
      return true;
    }
    else {
      yy_endRead+= numRead;  
      return false;
    }
  }


  /**
   * Closes the input stream.
   */
  final public void yyclose() throws java.io.IOException {
    yy_atEOF = true;            /* indicate end of file */
    yy_endRead = yy_startRead;  /* invalidate buffer    */

    if (yy_reader != null)
      yy_reader.close();
  }


  /**
   * Closes the current stream, and resets the
   * scanner to read from a new input stream.
   *
   * All internal variables are reset, the old input stream 
   * <b>cannot</b> be reused (internal buffer is discarded and lost).
   * Lexical state is set to <tt>YY_INITIAL</tt>.
   *
   * @param reader   the new input stream 
   */
  final public void yyreset(java.io.Reader reader) throws java.io.IOException {
    yyclose();
    yy_reader = reader;
    yy_atBOL  = true;
    yy_atEOF  = false;
    yy_endRead = yy_startRead = 0;
    yy_currentPos = yy_markedPos = yy_pushbackPos = 0;
    yyline = yychar = yycolumn = 0;
    yy_lexical_state = YYINITIAL;
  }


  /**
   * Returns the current lexical state.
   */
  final public int yystate() {
    return yy_lexical_state;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  final public void yybegin(int newState) {
    yy_lexical_state = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  final public String yytext() {
    return new String( yy_buffer, yy_startRead, yy_markedPos-yy_startRead );
  }


  /**
   * Returns the character at position <tt>pos</tt> from the 
   * matched text. 
   * 
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch. 
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  final public char yycharat(int pos) {
    return yy_buffer[yy_startRead+pos];
  }


  /**
   * Returns the length of the matched text region.
   */
  final public int yylength() {
    return yy_markedPos-yy_startRead;
  }


  /**
   * Reports an error that occured while scanning.
   *
   * In a wellformed scanner (no or only correct usage of 
   * yypushback(int) and a match-all fallback rule) this method 
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void yy_ScanError(int errorCode) {
    String message;
    try {
      message = YY_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = YY_ERROR_MSG[YY_UNKNOWN_ERROR];
    }

    throw new Error(message);
  } 


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  private void yypushback(int number)  {
    if ( number > yylength() )
      yy_ScanError(YY_PUSHBACK_2BIG);

    yy_markedPos -= number;
  }


  /**
   * Contains user EOF-code, which will be executed exactly once,
   * when the end of file is reached
   */
  private void yy_do_eof() throws java.io.IOException {
    if (!yy_eof_done) {
      yy_eof_done = true;
      yyclose();
    }
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   IOException  if any I/O-Error occurs
   */
  public int next_token() throws java.io.IOException {
    int yy_input;
    int yy_action;

    // cached fields:
    int yy_currentPos_l;
    int yy_startRead_l;
    int yy_markedPos_l;
    int yy_endRead_l = yy_endRead;
    char [] yy_buffer_l = yy_buffer;
    char [] yycmap_l = yycmap;

    int [] yytrans_l = yytrans;
    int [] yy_rowMap_l = yy_rowMap;
    byte [] yy_attr_l = YY_ATTRIBUTE;

    while (true) {
      yy_markedPos_l = yy_markedPos;

      boolean yy_r = false;
      for (yy_currentPos_l = yy_startRead; yy_currentPos_l < yy_markedPos_l;
                                                             yy_currentPos_l++) {
        switch (yy_buffer_l[yy_currentPos_l]) {
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yyline++;
          yy_r = false;
          break;
        case '\r':
          yyline++;
          yy_r = true;
          break;
        case '\n':
          if (yy_r)
            yy_r = false;
          else {
            yyline++;
          }
          break;
        default:
          yy_r = false;
        }
      }

      if (yy_r) {
        // peek one character ahead if it is \n (if we have counted one line too much)
        boolean yy_peek;
        if (yy_markedPos_l < yy_endRead_l)
          yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        else if (yy_atEOF)
          yy_peek = false;
        else {
          boolean eof = yy_refill();
          yy_markedPos_l = yy_markedPos;
          yy_buffer_l = yy_buffer;
          if (eof) 
            yy_peek = false;
          else 
            yy_peek = yy_buffer_l[yy_markedPos_l] == '\n';
        }
        if (yy_peek) yyline--;
      }
      if (yy_markedPos_l > yy_startRead) {
        switch (yy_buffer_l[yy_markedPos_l-1]) {
        case '\n':
        case '\u000B':
        case '\u000C':
        case '\u0085':
        case '\u2028':
        case '\u2029':
          yy_atBOL = true;
          break;
        case '\r': 
          if (yy_markedPos_l < yy_endRead_l)
            yy_atBOL = yy_buffer_l[yy_markedPos_l] != '\n';
          else if (yy_atEOF)
            yy_atBOL = false;
          else {
            boolean eof = yy_refill();
            yy_markedPos_l = yy_markedPos;
            yy_buffer_l = yy_buffer;
            if (eof) 
              yy_atBOL = false;
            else 
              yy_atBOL = yy_buffer_l[yy_markedPos_l] != '\n';
          }
          break;
        default:
          yy_atBOL = false;
        }
      }
      yy_action = -1;

      yy_startRead_l = yy_currentPos_l = yy_currentPos = 
                       yy_startRead = yy_markedPos_l;

      if (yy_atBOL)
        yy_state = YY_LEXSTATE[yy_lexical_state+1];
      else
        yy_state = YY_LEXSTATE[yy_lexical_state];


      yy_forAction: {
        while (true) {

          if (yy_currentPos_l < yy_endRead_l)
            yy_input = yy_buffer_l[yy_currentPos_l++];
          else if (yy_atEOF) {
            yy_input = YYEOF;
            break yy_forAction;
          }
          else {
            // store back cached positions
            yy_currentPos  = yy_currentPos_l;
            yy_markedPos   = yy_markedPos_l;
            boolean eof = yy_refill();
            // get translated positions and possibly new buffer
            yy_currentPos_l  = yy_currentPos;
            yy_markedPos_l   = yy_markedPos;
            yy_buffer_l      = yy_buffer;
            yy_endRead_l     = yy_endRead;
            if (eof) {
              yy_input = YYEOF;
              break yy_forAction;
            }
            else {
              yy_input = yy_buffer_l[yy_currentPos_l++];
            }
          }
          int yy_next = yytrans_l[ yy_rowMap_l[yy_state] + yycmap_l[yy_input] ];
          if (yy_next == -1) break yy_forAction;
          yy_state = yy_next;

          int yy_attributes = yy_attr_l[yy_state];
          if ( (yy_attributes & 1) == 1 ) {
            yy_action = yy_state; 
            yy_markedPos_l = yy_currentPos_l; 
            if ( (yy_attributes & 8) == 8 ) break yy_forAction;
          }

        }
      }

      // store back cached position
      yy_markedPos = yy_markedPos_l;

      switch (yy_action) {

        case 21: 
        case 22: 
          { appendText(); }
        case 380: break;
        case 281: 
          { setNewTag("final"); }
        case 381: break;
        case 274: 
          { setNewTag("param"); }
        case 382: break;
        case 267: 
          { setNewTag("since"); }
        case 383: break;
        case 239: 
          { setNewTag("name"); }
        case 384: break;
        case 236: 
          { setNewTag("link"); }
        case 385: break;
        case 233: 
          { setNewTag("desc"); }
        case 386: break;
        case 227: 
          { setNewTag("uses"); }
        case 387: break;
        case 222: 
          { setNewTag("todo"); }
        case 388: break;
        case 363: 
          { startTagsState("staticvar"); }
        case 389: break;
        case 365: 
          { startTagsState("copyright"); }
        case 390: break;
        case 373: 
          { startTagsState("subpackage"); }
        case 391: break;
        case 374: 
          { startTagsState("deprecated"); }
        case 392: break;
        case 375: 
          { startTagsState("filesource"); }
        case 393: break;
        case 302: 
          { setNewTag("access"); }
        case 394: break;
        case 303: 
          { setNewTag("author"); }
        case 395: break;
        case 304: 
          { setNewTag("static"); }
        case 396: break;
        case 307: 
          { setNewTag("return"); }
        case 397: break;
        case 311: 
          { setNewTag("global"); }
        case 398: break;
        case 313: 
          { setNewTag("ignore"); }
        case 399: break;
        case 338: 
          { setNewTag("example"); }
        case 400: break;
        case 339: 
          { setNewTag("package"); }
        case 401: break;
        case 342: 
          { setNewTag("license"); }
        case 402: break;
        case 344: 
          { setNewTag("version"); }
        case 403: break;
        case 34: 
        case 36: 
        case 37: 
          { 
    appendText();
    startLongDescState();
 }
        case 404: break;
        case 35: 
          { 
    maxNumberofLines = 4;
    handleDocEnd_shortDesc();
 }
        case 405: break;
        case 42: 
          { 
    maxNumberofLines = 5;
    handleDocEnd_shortDesc();
 }
        case 406: break;
        case 82: 
          { 
        updateStartPos();
        yybegin(ST_IN_SHORT_DESC);
     }
        case 407: break;
        case 131: 
        case 132: 
          { 
        updateStartPos();
        yybegin(ST_IN_SHORT_DESC);
     }
        case 408: break;
        case 376: 
          { setNewTag("subpackage"); }
        case 409: break;
        case 260: 
          { startTagsState("final"); }
        case 410: break;
        case 253: 
          { startTagsState("param"); }
        case 411: break;
        case 246: 
          { startTagsState("since"); }
        case 412: break;
        case 284: 
          { startTagsState("access"); }
        case 413: break;
        case 285: 
          { startTagsState("author"); }
        case 414: break;
        case 286: 
          { startTagsState("static"); }
        case 415: break;
        case 289: 
          { startTagsState("return"); }
        case 416: break;
        case 293: 
          { startTagsState("global"); }
        case 417: break;
        case 295: 
          { startTagsState("ignore"); }
        case 418: break;
        case 357: 
          { setNewTag("tutorial"); }
        case 419: break;
        case 368: 
          { setNewTag("staticvar"); }
        case 420: break;
        case 11: 
        case 12: 
          { hendleNewLine(); }
        case 421: break;
        case 378: 
          { setNewTag("filesource"); }
        case 422: break;
        case 360: 
          { setNewTag("internal"); }
        case 423: break;
        case 187: 
          { setNewTag("var"); }
        case 424: break;
        case 165: 
          { setNewTag("see"); }
        case 425: break;
        case 377: 
          { setNewTag("deprecated"); }
        case 426: break;
        case 16: 
        case 17: 
          { startLongDescState(); }
        case 427: break;
        case 325: 
          { startTagsState("example"); }
        case 428: break;
        case 326: 
          { startTagsState("package"); }
        case 429: break;
        case 329: 
          { startTagsState("license"); }
        case 430: break;
        case 331: 
          { startTagsState("version"); }
        case 431: break;
        case 345: 
          { startTagsState("abstract"); }
        case 432: break;
        case 348: 
          { startTagsState("tutorial"); }
        case 433: break;
        case 349: 
          { startTagsState("category"); }
        case 434: break;
        case 351: 
          { startTagsState("internal"); }
        case 435: break;
        case 3: 
        case 5: 
        case 7: 
        case 24: 
        case 25: 
        case 28: 
        case 29: 
        case 38: 
        case 39: 
        case 41: 
        case 61: 
        case 66: 
          { updateStartPos(); }
        case 436: break;
        case 358: 
          { setNewTag("category"); }
        case 437: break;
        case 370: 
          { setNewTag("copyright"); }
        case 438: break;
        case 213: 
          { startTagsState("name"); }
        case 439: break;
        case 210: 
          { startTagsState("link"); }
        case 440: break;
        case 207: 
          { startTagsState("desc"); }
        case 441: break;
        case 201: 
          { startTagsState("uses"); }
        case 442: break;
        case 196: 
          { startTagsState("todo"); }
        case 443: break;
        case 137: 
          { startTagsState("see"); }
        case 444: break;
        case 159: 
          { startTagsState("var"); }
        case 445: break;
        case 354: 
          { setNewTag("abstract"); }
        case 446: break;
        case 64: 
          { handleDocEnd_inTags(); }
        case 447: break;
        case 60: 
          { handleDocEnd_longDesc(); }
        case 448: break;
        case 26: 
        case 27: 
        case 30: 
          {  }
        case 449: break;
        case 20: 
        case 23: 
          {  }
        case 450: break;
        case 10: 
        case 13: 
        case 14: 
        case 15: 
        case 18: 
        case 19: 
          {  }
        case 451: break;
        case 8: 
        case 9: 
          {  }
        case 452: break;
        default: 
          if (yy_input == YYEOF && yy_startRead == yy_currentPos) {
            yy_atEOF = true;
            yy_do_eof();
            return YYEOF;
          } 
          else {
            yy_ScanError(YY_NO_MATCH);
          }
      }
    }
  }

  /**
   * Runs the scanner on input files.
   *
   * This is a standalone scanner, i.e. it will print any unmatched
   * text to System.out unchanged.
   *
   * @param argv   the command line, contains the filenames to run
   *               the scanner on.
   */
  public static void main(String argv[]) {
    if (argv.length == 0) {
      System.out.println("Usage : java DocumentorLexer <inputfile>");
    }
    else {
      for (int i = 0; i < argv.length; i++) {
        DocumentorLexer scanner = null;
        try {
          scanner = new DocumentorLexer( new java.io.FileReader(argv[i]) );
          while ( !scanner.yy_atEOF ) scanner.next_token();
        }
        catch (java.io.FileNotFoundException e) {
          System.out.println("File not found : \""+argv[i]+"\"");
        }
        catch (java.io.IOException e) {
          System.out.println("IO error scanning file \""+argv[i]+"\"");
          System.out.println(e);
        }
        catch (Exception e) {
          System.out.println("Unexpected exception:");
          e.printStackTrace();
        }
      }
    }
  }


}
