/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective;

import org.eclipse.wst.ws.internal.datamodel.ElementAdapter;
import org.eclipse.wst.ws.internal.datamodel.ElementListener;
import org.eclipse.wst.ws.internal.datamodel.RelAddEvent;
import org.eclipse.wst.ws.internal.datamodel.RelRemoveEvent;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.QueryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.ItemsSummaryTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.QueryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDINavigatorFolderNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;

public class QueryParentNode
extends UDDINavigatorFolderNode {
    public QueryParentNode(TreeElement element, NodeManager nodeManager, int nodeDepth) {
        super(element, nodeManager, nodeDepth);
        element.addListener((ElementListener)new ElementAdapter(){

            public void relAdded(RelAddEvent event) {
                String rel = event.getOutBoundRelName();
                if (rel.equals("queries")) {
                    QueryElement queryElement = (QueryElement)event.getParentElement();
                    QueryParentNode.this.createChildNode(queryElement);
                }
            }

            public void relRemoved(RelRemoveEvent event) {
                QueryElement queryElement = null;
                if (event.getInBoundRelName().equals("queries")) {
                    queryElement = (QueryElement)event.getInboundElement();
                } else if (event.getOutBoundRelName().equals("queries")) {
                    queryElement = (QueryElement)event.getOutBoundElement();
                }
                if (queryElement != null) {
                    QueryParentNode.this.removeChildNode(queryElement);
                }
            }
        });
    }

    private final void createChildNode(QueryElement element) {
        QueryNode queryNode = new QueryNode(element, this.nodeManager_, this.nodeDepth_ + 1);
        RegistryElement regElement = (RegistryElement)this.getParent().getTreeElement();
        queryNode.addAuthenticationProperties(regElement);
        this.addChild(queryNode);
    }

    protected final void initTools() {
        UDDIPerspective uddiPerspective = this.nodeManager_.getController().getUDDIPerspective();
        new ItemsSummaryTool(this.toolManager_, "uddi/images/queries_closed_enabled.gif", "uddi/images/queries_closed_highlighted.gif", uddiPerspective.getMessage("ALT_SUMMARY_QUERIES"), -1);
        new ItemsSummaryTool(this.toolManager_, "uddi/images/businesses_closed_enabled.gif", "uddi/images/businesses_closed_highlighted.gif", uddiPerspective.getMessage("ALT_SUMMARY_BUSINESSES"), 0);
        new ItemsSummaryTool(this.toolManager_, "uddi/images/services_closed_enabled.gif", "uddi/images/services_closed_highlighted.gif", uddiPerspective.getMessage("ALT_SUMMARY_SERVICES"), 1);
        new ItemsSummaryTool(this.toolManager_, "uddi/images/service_interfaces_closed_enabled.gif", "uddi/images/service_interfaces_closed_highlighted.gif", uddiPerspective.getMessage("ALT_SUMMARY_SERVICE_INTERFACES"), 2);
    }

    public String getOpenImagePath() {
        return "uddi/images/queries_open_highlighted.gif";
    }

    public String getClosedImagePath() {
        return "uddi/images/queries_closed_highlighted.gif";
    }
}

