/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.ui.actions.CopyToClipboardAction;
import org.eclipse.php.internal.ui.actions.CutAction;
import org.eclipse.php.internal.ui.actions.DeleteAction;
import org.eclipse.php.internal.ui.actions.PasteAction;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;

public class CCPActionGroup
extends ActionGroup {
    private IWorkbenchSite fSite;
    private Clipboard fClipboard;
    private SelectionDispatchAction[] fActions;
    private SelectionDispatchAction fDeleteAction;
    private SelectionDispatchAction fCopyAction;
    private SelectionDispatchAction fPasteAction;
    private SelectionDispatchAction fCutAction;

    public CCPActionGroup(IViewPart iViewPart) {
        this((IWorkbenchSite)iViewPart.getSite());
    }

    public CCPActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    private CCPActionGroup(IWorkbenchSite iWorkbenchSite) {
        this.fSite = iWorkbenchSite;
        this.fClipboard = new Clipboard(iWorkbenchSite.getShell().getDisplay());
        this.fPasteAction = new PasteAction(this.fSite, this.fClipboard);
        this.fPasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.fCopyAction = new CopyToClipboardAction(this.fSite, this.fClipboard, this.fPasteAction);
        this.fCopyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.fCutAction = new CutAction(this.fSite, this.fClipboard, this.fPasteAction);
        this.fCutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.fDeleteAction = new DeleteAction(this.fSite);
        this.fDeleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.fActions = new SelectionDispatchAction[]{this.fCutAction, this.fCopyAction, this.fPasteAction, this.fDeleteAction};
        this.registerActionsAsSelectionChangeListeners();
    }

    private void registerActionsAsSelectionChangeListeners() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        int n = 0;
        while (n < this.fActions.length) {
            iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.fActions[n]);
            ++n;
        }
    }

    private void deregisterActionsAsSelectionChangeListeners() {
        ISelectionProvider iSelectionProvider = this.fSite.getSelectionProvider();
        int n = 0;
        while (n < this.fActions.length) {
            iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.fActions[n]);
            ++n;
        }
    }

    public IAction getDeleteAction() {
        return this.fDeleteAction;
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        iActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fDeleteAction);
        iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        iActionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.fCutAction);
        iActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.fPasteAction);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        int n = 0;
        while (n < this.fActions.length) {
            SelectionDispatchAction selectionDispatchAction = this.fActions[n];
            if (selectionDispatchAction != this.fCutAction || this.fCutAction.isEnabled()) {
                iMenuManager.appendToGroup("group.reorganize", (IAction)selectionDispatchAction);
            }
            ++n;
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
        this.deregisterActionsAsSelectionChangeListeners();
    }
}

