/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.php.internal.ui.util.ExceptionHandler;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class RefreshAction
extends SelectionDispatchAction {
    static /* synthetic */ Class class$0;

    public RefreshAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(PHPUIMessages.RefreshAction_label);
        this.setToolTipText(PHPUIMessages.RefreshAction_toolTip);
        PHPPluginImages.setLocalImageDescriptors((IAction)this, "refresh_nav.gif");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.php.ui.refresh_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.setEnabled(this.checkEnabled(iStructuredSelection));
    }

    private boolean checkEnabled(IStructuredSelection iStructuredSelection) {
        if (iStructuredSelection.isEmpty()) {
            return true;
        }
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof IAdaptable) {
                IResource iResource;
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
                    return false;
                }
                if (iResource.getType() != 4 || ((IProject)iResource).isOpen()) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        final IResource[] iResourceArray = this.getResources(iStructuredSelection);
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                iProgressMonitor.beginTask(PHPUIMessages.RefreshAction_progressMessage, iResourceArray.length * 2);
                iProgressMonitor.subTask("");
                new ArrayList(5);
                int n = 0;
                while (n < iResourceArray.length) {
                    IResource iResource = iResourceArray[n];
                    if (iResource.getType() == 4) {
                        RefreshAction.this.checkLocationDeleted((IProject)iResource);
                    } else if (iResource.getType() == 8) {
                        IProject[] iProjectArray = ((IWorkspaceRoot)iResource).getProjects();
                        int n2 = 0;
                        while (n2 < iProjectArray.length) {
                            RefreshAction.this.checkLocationDeleted(iProjectArray[n2]);
                            ++n2;
                        }
                    }
                    iResource.refreshLocal(2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    ++n;
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(iWorkspaceRunnable));
        }
        catch (InvocationTargetException invocationTargetException) {
            ExceptionHandler.handle(invocationTargetException, this.getShell(), PHPUIMessages.RefreshAction_error_title, PHPUIMessages.RefreshAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private IResource[] getResources(IStructuredSelection iStructuredSelection) {
        Object object;
        if (iStructuredSelection.isEmpty()) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        ArrayList<IResource> arrayList = new ArrayList<IResource>(iStructuredSelection.size());
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            IResource iResource;
            object = iterator.next();
            if (!(object instanceof IAdaptable)) continue;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) continue;
            arrayList.add(iResource);
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (IResource)iterator.next();
            if (!this.isDescendent(arrayList, (IResource)object)) continue;
            iterator.remove();
        }
        return arrayList.toArray(new IResource[arrayList.size()]);
    }

    private boolean isDescendent(List list, IResource iResource) {
        IContainer iContainer = iResource.getParent();
        while (iContainer != null) {
            if (list.contains(iContainer)) {
                return true;
            }
            iContainer = iContainer.getParent();
        }
        return false;
    }

    private void checkLocationDeleted(IProject iProject) throws CoreException {
        if (!iProject.exists()) {
            return;
        }
        File file = iProject.getLocation().toFile();
        if (!file.exists()) {
            final String string = MessageFormat.format(PHPUIMessages.RefreshAction_locationDeleted_message, iProject.getName(), file.getAbsolutePath());
            final boolean[] blArray = new boolean[1];
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    blArray[0] = MessageDialog.openQuestion((Shell)RefreshAction.this.getShell(), (String)PHPUIMessages.RefreshAction_locationDeleted_title, (String)string);
                }
            });
            if (blArray[0]) {
                iProject.delete(true, true, null);
            }
        }
    }
}

