/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.MoveProjectAction;
import org.eclipse.ui.actions.MoveResourceAction;
import org.eclipse.ui.actions.SelectionListenerAction;

public class ReorgMoveAction
extends SelectionDispatchAction {
    StructuredSelection selectedResources;

    public ReorgMoveAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(PHPUIMessages.ReorgMoveAction_3);
        this.setDescription(PHPUIMessages.ReorgMoveAction_4);
        this.update(this.getSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.php.ui.move_action");
    }

    public void selectionChanged(IStructuredSelection iStructuredSelection) {
        this.selectedResources = null;
        if (!iStructuredSelection.isEmpty()) {
            if (ActionUtils.containsOnlyProjects(iStructuredSelection.toList())) {
                this.setEnabled(this.createWorkbenchAction(iStructuredSelection).isEnabled());
                return;
            }
            List list = iStructuredSelection.toList();
            IResource[] iResourceArray = ActionUtils.getResources(list);
            Object[] objectArray = ActionUtils.getPHPElements(list);
            if (list.size() != iResourceArray.length + objectArray.length) {
                this.setEnabled(false);
            } else {
                boolean bl = true;
                int n = 0;
                while (n < objectArray.length) {
                    if (!(objectArray[n] instanceof PHPFileData)) {
                        bl = false;
                    }
                    ++n;
                }
                if (bl) {
                    ArrayList<IResource> arrayList = new ArrayList<IResource>(Arrays.asList(iResourceArray));
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        IResource iResource;
                        if (objectArray[n2] instanceof PHPFileData && (iResource = PHPModelUtil.getResource((Object)objectArray[n2])) != null && iResource.exists()) {
                            arrayList.add(PHPModelUtil.getResource((Object)objectArray[n2]));
                        }
                        ++n2;
                    }
                    if (arrayList.size() == list.size()) {
                        this.selectedResources = new StructuredSelection(arrayList);
                        bl = this.createWorkbenchAction((IStructuredSelection)this.selectedResources).isEnabled();
                    }
                }
                this.setEnabled(bl);
            }
        } else {
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection iTextSelection) {
        this.setEnabled(true);
    }

    private SelectionListenerAction createWorkbenchAction(IStructuredSelection iStructuredSelection) {
        List list = iStructuredSelection.toList();
        MoveProjectAction moveProjectAction = null;
        if (list.size() == 0 || list.get(0) instanceof IProject) {
            moveProjectAction = new MoveProjectAction(this.getShell());
            moveProjectAction.selectionChanged(iStructuredSelection);
        } else if (this.selectedResources != null) {
            moveProjectAction = new MoveResourceAction(this.getShell());
            moveProjectAction.selectionChanged(iStructuredSelection);
        }
        return moveProjectAction;
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (ActionUtils.containsOnlyProjects(iStructuredSelection.toList())) {
            this.createWorkbenchAction(iStructuredSelection).run();
            return;
        }
        if (this.selectedResources != null) {
            this.createWorkbenchAction((IStructuredSelection)this.selectedResources).run();
        }
    }
}

