/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.includepath.IPListElement;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.StringDialogField;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewContainerDialog
extends StatusDialog {
    private StringDialogField fContainerDialogField;
    private StatusInfo fContainerFieldStatus;
    private IFolder fFolder;
    private IPath[] fExistingFolders;
    private IProject fCurrProject;

    public NewContainerDialog(Shell shell, String string, IProject iProject, IPath[] iPathArray, IPListElement iPListElement) {
        super(shell);
        this.setTitle(string);
        this.fContainerFieldStatus = new StatusInfo();
        SourceContainerAdapter sourceContainerAdapter = new SourceContainerAdapter();
        this.fContainerDialogField = new StringDialogField();
        this.fContainerDialogField.setDialogFieldListener(sourceContainerAdapter);
        this.fFolder = null;
        this.fExistingFolders = iPathArray;
        this.fCurrProject = iProject;
        if (iPListElement == null) {
            this.fContainerDialogField.setText("");
        } else {
            this.fContainerDialogField.setText(iPListElement.getPath().removeFirstSegments(1).toString());
        }
    }

    public void setMessage(String string) {
        this.fContainerDialogField.setLabelText(string);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        int n = this.convertWidthInCharsToPixels(80);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 1;
        composite3.setLayout((Layout)gridLayout);
        this.fContainerDialogField.doFillIntoGrid(composite3, 2);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getLabelControl(null), n);
        LayoutUtil.setWidthHint((Control)this.fContainerDialogField.getTextControl(null), n);
        LayoutUtil.setHorizontalGrabbing((Control)this.fContainerDialogField.getTextControl(null));
        this.fContainerDialogField.postSetFocusOnDialogField(composite.getDisplay());
        NewContainerDialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected void doStatusLineUpdate() {
        this.checkIfPathValid();
        this.updateStatus((IStatus)this.fContainerFieldStatus);
    }

    protected void checkIfPathValid() {
        this.fFolder = null;
        String string = this.fContainerDialogField.getText();
        if (string.length() == 0) {
            this.fContainerFieldStatus.setError(PHPUIMessages.NewContainerDialog_error_enterpath);
            return;
        }
        IPath iPath = this.fCurrProject.getFullPath().append(string);
        IWorkspace iWorkspace = this.fCurrProject.getWorkspace();
        IStatus iStatus = iWorkspace.validatePath(iPath.toString(), 2);
        if (!iStatus.isOK()) {
            this.fContainerFieldStatus.setError(MessageFormat.format(PHPUIMessages.NewContainerDialog_error_invalidpath, iStatus.getMessage()));
            return;
        }
        IFolder iFolder = this.fCurrProject.getFolder(string);
        if (this.isFolderExisting(iFolder)) {
            this.fContainerFieldStatus.setError(PHPUIMessages.NewContainerDialog_error_pathexists);
            return;
        }
        this.fContainerFieldStatus.setOK();
        this.fFolder = iFolder;
    }

    private boolean isFolderExisting(IFolder iFolder) {
        int n = 0;
        while (n < this.fExistingFolders.length) {
            if (iFolder.getFullPath().equals((Object)this.fExistingFolders[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public IFolder getFolder() {
        return this.fFolder;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.php.ui.new_container_dialog_context");
    }

    private class SourceContainerAdapter
    implements IDialogFieldListener {
        private SourceContainerAdapter() {
        }

        public void dialogFieldChanged(DialogField dialogField) {
            NewContainerDialog.this.doStatusLineUpdate();
        }
    }
}

