/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.search.IPHPSearchScope;
import org.eclipse.php.internal.ui.search.PHPSearchEngine;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class PHPSearchScopeFactory {
    private static final IPHPSearchScope EMPTY_SCOPE = PHPSearchEngine.createPHPSearchScope(0, new Object[0]);
    private static final Set EMPTY_SET = new HashSet(0);
    private static PHPSearchScopeFactory instance;
    static /* synthetic */ Class class$0;

    private PHPSearchScopeFactory() {
    }

    public static PHPSearchScopeFactory getInstance() {
        if (instance == null) {
            instance = new PHPSearchScopeFactory();
        }
        return instance;
    }

    public IPHPSearchScope createWorkspaceSearchScope(int n) {
        return PHPSearchEngine.createWorkspaceScope(n);
    }

    public IPHPSearchScope createWorkingSetSearchScope(int n, IWorkingSet[] iWorkingSetArray) {
        if (iWorkingSetArray == null || iWorkingSetArray.length < 1) {
            return EMPTY_SCOPE;
        }
        HashSet hashSet = new HashSet(iWorkingSetArray.length * 10);
        int n2 = 0;
        while (n2 < iWorkingSetArray.length) {
            this.addPHPElements(hashSet, iWorkingSetArray[n2]);
            ++n2;
        }
        return this.createPHPSearchScope(n, hashSet);
    }

    public IPHPSearchScope createSelectedPHPProjectSearchScope(int n, ISelection iSelection) {
        IEditorInput iEditorInput = this.getActiveEditorInput();
        if (iEditorInput != null) {
            return PHPSearchScopeFactory.getInstance().internalCreateProjectScope(n, iEditorInput);
        }
        return this.internalCreateProjectScope(n, iSelection);
    }

    public IPHPSearchScope createSelectedPHPSearchScope(int n, ISelection iSelection) {
        HashSet hashSet;
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            hashSet = new HashSet(((IStructuredSelection)iSelection).size());
            while (iterator.hasNext()) {
                IResource iResource;
                Object e = iterator.next();
                if (e instanceof IResource) {
                    this.addPHPElements(hashSet, (IResource)e);
                    continue;
                }
                if (!(e instanceof IAdaptable)) continue;
                IAdaptable iAdaptable = (IAdaptable)e;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) continue;
                this.addPHPElements(hashSet, iResource);
            }
        } else {
            hashSet = EMPTY_SET;
        }
        return this.createPHPSearchScope(n, hashSet);
    }

    private IPHPSearchScope createPHPSearchScope(int n, Set set) {
        if (set.isEmpty()) {
            return EMPTY_SCOPE;
        }
        Object[] objectArray = set.toArray(new Object[set.size()]);
        return PHPSearchEngine.createPHPSearchScope(n, objectArray);
    }

    private void addPHPElements(Set set, IWorkingSet iWorkingSet) {
        if (iWorkingSet == null) {
            return;
        }
        IAdaptable[] iAdaptableArray = iWorkingSet.getElements();
        int n = 0;
        while (n < iAdaptableArray.length) {
            IResource iResource;
            IAdaptable iAdaptable = iAdaptableArray[n];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) != null) {
                set.add(iResource);
            }
            ++n;
        }
    }

    private void addPHPElements(Set set, IResource iResource) {
        if (iResource == null) {
            return;
        }
        set.add(iResource);
    }

    public IProject[] getPHPProjects(IPHPSearchScope iPHPSearchScope) {
        IProject[] iProjectArray = iPHPSearchScope.getAllEnclosingProjects();
        HashSet<IProject> hashSet = new HashSet<IProject>();
        int n = 0;
        while (n < iProjectArray.length) {
            block4: {
                block5: {
                    try {
                        if (!iProjectArray[n].isAccessible()) break block4;
                        if (!iProjectArray[n].hasNature("org.eclipse.php.core.PHPNature")) {
                        }
                        break block5;
                    }
                    catch (CoreException coreException) {
                        PHPUiPlugin.log(coreException);
                    }
                    break block4;
                }
                hashSet.add(iProjectArray[n]);
            }
            ++n;
        }
        return hashSet.toArray(new IProject[hashSet.size()]);
    }

    public IWorkingSet[] queryWorkingSets() {
        IWorkingSet[] iWorkingSetArray;
        Shell shell = PHPUiPlugin.getActiveWorkbenchShell();
        if (shell == null) {
            return null;
        }
        IWorkingSetSelectionDialog iWorkingSetSelectionDialog = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSetSelectionDialog(shell, true);
        if (iWorkingSetSelectionDialog.open() == 0 && (iWorkingSetArray = iWorkingSetSelectionDialog.getSelection()).length > 0) {
            return iWorkingSetArray;
        }
        return null;
    }

    private IPHPSearchScope internalCreateProjectScope(int n, IEditorInput iEditorInput) {
        IAdaptable iAdaptable = this.getEditorInputElement(iEditorInput);
        StructuredSelection structuredSelection = iAdaptable != null ? new StructuredSelection((Object)iAdaptable) : StructuredSelection.EMPTY;
        return this.internalCreateProjectScope(n, (ISelection)structuredSelection);
    }

    private IAdaptable getEditorInputElement(IEditorInput iEditorInput) {
        return null;
    }

    private IEditorInput getActiveEditorInput() {
        IEditorPart iEditorPart;
        IWorkbenchPage iWorkbenchPage = PHPUiPlugin.getActivePage();
        if (iWorkbenchPage != null && (iEditorPart = iWorkbenchPage.getActiveEditor()) != null && iEditorPart.equals(iWorkbenchPage.getActivePart())) {
            return iEditorPart.getEditorInput();
        }
        return null;
    }

    private IPHPSearchScope internalCreateProjectScope(int n, ISelection iSelection) {
        Set set = this.getPHPProjects(iSelection);
        return this.createPHPSearchScope(n, set);
    }

    private Set getPHPProjects(ISelection iSelection) {
        HashSet<IProject> hashSet;
        if (iSelection instanceof IStructuredSelection && !iSelection.isEmpty()) {
            Iterator iterator = ((IStructuredSelection)iSelection).iterator();
            hashSet = new HashSet<IProject>(((IStructuredSelection)iSelection).size());
            while (iterator.hasNext()) {
                Object e = iterator.next();
                IResource iResource = null;
                if (e instanceof IResource) {
                    iResource = (IResource)e;
                } else if (e instanceof IAdaptable) {
                    IAdaptable iAdaptable = (IAdaptable)e;
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    iResource = (IResource)iAdaptable.getAdapter((Class)clazz);
                }
                if (iResource == null) continue;
                IProject iProject = iResource.getProject();
                try {
                    if (!iProject.hasNature("org.eclipse.php.core.PHPNature")) continue;
                    hashSet.add(iProject);
                }
                catch (CoreException coreException) {
                    PHPUiPlugin.log(coreException);
                }
            }
        } else {
            hashSet = EMPTY_SET;
        }
        return hashSet;
    }

    public IProject[] getProjects(IPHPSearchScope iPHPSearchScope) {
        IProject[] iProjectArray = iPHPSearchScope.getAllEnclosingProjects();
        HashSet<IProject> hashSet = new HashSet<IProject>();
        int n = 0;
        while (n < iProjectArray.length) {
            if (iProjectArray[n].isAccessible()) {
                hashSet.add(iProjectArray[n]);
            }
            ++n;
        }
        return hashSet.toArray(new IProject[hashSet.size()]);
    }
}

