/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.text.Collator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.core.phpModel.PHPModelUtil;
import org.eclipse.php.internal.core.phpModel.parser.PHPProjectModel;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassConstData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassVarData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPConstantData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPIncludeFileData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPModifier;
import org.eclipse.php.internal.core.phpModel.phpElementData.UserData;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.outline.PHPOutlineContentProvider;
import org.eclipse.php.internal.ui.preferences.MembersOrderPreferenceCache;
import org.eclipse.php.internal.ui.projectOutline.ProjectOutlineContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.w3c.dom.Node;

public class PHPElementSorter
extends ViewerSorter {
    int flags;
    boolean usingCategories = true;
    boolean usingLocation = false;
    private static final int PROJECTS = 1;
    private static final int PACKAGEFRAGMENTROOTS = 2;
    private static final int PACKAGEFRAGMENT = 3;
    private static final int RESOURCEFOLDERS = 4;
    private static final int COMPILATIONUNITS = 5;
    private static final int CLASSFILES = 6;
    private static final int RESOURCES = 8;
    private static final int STORAGE = 9;
    private static final int PACKAGE_DECL = 10;
    private static final int IMPORT_CONTAINER = 11;
    private static final int IMPORT_DECLARATION = 12;
    private static final int MEMBERSOFFSET = 16;
    private static final int OUTLINE_NODES = 15;
    private static final int DOM_NODES = 17;
    private static final int JAVAELEMENTS = 50;
    private static final int OTHERS = 51;
    private MembersOrderPreferenceCache fMemberOrderCache = PHPUiPlugin.getDefault().getMemberOrderPreferenceCache();
    static /* synthetic */ Class class$0;

    public PHPElementSorter() {
        super(null);
    }

    public boolean isSorterProperty(Object object, Object object2) {
        return true;
    }

    public int category(Object object) {
        if (object instanceof PHPCodeData) {
            if (object instanceof PHPFunctionData) {
                PHPFunctionData pHPFunctionData = (PHPFunctionData)object;
                if (pHPFunctionData.getContainer() instanceof PHPClassData && ("__construct".equals(pHPFunctionData.getName()) || "__destruct".equals(pHPFunctionData.getName()))) {
                    return this.getMemberCategory(3);
                }
                if (PHPModifier.isStatic((int)((PHPFunctionData)object).getModifiers())) {
                    return this.getMemberCategory(4);
                }
                return this.getMemberCategory(5);
            }
            if (object instanceof PHPClassData) {
                return this.getMemberCategory(6);
            }
            if (object instanceof PHPConstantData || object instanceof PHPClassConstData) {
                return this.getMemberCategory(1);
            }
            if (object instanceof PHPIncludeFileData) {
                return this.getMemberCategory(0);
            }
            if (object instanceof PHPClassVarData) {
                if (PHPModifier.isStatic((int)((PHPClassVarData)object).getModifiers())) {
                    return this.getMemberCategory(2);
                }
                return this.getMemberCategory(7);
            }
            if (object instanceof PHPClassData.PHPSuperClassNameData) {
                return 16;
            }
        }
        if (object instanceof PHPProjectModel) {
            return 1;
        }
        if (object instanceof PHPFileData) {
            return 5;
        }
        if (object instanceof IFile) {
            return 8;
        }
        if (object instanceof IProject) {
            return 1;
        }
        if (object instanceof IContainer) {
            return 4;
        }
        if (object instanceof IStorage) {
            return 9;
        }
        if (object instanceof ProjectOutlineContentProvider.OutlineNode || object instanceof PHPOutlineContentProvider.GroupNode) {
            return 15;
        }
        if (object instanceof Node) {
            return 17;
        }
        return 51;
    }

    private int getMemberCategory(int n) {
        int n2 = this.fMemberOrderCache.getCategoryIndex(n);
        return n2 + 16;
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        Object object3;
        Object object4;
        int n;
        int n2 = this.category(object);
        int n3 = this.category(object2);
        if (this.usingCategories && n2 != n3) {
            return n2 - n3;
        }
        if (n2 == 17) {
            return -1;
        }
        if (n2 == 1 || n2 == 8 || n2 == 4 || n2 == 9 || n2 == 51) {
            String string;
            String string2 = this.getNonPHPElementLabel(viewer, object);
            if (string2 == (string = this.getNonPHPElementLabel(viewer, object2))) {
                return 0;
            }
            if (string2 != null) {
                return this.getCollator().compare(string2, string);
            }
            return -1;
        }
        if (n2 == 15 && n3 == 15) {
            return ((Comparable)object).compareTo(object2);
        }
        int n4 = 0;
        if (object instanceof PHPCodeData && this.fMemberOrderCache.isSortByVisibility()) {
            n = this.getVisibilityCode(object);
            int n5 = this.getVisibilityCode(object2);
            n4 = this.fMemberOrderCache.getVisibilityIndex(n) - this.fMemberOrderCache.getVisibilityIndex(n5);
            if (this.usingCategories && n4 != 0) {
                return n4;
            }
        }
        n = 0;
        UserData userData = null;
        UserData userData2 = null;
        if (this.usingLocation && object instanceof PHPCodeData && object2 instanceof PHPCodeData) {
            n = 1;
            object4 = (PHPCodeData)object;
            object3 = (PHPCodeData)object2;
            if (PHPModelUtil.getPHPFileContainer((PHPCodeData)object4) != PHPModelUtil.getPHPFileContainer((PHPCodeData)object3)) {
                n = 0;
            } else {
                userData = object4.getUserData();
                userData2 = object3.getUserData();
                if (userData == null || userData2 == null) {
                    n = 0;
                }
            }
        }
        if (n != 0) {
            return userData.getStartPosition() - userData2.getStartPosition();
        }
        if (object instanceof PHPClassData.PHPSuperClassNameData) {
            if (!(object instanceof PHPClassData.PHPSuperClassNameData)) {
                return -1;
            }
        } else if (object2 instanceof PHPClassData.PHPSuperClassNameData) {
            return 1;
        }
        object4 = this.getElementName(object);
        object3 = this.getElementName(object2);
        int n6 = this.getCollator().compare((String)object4, (String)object3);
        if (n6 != 0) {
            return n6;
        }
        if (object instanceof PHPFunctionData && object2 instanceof PHPFunctionData) {
            PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray = ((PHPFunctionData)object).getParameters();
            PHPFunctionData.PHPFunctionParameter[] pHPFunctionParameterArray2 = ((PHPFunctionData)object2).getParameters();
            int n7 = Math.min(pHPFunctionParameterArray.length, pHPFunctionParameterArray2.length);
            int n8 = 0;
            while (n8 < n7) {
                String string = pHPFunctionParameterArray[n8].getClassType();
                String string3 = pHPFunctionParameterArray2[n8].getClassType();
                if (string == null) {
                    if (string3 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (string3 == null) {
                    return -1;
                }
                ++n8;
            }
            return pHPFunctionParameterArray.length - pHPFunctionParameterArray2.length;
        }
        if (!this.usingCategories) {
            if (n2 != n3) {
                return n2 - n3;
            }
            return n4;
        }
        return 0;
    }

    private int getVisibilityCode(Object object) {
        if (object instanceof PHPClassData) {
            PHPClassData pHPClassData = (PHPClassData)object;
            return pHPClassData.getModifiers();
        }
        if (object instanceof PHPFunctionData) {
            PHPFunctionData pHPFunctionData = (PHPFunctionData)object;
            return pHPFunctionData.getModifiers();
        }
        if (object instanceof PHPClassVarData) {
            PHPClassVarData pHPClassVarData = (PHPClassVarData)object;
            return pHPClassVarData.getModifiers();
        }
        return 0;
    }

    private String getNonPHPElementLabel(Viewer viewer, Object object) {
        IBaseLabelProvider iBaseLabelProvider;
        if (object instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iBaseLabelProvider = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return iBaseLabelProvider.getLabel(object);
            }
        }
        if (viewer instanceof ContentViewer && (iBaseLabelProvider = ((ContentViewer)viewer).getLabelProvider()) instanceof ILabelProvider) {
            return ((ILabelProvider)iBaseLabelProvider).getText(object);
        }
        return null;
    }

    public final Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        return this.collator;
    }

    private String getElementName(Object object) {
        if (object instanceof PHPCodeData) {
            return ((PHPCodeData)object).getName();
        }
        return object.toString();
    }

    public boolean isUsingCategories() {
        return this.usingCategories;
    }

    public void setUsingCategories(boolean bl) {
        this.usingCategories = bl;
    }

    public boolean isUsingLocation() {
        return this.usingLocation;
    }

    public void setUsingLocation(boolean bl) {
        this.usingLocation = bl;
    }
}

