/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPClassData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.core.util.WeakPropertyChangeListener;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.PHPManualSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class PHPManual
implements IPropertyChangeListener {
    private static final String BROWSER_ID = "PHPManual.browser";
    private static int browserCount = 0;
    private PHPManualSite site;
    private boolean openManualInNewBrowser;
    private IPreferenceStore fStore;
    private static Map phpEntityPathMap;

    public PHPManual(PHPManualSite pHPManualSite) {
        this.site = pHPManualSite;
        this.fStore = PHPUiPlugin.getDefault().getPreferenceStore();
        this.initPreferences();
        this.fStore.addPropertyChangeListener((IPropertyChangeListener)WeakPropertyChangeListener.create((IPropertyChangeListener)this, (Object)this.fStore));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getProperty().equals("phpManualOpenInNewBrowser")) {
            this.initPreferences();
        }
    }

    public void initPreferences() {
        this.openManualInNewBrowser = this.fStore.getBoolean("phpManualOpenInNewBrowser");
    }

    public PHPManualSite getSite() {
        return this.site;
    }

    public void setSite(PHPManualSite pHPManualSite) {
        this.site = pHPManualSite;
    }

    private synchronized Map getPHPEntityPathMap() {
        if (phpEntityPathMap == null) {
            phpEntityPathMap = new HashMap();
            URL uRL = FileLocator.find((Bundle)Platform.getBundle((String)PHPUiPlugin.getPluginId()), (IPath)new Path("phpdoc.mapping"), null);
            if (uRL != null) {
                try {
                    String string;
                    uRL = FileLocator.resolve((URL)uRL);
                    BufferedReader bufferedReader = new BufferedReader(new FileReader(uRL.getFile()));
                    while ((string = bufferedReader.readLine()) != null) {
                        int n = string.indexOf(61);
                        if (n == -1) continue;
                        phpEntityPathMap.put(string.substring(0, n).toLowerCase(), string.substring(n + 1));
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return phpEntityPathMap;
    }

    private String buildPathForMethod(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("function.");
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append("-");
        }
        stringBuffer.append(Pattern.compile("([A-Z])").matcher(string2).replaceAll("-$1").replaceAll("_", "-"));
        return stringBuffer.toString().toLowerCase().replaceAll("-+", "-");
    }

    public void showFunctionHelp(PHPCodeData pHPCodeData) {
        String string;
        PHPCodeData pHPCodeData2;
        Object object;
        if (pHPCodeData == null) {
            throw new IllegalArgumentException();
        }
        String string2 = null;
        if (pHPCodeData instanceof PHPFunctionData) {
            object = (PHPFunctionData)pHPCodeData;
            pHPCodeData2 = object.getContainer();
            if (pHPCodeData2 instanceof PHPClassData) {
                string = String.valueOf(pHPCodeData2.getName()) + "::" + object.getName();
                string2 = (String)this.getPHPEntityPathMap().get(string.toLowerCase());
                if (string2 == null) {
                    string2 = this.buildPathForMethod(pHPCodeData2.getName(), object.getName());
                }
            } else {
                string2 = (String)this.getPHPEntityPathMap().get(object.getName().toLowerCase());
                if (string2 == null) {
                    string2 = this.buildPathForMethod(null, object.getName());
                }
            }
        } else if (pHPCodeData instanceof PHPKeywordData) {
            string2 = (String)this.getPHPEntityPathMap().get(pHPCodeData.getName().toLowerCase());
        }
        object = new StringBuffer();
        ((StringBuffer)object).append(this.site.getUrl());
        if (!this.site.getUrl().endsWith("/")) {
            ((StringBuffer)object).append("/");
        }
        ((StringBuffer)object).append(string2);
        ((StringBuffer)object).append(".");
        ((StringBuffer)object).append(this.site.getExtension());
        pHPCodeData2 = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            string = this.openManualInNewBrowser ? pHPCodeData2.createBrowser(BROWSER_ID + ++browserCount) : pHPCodeData2.createBrowser(BROWSER_ID);
            string.openURL(new URL(((StringBuffer)object).toString()));
        }
        catch (PartInitException partInitException) {
            Logger.logException(partInitException);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.logException(malformedURLException);
        }
    }
}

