/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.ILaunchesListener2;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.viewers.AsynchronousViewer;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.launching.PHPLaunchUtilities;
import org.eclipse.php.internal.debug.core.model.PHPDebugTarget;
import org.eclipse.php.internal.debug.core.model.PHPStackFrame;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.views.variables.PHPDebugElementAdapterFactory;
import org.eclipse.php.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class PHPDebugUIPlugin
extends AbstractUIPlugin {
    private static PHPDebugUIPlugin plugin;
    private ImageDescriptorRegistry fImageDescriptorRegistry;
    public static final String ID = "org.eclipse.php.debug.ui";
    public static final int INTERNAL_ERROR = 10001;
    private ShowViewListener showViewListener;
    private TerminateDebugLaunchListener finishDebugLaunchListener;
    private FirstSelectionDebugLaunchListener firstSelectionDebugLaunchListener;
    static /* synthetic */ Class class$0;

    public PHPDebugUIPlugin() {
        plugin = this;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.showViewListener = new ShowViewListener();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this.showViewListener);
        this.finishDebugLaunchListener = new TerminateDebugLaunchListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.finishDebugLaunchListener);
        this.firstSelectionDebugLaunchListener = new FirstSelectionDebugLaunchListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.firstSelectionDebugLaunchListener);
        AdapterManager adapterManager = (AdapterManager)Platform.getAdapterManager();
        HashMap hashMap = adapterManager.getFactories();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        List list = (List)hashMap.get(clazz.getName());
        PHPDebugElementAdapterFactory pHPDebugElementAdapterFactory = new PHPDebugElementAdapterFactory();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.debug.core.model.IVariable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        adapterManager.registerAdapters((IAdapterFactory)pHPDebugElementAdapterFactory, (Class)clazz2);
        if (list != null && list.size() > 1) {
            list.remove((Object)pHPDebugElementAdapterFactory);
            list.add(0, pHPDebugElementAdapterFactory);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        super.stop(bundleContext);
        if (this.showViewListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this.showViewListener);
        }
        if (this.finishDebugLaunchListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.finishDebugLaunchListener);
        }
        if (this.firstSelectionDebugLaunchListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.firstSelectionDebugLaunchListener);
        }
        plugin = null;
    }

    public static PHPDebugUIPlugin getDefault() {
        return plugin;
    }

    public static String getID() {
        return ID;
    }

    public static ImageDescriptor getImageDescriptor(String string) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)ID, (String)string);
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        if (PHPDebugUIPlugin.getDefault().fImageDescriptorRegistry == null) {
            PHPDebugUIPlugin.getDefault().fImageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return PHPDebugUIPlugin.getDefault().fImageDescriptorRegistry;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PHPDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow iWorkbenchWindow = PHPDebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = PHPDebugUIPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            return iWorkbenchWindow.getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static void showView(String string) {
        IViewPart iViewPart;
        IWorkbenchPage iWorkbenchPage;
        IPerspectiveDescriptor iPerspectiveDescriptor;
        IWorkbenchWindow iWorkbenchWindow = PHPDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iPerspectiveDescriptor = (iWorkbenchPage = iWorkbenchWindow.getActivePage()).getPerspective()).getId().indexOf("php") != -1 && iWorkbenchPage != null && (iViewPart = iWorkbenchPage.findView(string)) == null) {
            try {
                iWorkbenchPage.showView(string);
            }
            catch (PartInitException partInitException) {
                ErrorDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)PHPDebugUIMessages.ShowView_errorTitle, (String)partInitException.getMessage(), (IStatus)partInitException.getStatus());
            }
        }
    }

    public static void log(IStatus iStatus) {
        PHPDebugUIPlugin.getDefault().getLog().log(iStatus);
    }

    public static void log(Throwable throwable) {
        PHPDebugUIPlugin.log((IStatus)new Status(4, ID, 10001, "PHP ui plugin internal error", throwable));
    }

    public static IProject getProject(String string) {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = iWorkspaceRoot.getProjects();
        IProject iProject = null;
        int n = 0;
        while (n < iProjectArray.length) {
            if (iProjectArray[n].getName().equals(string)) {
                iProject = iProjectArray[n];
                break;
            }
            ++n;
        }
        return iProject;
    }

    private static class FirstSelectionDebugLaunchListener
    implements ILaunchesListener2 {
        private FirstSelectionDebugLaunchListener() {
        }

        public void launchesTerminated(ILaunch[] iLaunchArray) {
        }

        public void launchesAdded(ILaunch[] iLaunchArray) {
            if (iLaunchArray != null && iLaunchArray.length > 0) {
                ILaunch[] iLaunchArray2 = iLaunchArray;
                Display.getDefault().asyncExec(new Runnable(this, iLaunchArray2){
                    final /* synthetic */ FirstSelectionDebugLaunchListener this$1;
                    private final /* synthetic */ ILaunch[] val$currentLaunches;
                    {
                        this.this$1 = firstSelectionDebugLaunchListener;
                        this.val$currentLaunches = iLaunchArray;
                    }

                    public void run() {
                        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        LaunchView launchView = (LaunchView)iWorkbenchPage.findView("org.eclipse.debug.ui.DebugView");
                        try {
                            PHPDebugTarget pHPDebugTarget = (PHPDebugTarget)this.val$currentLaunches[0].getDebugTarget();
                            if (pHPDebugTarget != null) {
                                IThread iThread = pHPDebugTarget.getThreads()[0];
                                PHPStackFrame pHPStackFrame = (PHPStackFrame)iThread.getTopStackFrame();
                                if (iThread != null && pHPStackFrame != null) {
                                    Object[] objectArray = new Object[]{DebugPlugin.getDefault().getLaunchManager(), this.val$currentLaunches[0], pHPDebugTarget, iThread, pHPStackFrame};
                                    TreePath treePath = new TreePath(objectArray);
                                    ((AsynchronousViewer)launchView.getViewer()).setSelection((ISelection)new TreeSelection(treePath), true, true);
                                }
                            }
                        }
                        catch (DebugException debugException) {}
                    }
                });
            }
        }

        public void launchesChanged(ILaunch[] iLaunchArray) {
        }

        public void launchesRemoved(ILaunch[] iLaunchArray) {
        }
    }

    private static class ShowViewListener
    implements IDebugEventSetListener {
        private ShowViewListener() {
        }

        public void handleDebugEvents(DebugEvent[] debugEventArray) {
            block6: {
                if (debugEventArray == null) break block6;
                int n = debugEventArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block8: {
                        Object object;
                        Object object2;
                        DebugEvent debugEvent;
                        block7: {
                            debugEvent = debugEventArray[n2];
                            if (debugEvent.getKind() != 4) break block7;
                            object2 = debugEventArray[n2].getSource();
                            if (!(object2 instanceof PHPDebugTarget)) break block8;
                            if (PHPDebugPlugin.getOpenDebugViewsOption()) {
                                object = new UIJob(this, "debug output"){
                                    final /* synthetic */ ShowViewListener this$1;
                                    {
                                        this.this$1 = showViewListener;
                                        super(string);
                                    }

                                    public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                                        PHPDebugUIPlugin.showView("org.eclipse.debug.ui.PHPBrowserOutput");
                                        PHPDebugUIPlugin.showView("org.eclipse.debug.ui.PHPDebugOutput");
                                        PHPDebugUIPlugin.showView("org.eclipse.ui.console.ConsoleView");
                                        return Status.OK_STATUS;
                                    }
                                };
                                object.schedule();
                            }
                        }
                        if (debugEvent.getKind() == 32 && (object2 = debugEventArray[n2].getSource()) instanceof PHPDebugTarget && (object = debugEventArray[n2].getData()) instanceof IStatus) {
                            UIJob uIJob = new UIJob(this, "debug output", object){
                                final /* synthetic */ ShowViewListener this$1;
                                private final /* synthetic */ Object val$data;
                                {
                                    this.this$1 = showViewListener;
                                    this.val$data = object;
                                    super(string);
                                }

                                public IStatus runInUIThread(IProgressMonitor iProgressMonitor) {
                                    IStatus iStatus = (IStatus)this.val$data;
                                    Shell shell = PHPDebugUIPlugin.getActiveWorkbenchShell();
                                    ErrorDialog.openError((Shell)shell, null, null, (IStatus)iStatus);
                                    return Status.OK_STATUS;
                                }
                            };
                            uIJob.schedule();
                        }
                    }
                    ++n2;
                }
            }
        }
    }

    private static class TerminateDebugLaunchListener
    implements ILaunchesListener2 {
        private TerminateDebugLaunchListener() {
        }

        public void launchesTerminated(ILaunch[] iLaunchArray) {
            Display.getDefault().asyncExec(new Runnable(this){
                final /* synthetic */ TerminateDebugLaunchListener this$1;
                {
                    this.this$1 = terminateDebugLaunchListener;
                }

                public void run() {
                    if (!PHPLaunchUtilities.hasPHPDebugLaunch()) {
                        PHPLaunchUtilities.switchToPHPPerspective();
                    }
                }
            });
        }

        public void launchesAdded(ILaunch[] iLaunchArray) {
        }

        public void launchesChanged(ILaunch[] iLaunchArray) {
        }

        public void launchesRemoved(ILaunch[] iLaunchArray) {
        }
    }
}

