/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.core.internal.ui.services;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.wst.rdb.core.internal.ui.explorer.virtual.IVirtualNode;
import org.eclipse.wst.rdb.core.internal.ui.services.IExplorerSorterService;
import org.eclipse.wst.rdb.core.internal.ui.services.ISorterValidatorProvider;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentService;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;

public class ExplorerSorterProvider
extends ViewerSorter
implements IExplorerSorterService {
    private Collator collator = Collator.getInstance((Locale)Locale.getDefault());
    private ContainmentService containment = RDBCorePlugin.getDefault().getContainmentService();
    private List providerList = new ArrayList();
    static /* synthetic */ Class class$0;

    public ExplorerSorterProvider() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("org.eclipse.wst.rdb.core.ui", "sorterValidatorProvider");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                if (configElements[j].getName().equals("provider")) {
                    try {
                        Object provider = configElements[j].createExecutableExtension("class");
                        this.providerList.add(provider);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private ISorterValidatorProvider shouldCompare(Object element1, Object element2) {
        if (!this.providerList.isEmpty()) {
            Iterator iterator = this.providerList.iterator();
            while (iterator.hasNext()) {
                ISorterValidatorProvider provider = (ISorterValidatorProvider)iterator.next();
                if (!provider.shouldCompare(element1, element2)) continue;
                return provider;
            }
        }
        return null;
    }

    protected boolean isValid(Object element1, Object element2) {
        if (!this.providerList.isEmpty()) {
            Iterator iterator = this.providerList.iterator();
            while (iterator.hasNext()) {
                ISorterValidatorProvider provider = (ISorterValidatorProvider)iterator.next();
                if (!provider.isNotValid(element1, element2)) continue;
                return false;
            }
            return true;
        }
        if (element1 instanceof SQLObject && element2 instanceof SQLObject) {
            return !(this.containment.getContainer((EObject)((SQLObject)element1)) instanceof Table) && !(this.containment.getContainer((EObject)((SQLObject)element2)) instanceof Table);
        }
        return true;
    }

    private String getName(Object object) {
        if (object instanceof SQLObject) {
            return ((SQLObject)object).getName();
        }
        if (object instanceof IVirtualNode) {
            return ((IVirtualNode)object).getDisplayName();
        }
        if (object instanceof IAdaptable) {
            Object resource;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((resource = iAdaptable.getAdapter((Class)clazz)) != null) {
                return ((IResource)resource).getName();
            }
        }
        return null;
    }

    public int compare(Object element1, Object element2) {
        return this.compare(null, element1, element2);
    }

    public int compare(Viewer viewer, Object element1, Object element2) {
        ISorterValidatorProvider provider = this.shouldCompare(element1, element2);
        if (provider != null) {
            return provider.compareTo(element1, element2);
        }
        if (this.isValid(element1, element2)) {
            String string1 = this.getName(element1);
            String string2 = this.getName(element2);
            return string1 != null && string2 != null ? this.collator.getCollationKey(string1).compareTo(this.collator.getCollationKey(string2)) : -1;
        }
        return -1;
    }
}

