/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.search.OccurrencesSearchQuery;

public abstract class FindOccurrencesProcessor {
    public boolean findOccurrences(IDocument document, ITextSelection textSelection, IFile file) {
        String type;
        ITextRegion r;
        IStructuredDocument structuredDocument;
        IStructuredDocumentRegion sdRegion;
        boolean findOccurrences = false;
        if (document instanceof IStructuredDocument && (sdRegion = (structuredDocument = (IStructuredDocument)document).getRegionAtCharacterOffset(textSelection.getOffset())) != null && (r = sdRegion.getRegionAtCharacterOffset(textSelection.getOffset())) != null && this.enabledForRegionType(type = r.getType())) {
            String matchText = sdRegion.getText(r);
            NewSearchUI.activateSearchResultView();
            if (matchText != null && type != null) {
                ISearchQuery searchQuery = this.getSearchQuery(file, structuredDocument, matchText, type, textSelection);
                if (searchQuery != null) {
                    if (searchQuery.canRunInBackground()) {
                        NewSearchUI.runQueryInBackground((ISearchQuery)searchQuery);
                    } else {
                        NewSearchUI.runQueryInForeground(null, (ISearchQuery)searchQuery);
                    }
                }
                findOccurrences = true;
            }
        }
        return findOccurrences;
    }

    private boolean enabledForRegionType(String regionType) {
        String[] accept = this.getRegionTypes();
        int i = 0;
        while (i < accept.length) {
            if (regionType.equals(accept[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected abstract String[] getPartitionTypes();

    protected abstract String[] getRegionTypes();

    protected ISearchQuery getSearchQuery(IFile file, IStructuredDocument document, String regionText, String regionType, ITextSelection textSelection) {
        return new OccurrencesSearchQuery(file, document, regionText, regionType);
    }

    public boolean enabledForParitition(String partitionType) {
        String[] accept = this.getPartitionTypes();
        int i = 0;
        while (i < accept.length) {
            if (partitionType.equals(accept[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

