/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThrowStatement;
import org.eclipse.jdt.internal.corext.refactoring.util.AbstractExceptionAnalyzer;

class ExceptionAnalyzer
extends AbstractExceptionAnalyzer {
    ExceptionAnalyzer() {
    }

    public static ITypeBinding[] perform(ASTNode[] statements) {
        ExceptionAnalyzer analyzer = new ExceptionAnalyzer();
        int i = 0;
        while (i < statements.length) {
            statements[i].accept((ASTVisitor)analyzer);
            ++i;
        }
        List exceptions = analyzer.getCurrentExceptions();
        return exceptions.toArray(new ITypeBinding[exceptions.size()]);
    }

    public boolean visit(ThrowStatement node) {
        ITypeBinding exception = node.getExpression().resolveTypeBinding();
        if (exception == null) {
            return true;
        }
        this.addException(exception);
        return true;
    }

    public boolean visit(MethodInvocation node) {
        return this.handleExceptions((IMethodBinding)node.getName().resolveBinding());
    }

    public boolean visit(SuperMethodInvocation node) {
        return this.handleExceptions((IMethodBinding)node.getName().resolveBinding());
    }

    public boolean visit(ClassInstanceCreation node) {
        return this.handleExceptions(node.resolveConstructorBinding());
    }

    private boolean handleExceptions(IMethodBinding binding) {
        if (binding == null) {
            return true;
        }
        this.addExceptions(binding.getExceptionTypes());
        return true;
    }
}

