/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.data.internal.ui.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.wst.rdb.data.internal.core.editor.IRowData;
import org.eclipse.wst.rdb.data.internal.ui.DataUIPlugin;
import org.eclipse.wst.rdb.data.internal.ui.editor.CursorAction;
import org.eclipse.wst.rdb.data.internal.ui.editor.EditorAction;
import org.eclipse.wst.rdb.data.internal.ui.editor.Messages;
import org.eclipse.wst.rdb.data.internal.ui.editor.TableDataEditor;

public class TableDataEditorActionBarContributor
extends EditorActionBarContributor {
    protected EditorAction insertAction;
    protected CursorAction updateAction;
    protected CursorAction deleteAction;
    protected CursorAction setNullAction;
    protected EditorAction revertAction;
    protected EditorAction refreshAction;
    protected EditorAction saveAction;

    public TableDataEditorActionBarContributor() {
        DataUIPlugin.getDefault().setTableDataEditorContributor(this);
        this.insertAction = new EditorAction(Messages.getString("TableDataEditorActionBarContributor.InsertRow")){

            public void run() {
                this.editor.doInsertRow();
            }

            public boolean isEnabled() {
                return !this.isEditorReadonly();
            }
        };
        this.updateAction = new CursorAction(Messages.getString("TableDataEditorActionBarContributor.UpdateRow")){

            public void run() {
                this.editor.doUpdateValue();
            }

            public boolean isEnabled() {
                return !this.isEditorReadonly();
            }
        };
        this.updateAction.setAccelerator(0x100000B);
        this.deleteAction = new CursorAction(Messages.getString("TableDataEditorActionBarContributor.DeleteRow")){

            public void run() {
                this.editor.doDelete();
            }

            public boolean isEnabled() {
                return !this.isEditorReadonly() && this.editor != null && this.editor.getCursor().getRow() != null && this.editor.getCursor().getRow().getData() instanceof IRowData;
            }
        };
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.setNullAction = new CursorAction(Messages.getString("TableDataEditorActionBarContributor.SetNull")){

            public void run() {
                this.editor.doSetNull();
            }

            public boolean isEnabled() {
                return !this.isEditorReadonly() && this.isColumnNullable();
            }
        };
        this.revertAction = new EditorAction(Messages.getString("TableDataEditorActionBarContributor.Revert")){

            public void run() {
                this.editor.doRevert();
            }

            public boolean isEnabled() {
                return this.isEditorDirty();
            }
        };
        this.revertAction.setActionDefinitionId("org.eclipse.ui.file.revert");
        this.refreshAction = new EditorAction(Messages.getString("TableDataEditorActionBarContributor.Refresh")){

            public void run() {
                this.editor.doRefresh();
            }
        };
        this.refreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
        this.saveAction = new EditorAction(Messages.getString("TableDataEditorActionBarContributor.Save")){

            public void run() {
                this.editor.doSave((IProgressMonitor)new NullProgressMonitor());
            }

            public boolean isEnabled() {
                return this.isEditorDirty();
            }
        };
        this.saveAction.setActionDefinitionId("org.eclipse.ui.file.save");
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        TableDataEditor editor = null;
        if (targetEditor instanceof TableDataEditor) {
            editor = (TableDataEditor)targetEditor;
        }
        this.insertAction.setActiveEditor(editor);
        this.updateAction.setActiveEditor(editor);
        this.deleteAction.setActiveEditor(editor);
        this.setNullAction.setActiveEditor(editor);
        this.revertAction.setActiveEditor(editor);
        this.refreshAction.setActiveEditor(editor);
        this.saveAction.setActiveEditor(editor);
    }

    public void contributeToMenu(IMenuManager menuManager) {
        IMenuManager editMenu = menuManager.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IContributionItem)new Separator());
            editMenu.add((IAction)this.insertAction);
            editMenu.add((IAction)this.updateAction);
            editMenu.add((IAction)this.setNullAction);
            editMenu.add((IAction)this.deleteAction);
        }
        IActionBars bars = this.getActionBars();
        bars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        bars.setGlobalActionHandler(ActionFactory.REVERT.getId(), (IAction)this.revertAction);
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.refreshAction);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
    }

    public void contributeToCoolBar(ICoolBarManager coolBarManager) {
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
    }
}

