/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.correction;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.FormatProcessorXML;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.correction.RenameInFileQuickAssistProposal;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;
import org.w3c.dom.Node;

public class SurroundWithNewElementQuickAssistProposal
extends RenameInFileQuickAssistProposal {
    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            int startTagOffset = offset;
            int endTagOffset = offset + viewer.getSelectedRange().y;
            if (startTagOffset == endTagOffset) {
                IDOMNode cursorNode = (IDOMNode)ContentAssistUtils.getNodeAt((StructuredTextViewer)((StructuredTextViewer)viewer), (int)offset);
                if (cursorNode.getNodeType() == 3 && cursorNode.getNodeValue().trim().length() == 0) {
                    cursorNode = (IDOMNode)cursorNode.getParentNode();
                }
                startTagOffset = cursorNode.getStartOffset();
                endTagOffset = cursorNode.getEndOffset();
            }
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            multiTextEdit.addChild((TextEdit)new InsertEdit(startTagOffset, "<element>"));
            multiTextEdit.addChild((TextEdit)new InsertEdit(endTagOffset, "</element>"));
            multiTextEdit.apply(viewer.getDocument());
            IDOMNode newElementNode = (IDOMNode)ContentAssistUtils.getNodeAt((StructuredTextViewer)((StructuredTextViewer)viewer), (int)startTagOffset);
            FormatProcessorXML formatProcessor = new FormatProcessorXML();
            formatProcessor.formatNode((Node)newElementNode);
            super.apply(viewer, trigger, stateMask, newElementNode.getStartOffset() + 1);
        }
        catch (MalformedTreeException e) {
            Logger.log(1, e.getMessage());
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
    }

    public String getAdditionalProposalInfo() {
        return XMLUIMessages.SurroundWithNewElementQuickAssistProposal_0;
    }

    public String getDisplayString() {
        return XMLUIMessages.SurroundWithNewElementQuickAssistProposal_1;
    }

    public Image getImage() {
        return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/obj16/add_correction.gif");
    }
}

