/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.internal.databinding.provisional.Binding;
import org.eclipse.jface.internal.databinding.provisional.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.observable.IChangeListener;
import org.eclipse.jface.internal.databinding.provisional.observable.IObservable;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiff;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ListDiffEntry;
import org.eclipse.jface.internal.databinding.provisional.observable.list.ObservableList;
import org.eclipse.jface.internal.databinding.provisional.observable.list.WritableList;
import org.eclipse.jface.internal.databinding.provisional.observable.value.IObservableValue;

public class ValidationErrorList
extends ObservableList {
    private boolean isDirty;
    private final WritableList bindings;
    private final boolean usePartialErrors;
    private List dependencies;
    private IChangeListener markDirtyChangeListener;
    static /* synthetic */ Class class$0;

    public ValidationErrorList(WritableList bindings, boolean usePartialErrors) {
        ArrayList arrayList = new ArrayList();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.internal.databinding.provisional.validation.ValidationError");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(arrayList, clazz);
        this.isDirty = true;
        this.dependencies = new ArrayList();
        this.markDirtyChangeListener = new IChangeListener(){

            public void handleChange(IObservable source) {
                ValidationErrorList.this.markDirty();
            }
        };
        this.bindings = bindings;
        this.usePartialErrors = usePartialErrors;
        bindings.addChangeListener(this.markDirtyChangeListener);
    }

    protected void getterCalled() {
        this.recompute();
        super.getterCalled();
    }

    private void markDirty() {
        this.removeElementChangeListener();
        final List oldList = this.wrappedList;
        ListDiff listDiff = new ListDiff(){
            ListDiffEntry[] cachedDifferences = null;

            public ListDiffEntry[] getDifferences() {
                if (this.cachedDifferences == null) {
                    ValidationErrorList.this.recompute();
                    this.cachedDifferences = Diffs.computeListDiff(oldList, ValidationErrorList.this.wrappedList).getDifferences();
                }
                return this.cachedDifferences;
            }
        };
        this.wrappedList = new ArrayList();
        this.isDirty = true;
        this.fireListChange(listDiff);
    }

    private void recompute() {
        if (this.isDirty) {
            ArrayList<Object> newContents = new ArrayList<Object>();
            Iterator it = this.bindings.iterator();
            while (it.hasNext()) {
                Binding binding = (Binding)it.next();
                IObservableValue validationError = this.usePartialErrors ? binding.getPartialValidationError() : binding.getValidationError();
                this.dependencies.add(validationError);
                validationError.addChangeListener(this.markDirtyChangeListener);
                Object validationErrorValue = validationError.getValue();
                if (validationErrorValue == null) continue;
                newContents.add(validationErrorValue);
            }
            this.wrappedList.addAll(newContents);
            this.isDirty = false;
        }
    }

    public void dispose() {
        this.bindings.removeChangeListener(this.markDirtyChangeListener);
        this.removeElementChangeListener();
        super.dispose();
    }

    private void removeElementChangeListener() {
        Iterator it = this.dependencies.iterator();
        while (it.hasNext()) {
            IObservableValue observableValue = (IObservableValue)it.next();
            observableValue.removeChangeListener(this.markDirtyChangeListener);
        }
    }

    public Object getElementType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.internal.databinding.provisional.validation.ValidationError");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

