/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    Cursor sizeCursor;
    int lastX;
    int lastY;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;

    public Sash(Composite parent, int style) {
        super(parent, Sash.checkStyle(style));
        int cursorStyle = (style & 0x200) != 0 ? 9 : 7;
        this.sizeCursor = new Cursor(this.display, cursorStyle);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Sash.checkBits(style |= 0x10000, 256, 512, 0, 0, 0, 0);
    }

    int callFocusEventHandler(int nextHandler, int theEvent) {
        return 0;
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        if ((this.style & 0x100) != 0) {
            width += 64;
            height += 5;
        } else {
            width += 5;
            height += 64;
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    void createHandle() {
        this.state |= 0x800;
        int features = 4;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        OS.CreateUserPaneControl(window, null, features, outControl);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
    }

    void drawBackground(int control, int context) {
        this.fillBackground(control, context, null);
    }

    int kEventControlClick(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlClick(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        if (!this.isEnabled()) {
            return 0;
        }
        return result;
    }

    int kEventControlGetFocusPart(int nextHandler, int theEvent, int userData) {
        return 0;
    }

    int kEventControlSetCursor(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetCursor(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.display.setCursor(this.sizeCursor.handle);
        return 0;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int offsetY;
        int offsetX;
        int result = super.kEventMouseDown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        Shell shell = this.getShell();
        shell.bringToTop(true);
        if (this.isDisposed()) {
            return 0;
        }
        this.display.grabControl = null;
        this.display.runDeferredEvents();
        Rect rect = new Rect();
        OS.GetControlBounds(this.handle, rect);
        int startX = rect.left;
        int startY = rect.top;
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        if (!OS.HIVIEW) {
            OS.GetControlBounds(this.parent.handle, rect);
            startX -= rect.left;
            startY -= rect.top;
        }
        Event event = new Event();
        event.x = startX;
        event.y = startY;
        event.width = width;
        event.height = height;
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return result;
        }
        if (!event.doit) {
            return result;
        }
        int window = OS.GetControlOwner(this.handle);
        if (OS.HIVIEW) {
            CGPoint pt = new CGPoint();
            OS.GetEventParameter(theEvent, 2003660661, 1751740532, null, 8, null, pt);
            OS.HIViewConvertPoint(pt, 0, this.handle);
            offsetX = (int)pt.x;
            offsetY = (int)pt.y;
        } else {
            int sizeof = 4;
            Point pt = new Point();
            OS.GetEventParameter(theEvent, 1835822947, 1363439732, null, sizeof, null, pt);
            OS.GetWindowBounds(window, (short)33, rect);
            offsetX = pt.h - rect.left;
            offsetY = pt.v - rect.top;
            OS.GetControlBounds(this.handle, rect);
            offsetX -= rect.left;
            offsetY -= rect.top;
        }
        int port = OS.HIVIEW ? -1 : OS.GetWindowPort(window);
        int[] outModifiers = new int[1];
        short[] outResult = new short[1];
        CGPoint pt = new CGPoint();
        Point outPt = new Point();
        block3: while (outResult[0] != 2) {
            OS.TrackMouseLocationWithOptions(port, 0, -1.0, outPt, outModifiers, outResult);
            switch (outResult[0]) {
                case 1: 
                case 2: 
                case 5: {
                    int y;
                    int x;
                    if (OS.HIVIEW) {
                        OS.GetWindowBounds(window, (short)32, rect);
                        pt.x = outPt.h - rect.left;
                        pt.y = outPt.v - rect.top;
                        OS.HIViewConvertPoint(pt, 0, this.parent.handle);
                        x = (int)pt.x;
                        y = (int)pt.y;
                    } else {
                        OS.GetControlBounds(this.parent.handle, rect);
                        x = outPt.h - rect.left;
                        y = outPt.v - rect.top;
                    }
                    int newX = startX;
                    int newY = startY;
                    if ((this.style & 0x200) != 0) {
                        int clientWidth = rect.right - rect.left;
                        newX = Math.min(Math.max(0, x - offsetX), clientWidth - width);
                    } else {
                        int clientHeight = rect.bottom - rect.top;
                        newY = Math.min(Math.max(0, y - offsetY), clientHeight - height);
                    }
                    event = new Event();
                    event.x = newX;
                    event.y = newY;
                    event.width = width;
                    event.height = height;
                    this.sendEvent(13, event);
                    if (this.isDisposed()) {
                        return result;
                    }
                    if (event.doit) {
                        this.setBounds(event.x, event.y, width, height);
                        if (this.isDisposed()) {
                            return result;
                        }
                        if (!OS.HIVIEW) {
                            this.parent.update(true);
                        }
                    }
                    if (outResult[0] != 2) continue block3;
                    OS.GetControlBounds(this.handle, rect);
                    short[] button = new short[1];
                    OS.GetEventParameter(theEvent, 1835168878, 1835168878, null, 2, null, button);
                    int chord = OS.GetCurrentEventButtonState();
                    int modifiers = OS.GetCurrentEventKeyModifiers();
                    this.sendMouseEvent(4, button[0], true, chord, (short)(x - rect.left), (short)(y - rect.top), modifiers);
                    break;
                }
                default: {
                    outResult[0] = 2;
                }
            }
        }
        return 0;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0) {
            org.eclipse.swt.graphics.Point location = this.getLocation();
            this.lastX = location.x;
            this.lastY = location.y;
        }
        return result;
    }

    int kEventUnicodeKeyPressed(int nextHandler, int theEvent, int userData) {
        int result = super.kEventUnicodeKeyPressed(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        switch (keyCode[0]) {
            case 123: 
            case 124: 
            case 125: 
            case 126: {
                int xChange = 0;
                int yChange = 0;
                int stepSize = 9;
                int[] modifiers = new int[1];
                OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
                if ((modifiers[0] & 0x1000) != 0) {
                    stepSize = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (keyCode[0] == 126 || keyCode[0] == 125) break;
                    xChange = keyCode[0] == 123 ? -stepSize : stepSize;
                } else {
                    if (keyCode[0] == 123 || keyCode[0] == 124) break;
                    yChange = keyCode[0] == 126 ? -stepSize : stepSize;
                }
                Rectangle bounds = this.getBounds();
                int width = bounds.width;
                int height = bounds.height;
                Rectangle parentBounds = this.parent.getBounds();
                int parentWidth = parentBounds.width;
                int parentHeight = parentBounds.height;
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, this.lastX + xChange), parentWidth - width);
                } else {
                    newY = Math.min(Math.max(0, this.lastY + yChange), parentHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return result;
                }
                Event event = new Event();
                event.x = newX;
                event.y = newY;
                event.width = width;
                event.height = height;
                this.sendEvent(13, event);
                if (this.isDisposed() || !event.doit) break;
                this.setBounds(event.x, event.y, width, height);
                if (this.isDisposed()) break;
                this.lastX = event.x;
                this.lastY = event.y;
                if (this.isDisposed()) {
                    return result;
                }
                int cursorX = event.x;
                int cursorY = event.y;
                if ((this.style & 0x200) != 0) {
                    cursorY += height / 2;
                } else {
                    cursorX += width / 2;
                }
                this.display.setCursorLocation(this.parent.toDisplay(cursorX, cursorY));
            }
        }
        return result;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.sizeCursor != null) {
            this.sizeCursor.dispose();
        }
        this.sizeCursor = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    int traversalCode(int key, int theEvent) {
        return 0;
    }
}

