/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.php.internal.core.util.WeakObject;

public class WeakCollection
implements Collection {
    private Collection refrencedCollection;

    public WeakCollection(int n) {
        this.refrencedCollection = new ArrayList(n);
    }

    public WeakCollection() {
        this.refrencedCollection = new ArrayList();
    }

    public int size() {
        this.removeUnReferencedObjects();
        return this.refrencedCollection.size();
    }

    public boolean isEmpty() {
        this.removeUnReferencedObjects();
        return this.refrencedCollection.isEmpty();
    }

    public boolean contains(Object object) {
        return this.refrencedCollection.contains(new WeakObject(object));
    }

    public Iterator iterator() {
        return new WeakIterator();
    }

    public Object[] toArray() {
        return this.toArray((Object[])null);
    }

    public Object[] toArray(Object[] objectArray) {
        this.removeUnReferencedObjects();
        Object[] objectArray2 = this.refrencedCollection.toArray();
        if (objectArray == null || objectArray.length < objectArray2.length) {
            objectArray = new Object[objectArray2.length];
        }
        int n = 0;
        while (n < objectArray2.length) {
            objectArray[n] = ((WeakObject)objectArray2[n]).get();
            ++n;
        }
        return objectArray;
    }

    public boolean add(Object object) {
        WeakObject weakObject = new WeakObject(object);
        return this.refrencedCollection.add(weakObject);
    }

    public boolean remove(Object object) {
        WeakObject weakObject = new WeakObject(object);
        return this.refrencedCollection.remove(weakObject);
    }

    public boolean containsAll(Collection collection) {
        boolean bl = true;
        if (collection instanceof WeakCollection) {
            bl = this.refrencedCollection.containsAll(((WeakCollection)collection).refrencedCollection);
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (this.contains(iterator.next())) continue;
                bl = false;
            }
        }
        return bl;
    }

    public boolean addAll(Collection collection) {
        boolean bl = false;
        if (collection instanceof WeakCollection) {
            bl = this.refrencedCollection.addAll(((WeakCollection)collection).refrencedCollection);
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!this.add(iterator.next())) continue;
                bl = true;
            }
        }
        return bl;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        if (collection instanceof WeakCollection) {
            bl = this.refrencedCollection.removeAll(((WeakCollection)collection).refrencedCollection);
        } else {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                if (!this.remove(iterator.next())) continue;
                bl = true;
            }
        }
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        if (collection instanceof WeakCollection) {
            bl = this.refrencedCollection.retainAll(((WeakCollection)collection).refrencedCollection);
        } else {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (collection.contains(e)) continue;
                bl = this.remove(e);
            }
        }
        return bl;
    }

    public void clear() {
        this.refrencedCollection.clear();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof WeakCollection && this.refrencedCollection.equals(((WeakCollection)object).refrencedCollection)) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        return this.refrencedCollection.hashCode();
    }

    protected void removeUnReferencedObjects() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private class WeakIterator
    implements Iterator {
        private Iterator referencedIterator;
        private Object nextObject = null;

        public WeakIterator() {
            this.referencedIterator = WeakCollection.this.refrencedCollection.iterator();
        }

        public boolean hasNext() {
            this.nextObject = this.nextImpl();
            return this.nextObject != null;
        }

        public Object next() {
            if (this.nextObject == null) {
                this.nextObject = this.nextImpl();
            }
            Object object = this.nextObject;
            this.nextObject = null;
            return object;
        }

        public void remove() {
            this.referencedIterator.remove();
        }

        private Object nextImpl() {
            while (this.referencedIterator.hasNext()) {
                Object t = ((WeakObject)this.referencedIterator.next()).get();
                if (t != null) {
                    return t;
                }
                this.referencedIterator.remove();
            }
            return null;
        }
    }
}

