/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;

public class Invocations {
    public static List getArguments(ASTNode invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return ((MethodInvocation)invocation).arguments();
            }
            case 48: {
                return ((SuperMethodInvocation)invocation).arguments();
            }
            case 17: {
                return ((ConstructorInvocation)invocation).arguments();
            }
        }
        Assert.isTrue((boolean)false, (String)"Should not happen.");
        return null;
    }

    public static Expression getExpression(ASTNode invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return ((MethodInvocation)invocation).getExpression();
            }
            case 17: 
            case 48: {
                return null;
            }
        }
        Assert.isTrue((boolean)false, (String)"Should not happen.");
        return null;
    }

    public static boolean isInvocation(ASTNode node) {
        int type = node.getNodeType();
        return type == 32 || type == 48 || type == 17;
    }

    public static IMethodBinding resolveBinding(ASTNode invocation) {
        switch (invocation.getNodeType()) {
            case 32: {
                return (IMethodBinding)((MethodInvocation)invocation).getName().resolveBinding();
            }
            case 48: {
                return (IMethodBinding)((SuperMethodInvocation)invocation).getName().resolveBinding();
            }
            case 17: {
                return ((ConstructorInvocation)invocation).resolveConstructorBinding();
            }
        }
        Assert.isTrue((boolean)false, (String)"Should not happen.");
        return null;
    }
}

