/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.spelling;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.ui.text.spelling.CoreSpellingProblem;
import org.eclipse.jdt.internal.ui.text.spelling.JavaSpellingProblem;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;

public class JavaSpellingReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    public static final int SPELLING_PROBLEM_ID = Integer.MIN_VALUE;
    private ITextEditor fEditor;
    private IDocument fDocument;
    private IProgressMonitor fProgressMonitor;
    private IProblemRequestor fRequestor;
    private ISpellingProblemCollector fCollector;
    private SpellingContext fSpellingContext;

    public JavaSpellingReconcileStrategy(ITextEditor editor) {
        this.fEditor = editor;
        this.fCollector = new SpellingProblemCollector();
        this.fSpellingContext = new SpellingContext();
        this.fSpellingContext.setContentType(Platform.getContentTypeManager().getContentType("org.eclipse.jdt.core.javaSource"));
        this.updateProblemRequester();
    }

    public void initialReconcile() {
        this.reconcile((IRegion)new Region(0, this.fDocument.getLength()));
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    public void reconcile(IRegion region) {
        if (this.fRequestor != null && this.isSpellingEnabled()) {
            EditorsUI.getSpellingService().check(this.fDocument, this.fSpellingContext, this.fCollector, this.fProgressMonitor);
        }
    }

    private boolean isSpellingEnabled() {
        return EditorsUI.getPreferenceStore().getBoolean("spellingEnabled");
    }

    public void setDocument(IDocument document) {
        this.fDocument = document;
        this.updateProblemRequester();
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    private void updateProblemRequester() {
        IAnnotationModel model = this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        this.fRequestor = model instanceof IProblemRequestor ? (IProblemRequestor)model : null;
    }

    private class SpellingProblemCollector
    implements ISpellingProblemCollector {
        private SpellingProblemCollector() {
        }

        public void accept(SpellingProblem problem) {
            IProblemRequestor requestor = JavaSpellingReconcileStrategy.this.fRequestor;
            if (requestor != null) {
                try {
                    IEditorInput editorInput;
                    int line = JavaSpellingReconcileStrategy.this.fDocument.getLineOfOffset(problem.getOffset()) + 1;
                    String word = JavaSpellingReconcileStrategy.this.fDocument.get(problem.getOffset(), problem.getLength());
                    boolean dictionaryMatch = false;
                    boolean sentenceStart = false;
                    if (problem instanceof JavaSpellingProblem) {
                        dictionaryMatch = ((JavaSpellingProblem)problem).isDictionaryMatch();
                        sentenceStart = ((JavaSpellingProblem)problem).isSentenceStart();
                    }
                    if ((editorInput = JavaSpellingReconcileStrategy.this.fEditor.getEditorInput()) != null) {
                        CoreSpellingProblem iProblem = new CoreSpellingProblem(problem.getOffset(), problem.getOffset() + problem.getLength() - 1, line, problem.getMessage(), word, dictionaryMatch, sentenceStart, JavaSpellingReconcileStrategy.this.fDocument, editorInput.getName());
                        requestor.acceptProblem((IProblem)iProblem);
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        public void beginCollecting() {
            if (JavaSpellingReconcileStrategy.this.fRequestor != null) {
                JavaSpellingReconcileStrategy.this.fRequestor.beginReporting();
            }
        }

        public void endCollecting() {
            if (JavaSpellingReconcileStrategy.this.fRequestor != null) {
                JavaSpellingReconcileStrategy.this.fRequestor.endReporting();
            }
        }
    }
}

