/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import java.util.ResourceBundle;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.php.internal.core.documentModel.parser.regions.PhpScriptRegion;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPFunctionData;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPKeywordData;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.CodeDataResolver;
import org.eclipse.php.internal.ui.util.PHPManualFactory;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class OpenFunctionsManualAction
extends TextEditorAction
implements IUpdate {
    private PHPCodeData codeData;

    public OpenFunctionsManualAction(ResourceBundle resourceBundle, PHPStructuredEditor pHPStructuredEditor) {
        super(resourceBundle, "OpenFunctionsManualAction_", (ITextEditor)pHPStructuredEditor);
        this.setEnabled(true);
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.validAction()) {
            PHPManualFactory.getManual().showFunctionHelp(this.codeData);
            return;
        }
    }

    protected ITextSelection getCurrentSelection() {
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null) {
            return null;
        }
        ISelectionProvider iSelectionProvider = iTextEditor.getSelectionProvider();
        if (iSelectionProvider == null) {
            return null;
        }
        ISelection iSelection = iSelectionProvider.getSelection();
        if (iSelection instanceof ITextSelection) {
            return (ITextSelection)iSelection;
        }
        return null;
    }

    public void update() {
        super.update();
        if (this.validAction()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    private boolean validAction() {
        PhpScriptRegion phpScriptRegion;
        String string;
        ITextEditor iTextEditor = this.getTextEditor();
        if (iTextEditor == null) {
            return false;
        }
        IDocumentProvider iDocumentProvider = iTextEditor.getDocumentProvider();
        IEditorInput iEditorInput = iTextEditor.getEditorInput();
        if (iDocumentProvider == null || iEditorInput == null) {
            return false;
        }
        IDocument iDocument = iDocumentProvider.getDocument((Object)iEditorInput);
        if (iDocument == null) {
            return false;
        }
        if (!(iDocument instanceof IStructuredDocument)) {
            return false;
        }
        ITextSelection iTextSelection = this.getCurrentSelection();
        int n = iTextSelection.getOffset();
        IStructuredDocument iStructuredDocument = (IStructuredDocument)iDocument;
        try {
            string = iStructuredDocument.getPartition(n).getType();
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
            return false;
        }
        if (!string.equals("org.eclipse.php.PHP_DEFAULT")) {
            return false;
        }
        IStructuredDocumentRegion iStructuredDocumentRegion = iStructuredDocument.getRegionAtCharacterOffset(n);
        ITextRegion iTextRegion = iStructuredDocumentRegion.getRegionAtCharacterOffset(n);
        if (iTextRegion == null) {
            return false;
        }
        if (iTextRegion.getType() == "PHP_CONTENT") {
            phpScriptRegion = (PhpScriptRegion)iTextRegion;
            try {
                iTextRegion = phpScriptRegion.getPhpToken(n - iStructuredDocumentRegion.getStartOffset() - phpScriptRegion.getStart());
            }
            catch (BadLocationException badLocationException) {
                iTextRegion = null;
            }
        }
        if (iTextRegion == null) {
            return false;
        }
        phpScriptRegion = (StructuredTextEditor)iTextEditor;
        CodeData codeData = CodeDataResolver.getCodeData((ITextViewer)phpScriptRegion.getTextViewer(), n);
        if (codeData == null) {
            return false;
        }
        if (codeData.getUserData() != null) {
            return false;
        }
        if (codeData.isUserCode()) {
            return false;
        }
        if (!(codeData instanceof PHPFunctionData) && !(codeData instanceof PHPKeywordData)) {
            return false;
        }
        this.codeData = (PHPCodeData)codeData;
        return true;
    }
}

