/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.core.project.options.includepath.IncludePathEntry;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.preferences.includepath.IIncludePathContainerPage;
import org.eclipse.php.internal.ui.preferences.includepath.IIncludePathContainerPageExtension;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathPropertyPage;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.php.internal.ui.wizards.fields.DialogField;
import org.eclipse.php.internal.ui.wizards.fields.IDialogFieldListener;
import org.eclipse.php.internal.ui.wizards.fields.LayoutUtil;
import org.eclipse.php.internal.ui.wizards.fields.StringDialogField;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class IncludePathContainerDefaultPage
extends WizardPage
implements IIncludePathContainerPage,
IIncludePathContainerPageExtension {
    private StringDialogField fEntryField;
    private ArrayList fUsedPaths;

    public IncludePathContainerDefaultPage() {
        super("IncludePathContainerDefaultPage");
        this.setTitle(PHPUIMessages.IncludePathContainerDefaultPage_title);
        this.setDescription(PHPUIMessages.IncludePathContainerDefaultPage_description);
        this.setImageDescriptor(PHPPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fUsedPaths = new ArrayList();
        this.fEntryField = new StringDialogField();
        this.fEntryField.setLabelText(PHPUIMessages.IncludePathContainerDefaultPage_path_label);
        this.fEntryField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField dialogField) {
                IncludePathContainerDefaultPage.this.validatePath();
            }
        });
        this.validatePath();
    }

    private void validatePath() {
        StatusInfo statusInfo = new StatusInfo();
        String string = this.fEntryField.getText();
        if (string.length() == 0) {
            statusInfo.setError(PHPUIMessages.IncludePathContainerDefaultPage_path_error_enterpath);
        } else if (!Path.ROOT.isValidPath(string)) {
            statusInfo.setError(PHPUIMessages.IncludePathContainerDefaultPage_path_error_invalidpath);
        } else {
            Path path = new Path(string);
            if (path.segmentCount() == 0) {
                statusInfo.setError(PHPUIMessages.IncludePathContainerDefaultPage_path_error_needssegment);
            } else if (this.fUsedPaths.contains(path)) {
                statusInfo.setError(PHPUIMessages.IncludePathContainerDefaultPage_path_error_alreadyexists);
            }
        }
        this.updateStatus((IStatus)statusInfo);
    }

    protected void updateStatus(IStatus iStatus) {
        IncludePathPropertyPage.applyToStatusLine((DialogPage)this, iStatus);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        composite2.setLayout((Layout)gridLayout);
        this.fEntryField.doFillIntoGrid(composite2, 2);
        LayoutUtil.setHorizontalGrabbing((Control)this.fEntryField.getTextControl(null));
        this.fEntryField.setFocus();
        this.setControl((Control)composite2);
        Dialog.applyDialogFont((Control)composite2);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite2, "org.eclipse.php.ui.includepath_container_default_page_context");
    }

    public boolean finish() {
        return true;
    }

    public IIncludePathEntry getSelection() {
        return IncludePathEntry.newContainerEntry((IPath)new Path(this.fEntryField.getText()), null, (boolean)true);
    }

    public void initialize(IProject iProject, IIncludePathEntry[] iIncludePathEntryArray) {
        int n = 0;
        while (n < iIncludePathEntryArray.length) {
            IIncludePathEntry iIncludePathEntry = iIncludePathEntryArray[n];
            if (iIncludePathEntry.getEntryKind() == 5) {
                this.fUsedPaths.add(iIncludePathEntry.getPath());
            }
            ++n;
        }
    }

    public void setSelection(IIncludePathEntry iIncludePathEntry) {
        if (iIncludePathEntry != null) {
            this.fUsedPaths.remove(iIncludePathEntry.getPath());
            this.fEntryField.setText(iIncludePathEntry.getPath().toString());
        } else {
            this.fEntryField.setText("");
        }
    }
}

