/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences.includepath;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.php.internal.core.project.IIncludePathEntry;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.includepath.EditVariableEntryDialog;
import org.eclipse.php.internal.ui.preferences.includepath.IncludePathContainerWizard;
import org.eclipse.php.internal.ui.preferences.includepath.MultipleFolderSelectionDialog;
import org.eclipse.php.internal.ui.preferences.includepath.NewVariableEntryDialog;
import org.eclipse.php.internal.ui.util.TypedViewerFilter;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public final class IncludePathDialogAccess {
    public static final String DIALOGSTORE_LASTVARIABLE = "org.eclipse.php.ui.lastvariable";
    public static final String DIALOGSTORE_LASTINCLUDEFOLDER = "org.eclipse.php.ui.lastincludefolder";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private IncludePathDialogAccess() {
    }

    public static IPath configureVariableEntry(Shell shell, IPath iPath, IPath[] iPathArray) {
        if (iPathArray == null) {
            throw new IllegalArgumentException();
        }
        EditVariableEntryDialog editVariableEntryDialog = new EditVariableEntryDialog(shell, iPath, iPathArray);
        if (editVariableEntryDialog.open() == 0) {
            return editVariableEntryDialog.getPath();
        }
        return null;
    }

    public static IPath[] chooseVariableEntries(Shell shell, IPath[] iPathArray) {
        if (iPathArray == null) {
            throw new IllegalArgumentException();
        }
        NewVariableEntryDialog newVariableEntryDialog = new NewVariableEntryDialog(shell);
        if (newVariableEntryDialog.open() == 0) {
            return newVariableEntryDialog.getResult();
        }
        return null;
    }

    public static IIncludePathEntry configureContainerEntry(Shell shell, IIncludePathEntry iIncludePathEntry, IProject iProject, IIncludePathEntry[] iIncludePathEntryArray) {
        IIncludePathEntry[] iIncludePathEntryArray2;
        if (iIncludePathEntry == null || iIncludePathEntryArray == null) {
            throw new IllegalArgumentException();
        }
        IncludePathContainerWizard includePathContainerWizard = new IncludePathContainerWizard(iIncludePathEntry, iProject, iIncludePathEntryArray);
        if (IncludePathContainerWizard.openWizard(shell, includePathContainerWizard) == 0 && (iIncludePathEntryArray2 = includePathContainerWizard.getNewEntries()) != null && iIncludePathEntryArray2.length == 1) {
            return iIncludePathEntryArray2[0];
        }
        return null;
    }

    public static IIncludePathEntry[] chooseContainerEntries(Shell shell, IProject iProject, IIncludePathEntry[] iIncludePathEntryArray) {
        if (iIncludePathEntryArray == null) {
            throw new IllegalArgumentException();
        }
        IncludePathContainerWizard includePathContainerWizard = new IncludePathContainerWizard(null, iProject, iIncludePathEntryArray);
        if (IncludePathContainerWizard.openWizard(shell, includePathContainerWizard) == 0) {
            return includePathContainerWizard.getNewEntries();
        }
        return null;
    }

    public static IPath[] chooseIncludePathFoldersEntries(Shell shell) {
        String string = PHPUiPlugin.getDefault().getDialogSettings().get(DIALOGSTORE_LASTINCLUDEFOLDER);
        if (string == null) {
            string = "";
        }
        DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4);
        directoryDialog.setText(PHPUIMessages.IncludePathDialogAccess_IncludePathFolderDialog_new_title);
        directoryDialog.setMessage(PHPUIMessages.IncludePathDialogAccess_IncludePathFolderDialog_new_description);
        directoryDialog.setFilterPath(string);
        String string2 = directoryDialog.open();
        if (string2 == null) {
            return null;
        }
        IPath iPath = new Path(string2).makeAbsolute();
        PHPUiPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LASTINCLUDEFOLDER, iPath.removeLastSegments(1).toOSString());
        return new IPath[]{iPath};
    }

    public static IPath configureIncludePathFolderEntry(Shell shell, IPath iPath) {
        if (iPath == null) {
            throw new IllegalArgumentException();
        }
        String string = iPath.removeLastSegments(1).toOSString();
        DirectoryDialog directoryDialog = new DirectoryDialog(shell, 4);
        directoryDialog.setText(PHPUIMessages.IncludePathDialogAccess_0);
        directoryDialog.setFilterPath(string);
        String string2 = directoryDialog.open();
        if (string2 == null) {
            return null;
        }
        IPath iPath2 = new Path(string2).makeAbsolute();
        PHPUiPlugin.getDefault().getDialogSettings().put(DIALOGSTORE_LASTINCLUDEFOLDER, iPath2.removeLastSegments(1).toOSString());
        return iPath2;
    }

    public static IPath[] chooseFolderEntries(Shell shell, IPath iPath, IPath[] iPathArray) {
        if (iPathArray == null) {
            throw new IllegalArgumentException();
        }
        String string = PHPUIMessages.IncludePathDialogAccess_ExistingPHPFolderDialog_new_title;
        String string2 = PHPUIMessages.IncludePathDialogAccess_ExistingPHPFolderDialog_new_description;
        return IncludePathDialogAccess.internalChooseFolderEntry(shell, iPath, iPathArray, string, string2);
    }

    public static IPath[] chooseSourceFolderEntries(Shell shell, IPath iPath, IPath[] iPathArray) {
        if (iPathArray == null) {
            throw new IllegalArgumentException();
        }
        String string = PHPUIMessages.IncludePathDialogAccess_ExistingSourceFolderDialog_new_title;
        String string2 = PHPUIMessages.IncludePathDialogAccess_ExistingSourceFolderDialog_new_description;
        return IncludePathDialogAccess.internalChooseFolderEntry(shell, iPath, iPathArray, string, string2);
    }

    private static IPath[] internalChooseFolderEntry(Shell shell, IPath iPath, IPath[] iPathArray, String string, String string2) {
        Object[] objectArray;
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] classArray2 = classArray;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>(iPathArray.length);
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int n = 0;
        while (n < iPathArray.length) {
            objectArray = iWorkspaceRoot.findMember(iPathArray[n]);
            if (objectArray instanceof IContainer) {
                arrayList.add(objectArray);
            }
            ++n;
        }
        IResource iResource = iPath != null ? iWorkspaceRoot.findMember(iPath) : null;
        objectArray = arrayList.toArray();
        MultipleFolderSelectionDialog multipleFolderSelectionDialog = new MultipleFolderSelectionDialog(shell, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        multipleFolderSelectionDialog.setExisting(objectArray);
        multipleFolderSelectionDialog.setTitle(string);
        multipleFolderSelectionDialog.setMessage(string2);
        multipleFolderSelectionDialog.addFilter(new TypedViewerFilter(classArray2, objectArray));
        multipleFolderSelectionDialog.setInput(iWorkspaceRoot);
        multipleFolderSelectionDialog.setInitialFocus(iResource);
        if (multipleFolderSelectionDialog.open() == 0) {
            Object[] objectArray2 = multipleFolderSelectionDialog.getResult();
            IPath[] iPathArray2 = new IPath[objectArray2.length];
            int n2 = 0;
            while (n2 < iPathArray2.length) {
                IResource iResource2 = (IResource)objectArray2[n2];
                iPathArray2[n2] = iResource2.getFullPath();
                ++n2;
            }
            return iPathArray2;
        }
        return null;
    }
}

