/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.search.GroupAction;
import org.eclipse.php.internal.ui.search.PHPSearchContentProvider;
import org.eclipse.php.internal.ui.search.PHPSearchEditorOpener;
import org.eclipse.php.internal.ui.search.PHPSearchTableContentProvider;
import org.eclipse.php.internal.ui.search.PHPSearchTreeContentProvider;
import org.eclipse.php.internal.ui.search.PostfixLabelProvider;
import org.eclipse.php.internal.ui.util.PHPElementSorter;
import org.eclipse.php.internal.ui.util.PHPPluginImages;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class PHPSearchResultPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final String KEY_GROUPING = "org.eclipse.php.search.resultpage.grouping";
    private static final String GROUP_GROUPING = "org.eclipse.php.search.resultpage.grouping";
    private GroupAction fGroupTypeAction;
    private GroupAction fGroupFileAction;
    private GroupAction fGroupProjectAction;
    private int fCurrentGrouping;
    private PHPSearchContentProvider fContentProvider;
    private PHPSearchEditorOpener fEditorOpener = new PHPSearchEditorOpener();

    public PHPSearchResultPage() {
        this.initGroupingActions();
    }

    public Object getAdapter(Class clazz) {
        return null;
    }

    public void showMatch(Match match, int n, int n2, boolean bl) throws PartInitException {
        IEditorPart iEditorPart;
        try {
            iEditorPart = this.fEditorOpener.openMatch(match);
        }
        catch (Exception exception) {
            throw new PartInitException(exception.getMessage());
        }
        if (iEditorPart != null && bl) {
            iEditorPart.getEditorSite().getPage().activate((IWorkbenchPart)iEditorPart);
        }
        Object object = match.getElement();
        if (iEditorPart instanceof ITextEditor) {
            ITextEditor iTextEditor = (ITextEditor)iEditorPart;
            iTextEditor.selectAndReveal(n, n2);
        } else if (iEditorPart != null && object instanceof IFile) {
            IFile iFile = (IFile)object;
            this.showWithMarker(iEditorPart, iFile, n, n2);
        }
    }

    protected void fillToolbar(IToolBarManager iToolBarManager) {
        super.fillToolbar(iToolBarManager);
        if (this.getLayout() != 1) {
            this.addGroupActions(iToolBarManager);
        }
    }

    void setGrouping(int n) {
        this.fCurrentGrouping = n;
        StructuredViewer structuredViewer = this.getViewer();
        PHPSearchTreeContentProvider pHPSearchTreeContentProvider = (PHPSearchTreeContentProvider)structuredViewer.getContentProvider();
        pHPSearchTreeContentProvider.setLevel(n);
        this.updateGroupingActions();
        this.getSettings().put("org.eclipse.php.search.resultpage.grouping", this.fCurrentGrouping);
        this.getViewPart().updateLabel();
    }

    private void addGroupActions(IToolBarManager iToolBarManager) {
        iToolBarManager.appendToGroup("group.viewerSetup", (IContributionItem)new Separator("org.eclipse.php.search.resultpage.grouping"));
        iToolBarManager.appendToGroup("org.eclipse.php.search.resultpage.grouping", (IAction)this.fGroupProjectAction);
        iToolBarManager.appendToGroup("org.eclipse.php.search.resultpage.grouping", (IAction)this.fGroupFileAction);
        iToolBarManager.appendToGroup("org.eclipse.php.search.resultpage.grouping", (IAction)this.fGroupTypeAction);
        this.updateGroupingActions();
    }

    private void updateGroupingActions() {
        this.fGroupProjectAction.setChecked(this.fCurrentGrouping == 0);
        this.fGroupFileAction.setChecked(this.fCurrentGrouping == 1);
        this.fGroupTypeAction.setChecked(this.fCurrentGrouping == 2);
    }

    private void showWithMarker(IEditorPart iEditorPart, IFile iFile, int n, int n2) throws PartInitException {
        try {
            IMarker iMarker = iFile.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(4);
            hashMap.put("charStart", new Integer(n));
            hashMap.put("charEnd", new Integer(n + n2));
            iMarker.setAttributes(hashMap);
            IDE.gotoMarker((IEditorPart)iEditorPart, (IMarker)iMarker);
            iMarker.delete();
        }
        catch (CoreException coreException) {
            throw new PartInitException(PHPUIMessages.PHPSearchResultPage_error_marker, (Throwable)coreException);
        }
    }

    private void initGroupingActions() {
        this.fGroupProjectAction = new GroupAction(PHPUIMessages.PHPSearchResultPage_groupby_project, PHPUIMessages.PHPSearchResultPage_groupby_project_tooltip, this, 0);
        PHPPluginImages.setLocalImageDescriptors((IAction)this.fGroupProjectAction, "group_by_project.gif");
        this.fGroupFileAction = new GroupAction(PHPUIMessages.PHPSearchResultPage_groupby_file, PHPUIMessages.PHPSearchResultPage_groupby_file_tooltip, this, 1);
        PHPPluginImages.setLocalImageDescriptors((IAction)this.fGroupFileAction, "group_by_file.gif");
        this.fGroupTypeAction = new GroupAction(PHPUIMessages.PHPSearchResultPage_groupby_type, PHPUIMessages.PHPSearchResultPage_groupby_type_tooltip, this, 2);
        PHPPluginImages.setLocalImageDescriptors((IAction)this.fGroupTypeAction, "group_by_type.gif");
    }

    protected StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void elementsChanged(Object[] objectArray) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objectArray);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    protected void configureTreeViewer(TreeViewer treeViewer) {
        treeViewer.setUseHashlookup(true);
        this.fContentProvider = new PHPSearchTreeContentProvider(this, this.fCurrentGrouping);
        treeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        treeViewer.setLabelProvider((IBaseLabelProvider)new PostfixLabelProvider(this, 18));
        treeViewer.setSorter((ViewerSorter)new PHPElementSorter());
    }

    protected void configureTableViewer(TableViewer tableViewer) {
        tableViewer.setUseHashlookup(true);
        this.fContentProvider = new PHPSearchTableContentProvider(this);
        tableViewer.setContentProvider((IContentProvider)this.fContentProvider);
        tableViewer.setLabelProvider((IBaseLabelProvider)new PostfixLabelProvider(this, 18));
        tableViewer.setSorter((ViewerSorter)new PHPElementSorter());
    }
}

