/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebugCorePreferenceNames;
import org.eclipse.php.internal.debug.core.preferences.PHPProjectPreferences;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.preferences.PHPDebugPreferencesAddon;
import org.eclipse.php.internal.server.core.Server;
import org.eclipse.php.internal.server.core.manager.ServersManager;
import org.eclipse.php.internal.ui.preferences.AbstractPHPPreferencePageBlock;
import org.eclipse.php.internal.ui.util.ScrolledPageContent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.internal.forms.widgets.FormUtil;
import org.eclipse.wst.xml.ui.internal.preferences.EncodingSettings;
import org.osgi.service.prefs.BackingStoreException;

public class PHPDebugPreferencesAddon
extends AbstractPHPPreferencePageBlock {
    private static final String SERVERS_PAGE_ID = "org.eclipse.php.server.internal.ui.PHPServersPreferencePage";
    private static final String PHP_EXE_PAGE_ID = "org.eclipse.php.debug.ui.preferencesphps.PHPsPreferencePage";
    private Button fStopAtFirstLine;
    private Combo fDefaultServer;
    private Combo fDefaultPHPExe;
    private EncodingSettings fDebugEncodingSettings;
    private EncodingSettings fOutputEncodingSettings;
    private PreferencePage propertyPage;
    private ExpandableComposite expandbleDebugEncoding;
    private ExpandableComposite expandbleOutputEncoding;

    public void setCompositeAddon(Composite composite) {
        Composite composite2 = this.addPageContents(composite);
        this.addProjectPreferenceSubsection(this.createSubsection(composite2, PHPDebugUIMessages.PhpDebugPreferencePage_6));
    }

    public void initializeValues(PreferencePage preferencePage) {
        String string;
        IEclipsePreferences iEclipsePreferences;
        this.propertyPage = preferencePage;
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        IScopeContext[] iScopeContextArray = this.createPreferenceScopes(preferencePage);
        boolean bl = preferences.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
        String string2 = ServersManager.getDefaultServer(null).getName();
        String string3 = preferences.getString(PHPDebugCorePreferenceNames.DEFAULT_PHP);
        String string4 = preferences.getString(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
        String string5 = preferences.getString(PHPDebugCorePreferenceNames.OUTPUT_ENCODING);
        this.loadServers(this.fDefaultServer);
        this.loadPHPExes(this.fDefaultPHPExe);
        if (iScopeContextArray[0] instanceof ProjectScope && (iEclipsePreferences = iScopeContextArray[0].getNode(this.getPreferenceNodeQualifier())) != null && this.getProject(preferencePage) != null && !(string = ServersManager.getDefaultServer((IProject)this.getProject(preferencePage)).getName()).equals("")) {
            string2 = string;
            bl = iEclipsePreferences.getBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, bl);
            string4 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, "");
            string5 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, "");
            string3 = iEclipsePreferences.get(PHPDebugCorePreferenceNames.DEFAULT_PHP, string3);
        }
        this.fStopAtFirstLine.setSelection(bl);
        this.fDefaultServer.select(this.fDefaultServer.indexOf(string2));
        this.fDefaultPHPExe.select(this.fDefaultPHPExe.indexOf(string3));
        this.fDebugEncodingSettings.setIANATag(string4);
        this.fOutputEncodingSettings.setIANATag(string5);
    }

    public boolean performOK(boolean bl) {
        this.savePreferences(bl);
        return true;
    }

    public void performApply(boolean bl) {
        this.performOK(bl);
    }

    public boolean performCancel() {
        return true;
    }

    public void performDefaults() {
        Preferences preferences = PHPProjectPreferences.getModelPreferences();
        this.fStopAtFirstLine.setSelection(preferences.getDefaultBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE));
        this.loadServers(this.fDefaultServer);
        this.loadPHPExes(this.fDefaultPHPExe);
        this.fDebugEncodingSettings.setIANATag(preferences.getDefaultString(PHPDebugCorePreferenceNames.TRANSFER_ENCODING));
        this.fOutputEncodingSettings.setIANATag(preferences.getDefaultString(PHPDebugCorePreferenceNames.OUTPUT_ENCODING));
    }

    protected String getPreferenceNodeQualifier() {
        return PHPProjectPreferences.getPreferenceNodeQualifier();
    }

    private void loadServers(Combo combo) {
        combo.removeAll();
        Server[] serverArray = ServersManager.getServers();
        if (serverArray != null) {
            int n = 0;
            while (n < serverArray.length) {
                combo.add(serverArray[n].getName());
                ++n;
            }
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        }
    }

    private void loadPHPExes(Combo combo) {
        combo.removeAll();
        PHPexes pHPexes = new PHPexes();
        pHPexes.load(PHPProjectPreferences.getModelPreferences());
        PHPexeItem[] pHPexeItemArray = pHPexes.getItems();
        if (pHPexeItemArray != null) {
            int n = 0;
            while (n < pHPexeItemArray.length) {
                combo.add(pHPexeItemArray[n].getName());
                ++n;
            }
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        }
    }

    private void addProjectPreferenceSubsection(Composite composite) {
        GridData gridData = (GridData)composite.getLayoutData();
        gridData.heightHint = 200;
        composite.setLayoutData((Object)gridData);
        this.addLabelControl(composite, PHPDebugUIMessages.PhpDebugPreferencePage_9, "defaultPHPServer");
        this.fDefaultServer = this.addCombo(composite, 2);
        this.addLink(composite, PHPDebugUIMessages.PhpDebugPreferencePage_serversLink, SERVERS_PAGE_ID);
        this.addLabelControl(composite, PHPDebugUIMessages.PhpDebugPreferencePage_12, PHPDebugCorePreferenceNames.DEFAULT_PHP);
        this.fDefaultPHPExe = this.addCombo(composite, 2);
        this.addLink(composite, PHPDebugUIMessages.PhpDebugPreferencePage_installedPHPsLink, PHP_EXE_PAGE_ID);
        ScrolledPageContent scrolledPageContent = new ScrolledPageContent(composite);
        Composite composite2 = scrolledPageContent.getBody();
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        scrolledPageContent.setLayoutData((Object)gridData);
        this.expandbleDebugEncoding = this.createStyleSection(composite2, PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding, 3);
        Composite composite3 = new Composite((Composite)this.expandbleDebugEncoding, 0);
        composite3.setFont(composite.getFont());
        composite3.setLayout((Layout)new GridLayout(3, false));
        this.expandbleDebugEncoding.setClient((Control)composite3);
        this.fDebugEncodingSettings = this.addEncodingSettings(composite3, PHPDebugUIMessages.PHPDebugPreferencesAddon_selectedEncoding);
        this.expandbleOutputEncoding = this.createStyleSection(composite2, PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding, 3);
        composite3 = new Composite((Composite)this.expandbleOutputEncoding, 0);
        composite3.setFont(composite.getFont());
        composite3.setLayout((Layout)new GridLayout(3, false));
        this.expandbleOutputEncoding.setClient((Control)composite3);
        this.fOutputEncodingSettings = this.addEncodingSettings(composite3, PHPDebugUIMessages.PHPDebugPreferencesAddon_selectedEncoding);
        this.expandbleOutputEncoding.setText(String.valueOf(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding) + " (" + this.fOutputEncodingSettings.getIANATag() + ")");
        this.fStopAtFirstLine = this.addCheckBox(composite, PHPDebugUIMessages.PhpDebugPreferencePage_1, PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, 0);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                PHPDebugPreferencesAddon.this.expandbleDebugEncoding.setExpanded(true);
                ScrolledPageContent scrolledPageContent = (ScrolledPageContent)FormUtil.getScrolledComposite((Control)PHPDebugPreferencesAddon.this.expandbleDebugEncoding);
                Point point = scrolledPageContent.getSize();
                scrolledPageContent.setSize(point.x, 70);
                scrolledPageContent.getParent().layout();
            }
        });
    }

    private ExpandableComposite createStyleSection(Composite composite, String string, int n) {
        ExpandableComposite expandableComposite = new ExpandableComposite(composite, 0, 18);
        expandableComposite.setText(string);
        expandableComposite.setExpanded(false);
        expandableComposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        expandableComposite.setLayoutData((Object)new GridData(4, 4, true, false, n, 1));
        expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent expansionEvent) {
                PHPDebugPreferencesAddon.this.expandedStateChanged((ExpandableComposite)expansionEvent.getSource());
            }
        });
        return expandableComposite;
    }

    private void expandedStateChanged(ExpandableComposite expandableComposite) {
        if (expandableComposite.isExpanded()) {
            if (expandableComposite == this.expandbleDebugEncoding) {
                this.expandbleDebugEncoding.setText(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding);
                this.expandbleOutputEncoding.setText(String.valueOf(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding) + " (" + this.fOutputEncodingSettings.getIANATag() + ")");
                this.expandbleOutputEncoding.setExpanded(false);
            } else {
                this.expandbleOutputEncoding.setText(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding);
                this.expandbleDebugEncoding.setText(String.valueOf(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding) + " (" + this.fDebugEncodingSettings.getIANATag() + ")");
                this.expandbleDebugEncoding.setExpanded(false);
            }
        } else if (expandableComposite == this.expandbleDebugEncoding) {
            this.expandbleDebugEncoding.setText(String.valueOf(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding) + " (" + this.fDebugEncodingSettings.getIANATag() + ")");
            this.expandbleOutputEncoding.setText(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding);
            this.expandbleOutputEncoding.setExpanded(true);
        } else {
            this.expandbleOutputEncoding.setText(String.valueOf(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugOutputEncoding) + " (" + this.fOutputEncodingSettings.getIANATag() + ")");
            this.expandbleDebugEncoding.setText(PHPDebugUIMessages.PHPDebugPreferencesAddon_debugTransferEncoding);
            this.expandbleDebugEncoding.setExpanded(true);
        }
        ScrolledPageContent scrolledPageContent = this.getParentScrolledComposite((Control)expandableComposite);
        if (scrolledPageContent != null) {
            scrolledPageContent.reflow(true);
        }
    }

    private ScrolledPageContent getParentScrolledComposite(Control control) {
        Composite composite = control.getParent();
        while (!(composite instanceof ScrolledPageContent) && composite != null) {
            composite = composite.getParent();
        }
        if (composite instanceof ScrolledPageContent) {
            return (ScrolledPageContent)composite;
        }
        return null;
    }

    private void addLink(Composite composite, String string, final String string2) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setLayoutData((Object)new GridData(0x1000008, 1, true, false));
        link.setText(string);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)PHPDebugPreferencesAddon.this.propertyPage.getShell(), (String)string2, null, null);
                preferenceDialog.setBlockOnOpen(true);
                preferenceDialog.addPageChangedListener(new IPageChangedListener(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void pageChanged(PageChangedEvent pageChangedEvent) {
                        Display.getDefault().asyncExec(new Runnable(this){
                            final /* synthetic */ 4 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                String string = PHPDebugPreferencesAddon.access$3(3.access$0(4.access$0(this.this$2))).getText();
                                String string2 = PHPDebugPreferencesAddon.access$4(3.access$0(4.access$0(this.this$2))).getText();
                                PHPDebugPreferencesAddon.access$5(3.access$0(4.access$0(this.this$2)), PHPDebugPreferencesAddon.access$3(3.access$0(4.access$0(this.this$2))));
                                PHPDebugPreferencesAddon.access$6(3.access$0(4.access$0(this.this$2)), PHPDebugPreferencesAddon.access$4(3.access$0(4.access$0(this.this$2))));
                                PHPDebugPreferencesAddon.access$7(3.access$0(4.access$0(this.this$2)), PHPDebugPreferencesAddon.access$3(3.access$0(4.access$0(this.this$2))), PHPDebugPreferencesAddon.access$3(3.access$0(4.access$0(this.this$2))).indexOf(string));
                                PHPDebugPreferencesAddon.access$7(3.access$0(4.access$0(this.this$2)), PHPDebugPreferencesAddon.access$4(3.access$0(4.access$0(this.this$2))), PHPDebugPreferencesAddon.access$4(3.access$0(4.access$0(this.this$2))).indexOf(string2));
                            }
                        });
                    }

                    static /* synthetic */ 3 access$0(4 var0) {
                        return var0.this$1;
                    }
                });
                preferenceDialog.open();
            }

            static /* synthetic */ PHPDebugPreferencesAddon access$0(3 var0) {
                return var0.PHPDebugPreferencesAddon.this;
            }
        });
    }

    private void selectComboItem(Combo combo, int n) {
        if (n < 0) {
            if (combo.getItemCount() > 0) {
                combo.select(0);
            }
        } else {
            combo.select(n);
        }
    }

    private EncodingSettings addEncodingSettings(Composite composite, String string) {
        EncodingSettings encodingSettings = new EncodingSettings(composite, string);
        GridData gridData = (GridData)encodingSettings.getLayoutData();
        gridData.horizontalSpan = 3;
        gridData.verticalAlignment = 0;
        gridData.verticalIndent = -5;
        gridData.horizontalIndent = -5;
        encodingSettings.setLayoutData((Object)gridData);
        return encodingSettings;
    }

    private Combo addCombo(Composite composite, int n) {
        Combo combo = new Combo(composite, 2060);
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = n;
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    private void savePreferences(boolean bl) {
        Preferences preferences;
        String string = this.fDefaultPHPExe.getText();
        PHPexes pHPexes = new PHPexes();
        pHPexes.load(PHPProjectPreferences.getModelPreferences());
        if (pHPexes.getItem(string) == null) {
            preferences = pHPexes.getDefaultItem();
            string = preferences != null ? preferences.getName() : "";
        }
        preferences = PHPProjectPreferences.getModelPreferences();
        IScopeContext[] iScopeContextArray = this.createPreferenceScopes(this.propertyPage);
        IEclipsePreferences iEclipsePreferences = iScopeContextArray[0].getNode(this.getPreferenceNodeQualifier());
        IProject iProject = this.getProject(this.propertyPage);
        if (bl && iEclipsePreferences != null && iScopeContextArray[0] instanceof ProjectScope && iProject != null) {
            iEclipsePreferences.putBoolean(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.DEFAULT_PHP, string);
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fDebugEncodingSettings.getIANATag());
            iEclipsePreferences.put(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, this.fOutputEncodingSettings.getIANATag());
            ServersManager.setDefaultServer((IProject)iProject, (String)this.fDefaultServer.getText());
        } else if (iProject == null) {
            preferences.setValue(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE, this.fStopAtFirstLine.getSelection());
            preferences.setValue(PHPDebugCorePreferenceNames.DEFAULT_PHP, string);
            preferences.setValue(PHPDebugCorePreferenceNames.TRANSFER_ENCODING, this.fDebugEncodingSettings.getIANATag());
            preferences.setValue(PHPDebugCorePreferenceNames.OUTPUT_ENCODING, this.fOutputEncodingSettings.getIANATag());
            ServersManager.setDefaultServer(null, (String)this.fDefaultServer.getText());
        } else if (iEclipsePreferences != null) {
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.STOP_AT_FIRST_LINE);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.DEBUG_PORT);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.DEFAULT_PHP);
            ServersManager.setDefaultServer((IProject)iProject, null);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.TRANSFER_ENCODING);
            iEclipsePreferences.remove(PHPDebugCorePreferenceNames.OUTPUT_ENCODING);
        }
        try {
            iEclipsePreferences.flush();
            PHPDebugPlugin.getDefault().savePluginPreferences();
        }
        catch (BackingStoreException backingStoreException) {
            Logger.logException(backingStoreException);
        }
    }

    static /* synthetic */ Combo access$3(PHPDebugPreferencesAddon pHPDebugPreferencesAddon) {
        return pHPDebugPreferencesAddon.fDefaultServer;
    }

    static /* synthetic */ Combo access$4(PHPDebugPreferencesAddon pHPDebugPreferencesAddon) {
        return pHPDebugPreferencesAddon.fDefaultPHPExe;
    }

    static /* synthetic */ void access$5(PHPDebugPreferencesAddon pHPDebugPreferencesAddon, Combo combo) {
        pHPDebugPreferencesAddon.loadServers(combo);
    }

    static /* synthetic */ void access$6(PHPDebugPreferencesAddon pHPDebugPreferencesAddon, Combo combo) {
        pHPDebugPreferencesAddon.loadPHPExes(combo);
    }

    static /* synthetic */ void access$7(PHPDebugPreferencesAddon pHPDebugPreferencesAddon, Combo combo, int n) {
        pHPDebugPreferencesAddon.selectComboItem(combo, n);
    }
}

