/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.debugger;

import org.eclipse.php.internal.debug.core.debugger.Expression;
import org.eclipse.php.internal.debug.core.debugger.ExpressionValue;

public class DefaultExpression
implements Expression {
    private String[] name;
    private String fullName;
    private ExpressionValue expressionValue;

    public DefaultExpression(String string) {
        this.name = new String[]{string.trim()};
        this.fullName = string;
        this.setValue(null);
    }

    public String[] getName() {
        return this.name;
    }

    public String getLastName() {
        return this.name[this.name.length - 1];
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setValue(ExpressionValue expressionValue) {
        if (expressionValue == null) {
            expressionValue = ExpressionValue.NULL_VALUE;
        }
        this.expressionValue = expressionValue;
    }

    public ExpressionValue getValue() {
        return this.expressionValue;
    }

    public String toString() {
        return String.valueOf(this.getLastName()) + " = " + this.getValue().getValueAsString();
    }

    public Expression createChildExpression(String string, String string2) {
        return new DefaultExpression(this, string, string2);
    }

    protected DefaultExpression(Expression expression, String string, String string2) {
        String[] stringArray = expression.getName();
        this.name = new String[stringArray.length + 1];
        System.arraycopy(stringArray, 0, this.name, 0, stringArray.length);
        this.name[stringArray.length] = string;
        this.fullName = String.valueOf(expression.getFullName()) + string2;
        this.setValue(null);
    }
}

