/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.IObjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.ObjectSelectionRegistry;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.WSDLSelectionWrapper;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceImpl;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.wst.command.internal.env.core.data.Transformer;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.StatusException;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.parser.wsil.WebServicesParser;

public class ObjectSelectionOutputCommand
extends AbstractDataModelOperation {
    private String objectSelectionWidgetId_;
    private IStructuredSelection objectSelection_;
    private IObjectSelectionWidget objectSelectionWidget_;
    private IProject project_;
    private String componentName_;
    private WebServicesParser parser_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IStatus status;
        IEnvironment env = this.getEnvironment();
        if (this.objectSelectionWidgetId_ != null && this.objectSelectionWidgetId_.length() > 0) {
            Object transformedSelection;
            Transformer transformer = ObjectSelectionRegistry.getInstance().getTransformer(this.objectSelectionWidgetId_);
            Object object = transformedSelection = transformer == null ? null : transformer.transform((Object)this.objectSelection_);
            if (transformedSelection instanceof IStructuredSelection) {
                this.objectSelection_ = (IStructuredSelection)transformedSelection;
            }
        }
        IStatus iStatus = status = this.objectSelectionWidget_ != null ? this.objectSelectionWidget_.validateSelection(this.getObjectSelection()) : Status.OK_STATUS;
        if (status.getSeverity() != 0 && env != null) {
            try {
                env.getStatusHandler().report(status);
            }
            catch (StatusException statusException) {}
        }
        return status;
    }

    public void setTypeRuntimeServer(TypeRuntimeServer typeRuntimeServer) {
        if (typeRuntimeServer != null) {
            String wst = typeRuntimeServer.getTypeId();
            int scenario = WebServiceRuntimeExtensionUtils2.getScenarioFromTypeId(wst);
            String implId = WebServiceRuntimeExtensionUtils2.getWebServiceImplIdFromTypeId(wst);
            WebServiceImpl wsimpl = WebServiceRuntimeExtensionUtils2.getWebServiceImplById(implId);
            if (wsimpl != null) {
                String objectSelectionWidgetId = null;
                objectSelectionWidgetId = scenario == 1 ? "org.eclipse.jst.ws.internal.consumption.ui.widgets.object.WSDLSelectionWidget" : wsimpl.getObjectSelectionWidget();
                this.objectSelectionWidgetId_ = objectSelectionWidgetId;
                Object object = ObjectSelectionRegistry.getInstance().getSelectionWidget(this.objectSelectionWidgetId_);
                if (object instanceof IObjectSelectionWidget) {
                    this.objectSelectionWidget_ = (IObjectSelectionWidget)object;
                }
            }
        }
    }

    public IStructuredSelection getObjectSelection() {
        return this.objectSelection_;
    }

    public void setObjectSelection(IStructuredSelection objectSelection) {
        Object object;
        this.objectSelection_ = objectSelection;
        if (this.project_ == null) {
            this.project_ = this.getProjectFromObjectSelection(objectSelection);
        }
        if (this.componentName_ == null) {
            this.componentName_ = this.getComponentNameFromObjectSelection(objectSelection);
        }
        if (objectSelection != null && !objectSelection.isEmpty() && (object = objectSelection.getFirstElement()) instanceof WSDLSelectionWrapper) {
            WSDLSelectionWrapper wsdlWrapper = (WSDLSelectionWrapper)object;
            this.objectSelection_ = wsdlWrapper.wsdlSelection;
            this.parser_ = wsdlWrapper.parser;
        }
    }

    public IProject getProject() {
        return this.project_;
    }

    public void setProject(IProject project) {
        this.project_ = project;
    }

    public String getComponentName() {
        return this.componentName_;
    }

    public void setComponentName(String componentName) {
        this.componentName_ = componentName;
    }

    public WebServicesParser getWebServicesParser() {
        return this.parser_;
    }

    private IProject getProjectFromObjectSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            IResource resource;
            block4: {
                try {
                    resource = ResourceUtils.getResourceFromSelection((Object)obj);
                    if (resource != null) break block4;
                    return null;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            IProject p = ResourceUtils.getProjectOf((IPath)resource.getFullPath());
            return p;
        }
        return null;
    }

    private String getComponentNameFromObjectSelection(IStructuredSelection selection) {
        Object obj;
        if (selection != null && selection.size() == 1 && (obj = selection.getFirstElement()) != null) {
            IResource resource;
            block5: {
                try {
                    resource = ResourceUtils.getResourceFromSelection((Object)obj);
                    if (resource != null) break block5;
                    return null;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            IVirtualComponent comp = ResourceUtils.getComponentOf((IResource)resource);
            if (comp != null) {
                return comp.getName();
            }
        }
        return null;
    }
}

