/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.core.taglib;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.jsp.core.internal.JSPCorePlugin;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.taglib.IJarRecord;
import org.eclipse.jst.jsp.core.taglib.ITLDRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibIndexListener;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecord;
import org.eclipse.jst.jsp.core.taglib.ITaglibRecordEvent;
import org.eclipse.jst.jsp.core.taglib.IURLRecord;
import org.eclipse.jst.jsp.core.taglib.ProjectDescription;

public final class TaglibIndex {
    static final boolean _debugChangeListener = false;
    static boolean _debugEvents = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/events"));
    static boolean _debugIndexCreation = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/indexcreation"));
    static final boolean _debugResolution = "true".equals(Platform.getDebugOption((String)"org.eclipse.jst.jsp.core/taglib/resolve"));
    static TaglibIndex _instance;
    private static final CRC32 checksumCalculator;
    private static final String CLEAN = "CLEAN";
    private static final String DIRTY = "DIRTY";
    static boolean ENABLED;
    static ILock LOCK;
    private ClasspathChangeListener fClasspathChangeListener = null;
    Map fProjectDescriptions;
    private ResourceChangeListener fResourceChangeListener;
    private ITaglibIndexListener[] fTaglibIndexListeners = null;
    private final String OSGI_FRAMEWORK_ID = "org.eclipse.osgi";
    static /* synthetic */ Class class$0;

    static {
        checksumCalculator = new CRC32();
        ENABLED = false;
        LOCK = Platform.getJobManager().newLock();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addTaglibIndexListener(ITaglibIndexListener listener) {
        try {
            LOCK.acquire();
            if (_instance != null) {
                _instance.internalAddTaglibIndexListener(listener);
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            LOCK.release();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        LOCK.release();
    }

    static void fireTaglibRecordEvent(ITaglibRecordEvent event) {
        ITaglibIndexListener[] listeners;
        if (_debugEvents) {
            Logger.log(1, "TaglibIndex fired event:" + event);
        }
        TLDCMDocumentManager.getSharedDocumentCache().remove(TLDCMDocumentManager.getUniqueIdentifier(event.getTaglibRecord()));
        if (_instance != null && (listeners = TaglibIndex._instance.fTaglibIndexListeners) != null) {
            int i = 0;
            while (i < listeners.length) {
                try {
                    listeners[i].indexChanged(event);
                }
                catch (Exception e) {
                    Logger.log(2, e.getMessage());
                }
                ++i;
            }
        }
    }

    public static ITaglibRecord[] getAvailableTaglibRecords(IPath fullPath) {
        ITaglibRecord[] iTaglibRecordArray;
        try {
            LOCK.acquire();
            ITaglibRecord[] records = null;
            records = _instance != null ? _instance.internalGetAvailableTaglibRecords(fullPath) : new ITaglibRecord[]{};
            iTaglibRecordArray = records;
            Object var2_3 = null;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            LOCK.release();
            throw throwable;
        }
        LOCK.release();
        return iTaglibRecordArray;
    }

    public static IPath getContextRoot(IPath path) {
        IPath iPath;
        try {
            LOCK.acquire();
            iPath = _instance.internalGetContextRoot(path);
            Object var1_2 = null;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            LOCK.release();
            throw throwable;
        }
        LOCK.release();
        return iPath;
    }

    private String getState() {
        Preferences preferences = JSPCorePlugin.getDefault().getPluginPreferences();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.taglib.TaglibIndex");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String state = preferences.getString(clazz.getName());
        return state;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeTaglibIndexListener(ITaglibIndexListener listener) {
        try {
            LOCK.acquire();
            if (_instance != null) {
                _instance.internalRemoveTaglibIndexListener(listener);
            }
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            LOCK.release();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        LOCK.release();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ITaglibRecord resolve(String basePath, String reference, boolean crossProjects) {
        ITaglibRecord result = null;
        try {
            LOCK.acquire();
            if (_instance != null) {
                result = _instance.internalResolve(basePath, reference, crossProjects);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            LOCK.release();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        LOCK.release();
        if (!_debugResolution) return result;
        if (result == null) {
            Logger.log(1, "TaglibIndex could not resolve \"" + reference + "\" from " + basePath);
            return result;
        }
        switch (result.getRecordType()) {
            case 1: {
                ITaglibRecord record = (ITLDRecord)result;
                Logger.log(1, "TaglibIndex resolved " + basePath + ":" + reference + " = " + record.getPath());
                return result;
            }
            case 2: {
                ITaglibRecord record = (IJarRecord)result;
                Logger.log(1, "TaglibIndex resolved " + basePath + ":" + reference + " = " + record.getLocation());
                return result;
            }
            case 8: {
                return result;
            }
            case 4: {
                ITaglibRecord record = (IURLRecord)result;
                Logger.log(1, "TaglibIndex resolved " + basePath + ":" + reference + " = " + record.getURL());
                return result;
            }
        }
        return result;
    }

    private void removeIndexes(boolean staleOnly) {
        String osPath = this.getTaglibIndexStateLocation().toOSString();
        File folder = new File(osPath);
        if (!folder.isDirectory()) {
            try {
                folder.mkdir();
            }
            catch (SecurityException securityException) {}
        }
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<String> indexNames = new ArrayList<String>(projects.length);
        if (staleOnly) {
            int i = 0;
            while (i < projects.length) {
                if (projects[i].isAccessible()) {
                    indexNames.add(this.computeIndexName(projects[i].getFullPath()));
                }
                ++i;
            }
        }
        if (folder.isDirectory()) {
            File[] files = folder.listFiles();
            int i = 0;
            while (files != null && i < files.length) {
                if (!indexNames.contains(files[i].getName())) {
                    files[i].delete();
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void shutdown() {
        try {
            LOCK.acquire();
            if (_instance != null) {
                _instance.stop();
            }
            _instance = null;
        }
        catch (Throwable throwable) {
            Object var0_1 = null;
            LOCK.release();
            throw throwable;
        }
        {
            Object var0_2 = null;
        }
        LOCK.release();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void startup() {
        try {
            LOCK.acquire();
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.jst.jsp.core.taglib.TaglibIndex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            ENABLED = !"false".equalsIgnoreCase(System.getProperty(clazz.getName()));
            _instance = new TaglibIndex();
        }
        catch (Throwable throwable) {
            Object var0_1 = null;
            LOCK.release();
            throw throwable;
        }
        {
            Object var0_2 = null;
        }
        LOCK.release();
    }

    private TaglibIndex() {
        if (DIRTY.equalsIgnoreCase(this.getState())) {
            Logger.log(2, "A workspace crash was detected. The previous session did not exit normally. Not using saved tag library indexes");
            this.removeIndexes(false);
        }
        this.fProjectDescriptions = new Hashtable();
        this.fResourceChangeListener = new ResourceChangeListener();
        this.fClasspathChangeListener = new ClasspathChangeListener();
        if (ENABLED) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener, 1);
            JavaCore.addElementChangedListener((IElementChangedListener)this.fClasspathChangeListener);
        }
    }

    String computeIndexLocation(IPath containerPath) {
        String fileName = this.computeIndexName(containerPath);
        if (_debugIndexCreation) {
            Logger.log(1, "-> index name for " + containerPath + " is " + fileName);
        }
        String indexLocation = this.getTaglibIndexStateLocation().append(fileName).toOSString();
        return indexLocation;
    }

    String computeIndexName(IPath containerPath) {
        checksumCalculator.reset();
        checksumCalculator.update(containerPath.toOSString().getBytes());
        String fileName = String.valueOf(Long.toString(checksumCalculator.getValue())) + ".dat";
        return fileName;
    }

    ProjectDescription createDescription(IProject project) {
        ProjectDescription description = null;
        description = (ProjectDescription)this.fProjectDescriptions.get(project);
        if (description == null) {
            if (this.fProjectDescriptions.isEmpty()) {
                this.setState(DIRTY);
            }
            description = new ProjectDescription(project, this.computeIndexLocation(project.getFullPath()));
            this.fProjectDescriptions.put(project, description);
        }
        return description;
    }

    boolean frameworkIsShuttingDown() {
        boolean shuttingDown = !Platform.isRunning() || Platform.getBundle((String)"org.eclipse.osgi").getState() == 16;
        return shuttingDown;
    }

    ProjectDescription getDescription(IProject project) {
        ProjectDescription description = null;
        description = (ProjectDescription)this.fProjectDescriptions.get(project);
        return description;
    }

    private IPath getTaglibIndexStateLocation() {
        return JSPCorePlugin.getDefault().getStateLocation().append("taglibindex/");
    }

    private void internalAddTaglibIndexListener(ITaglibIndexListener listener) {
        if (this.fTaglibIndexListeners == null) {
            this.fTaglibIndexListeners = new ITaglibIndexListener[]{listener};
        } else {
            ArrayList<ITaglibIndexListener> listeners = new ArrayList<ITaglibIndexListener>(Arrays.asList(this.fTaglibIndexListeners));
            listeners.add(listener);
            this.fTaglibIndexListeners = listeners.toArray(new ITaglibIndexListener[0]);
        }
    }

    private ITaglibRecord[] internalGetAvailableTaglibRecords(IPath path) {
        ITaglibRecord[] records = new ITaglibRecord[]{};
        if (path.segmentCount() > 0) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            ProjectDescription description = this.createDescription(project);
            List availableRecords = description.getAvailableTaglibRecords(path);
            records = availableRecords.toArray(records);
        }
        return records;
    }

    private IPath internalGetContextRoot(IPath path) {
        IFile baseResource = FileBuffers.getWorkspaceFileAtLocation((IPath)path);
        if (baseResource != null) {
            IProject project = baseResource.getProject();
            ProjectDescription description = _instance.createDescription(project);
            IPath rootPath = description.getLocalRoot(baseResource.getFullPath());
            return rootPath;
        }
        IPath root = path;
        while (root != null && !root.isRoot()) {
            root = root.removeLastSegments(1);
        }
        if (root == null) {
            root = path;
        }
        return root;
    }

    private void internalRemoveTaglibIndexListener(ITaglibIndexListener listener) {
        if (this.fTaglibIndexListeners != null) {
            ArrayList<ITaglibIndexListener> listeners = new ArrayList<ITaglibIndexListener>(Arrays.asList(this.fTaglibIndexListeners));
            listeners.remove(listener);
            this.fTaglibIndexListeners = listeners.toArray(new ITaglibIndexListener[0]);
        }
    }

    private ITaglibRecord internalResolve(String basePath, String reference, boolean crossProjects) {
        IFile[] files;
        IProject project = null;
        ITaglibRecord resolved = null;
        Path baseIPath = new Path(basePath);
        IFile baseResource = FileBuffers.getWorkspaceFileAtLocation((IPath)baseIPath);
        if (baseResource == null) {
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            if (baseResource == null && baseIPath.segmentCount() > 1) {
                baseResource = workspaceRoot.getFolder((IPath)baseIPath);
            }
            if (baseResource != null && !baseResource.exists() && baseIPath.segmentCount() > 1) {
                baseResource = workspaceRoot.getFile((IPath)baseIPath);
            }
            if (baseResource == null && baseIPath.segmentCount() == 1) {
                baseResource = workspaceRoot.getProject(baseIPath.segment(0));
            }
        }
        if (baseResource == null && (files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)baseIPath)).length > 0) {
            baseResource = files[0];
        }
        if (baseResource != null) {
            project = baseResource.getProject();
            ProjectDescription description = this.createDescription(project);
            resolved = description.resolve(basePath, reference);
        }
        return resolved;
    }

    boolean isIndexAvailable() {
        return _instance != null && ENABLED;
    }

    private void setState(String state) {
        if (!state.equals(this.getState())) {
            Preferences preferences = JSPCorePlugin.getDefault().getPluginPreferences();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jst.jsp.core.taglib.TaglibIndex");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            preferences.setValue(clazz.getName(), state);
            JSPCorePlugin.getDefault().savePluginPreferences();
        }
    }

    private void stop() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.fResourceChangeListener);
        JavaCore.removeElementChangedListener((IElementChangedListener)this.fClasspathChangeListener);
        this.removeIndexes(true);
        Iterator i = this.fProjectDescriptions.values().iterator();
        while (i.hasNext()) {
            ProjectDescription description = (ProjectDescription)i.next();
            description.saveReferences();
        }
        this.fProjectDescriptions.clear();
        this.setState(CLEAN);
    }

    class ClasspathChangeListener
    implements IElementChangedListener {
        List projectsIndexed = new ArrayList(1);

        ClasspathChangeListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void elementChanged(ElementChangedEvent event) {
            if (!TaglibIndex.this.isIndexAvailable()) {
                return;
            }
            try {
                LOCK.acquire();
                this.projectsIndexed.clear();
                this.elementChanged(event.getDelta(), true);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                LOCK.release();
                throw throwable;
            }
            {
                Object var2_4 = null;
            }
            LOCK.release();
        }

        private void elementChanged(IJavaElementDelta delta, boolean forceUpdate) {
            IJavaProject affectedProject;
            if (TaglibIndex.this.frameworkIsShuttingDown()) {
                return;
            }
            IJavaElement element = delta.getElement();
            if (element.getElementType() == 1) {
                IJavaElementDelta[] changed = delta.getAffectedChildren();
                int i = 0;
                while (i < changed.length) {
                    this.elementChanged(changed[i], forceUpdate);
                    ++i;
                }
            } else if (element.getElementType() == 2) {
                if ((delta.getFlags() & 0x20000) != 0) {
                    IJavaElement proj = element;
                    this.handleClasspathChange((IJavaProject)proj, forceUpdate);
                } else {
                    IJavaElementDelta[] deltas = delta.getAffectedChildren();
                    if (deltas.length == 0) {
                        IResource project;
                        ProjectDescription description;
                        if ((delta.getKind() == 2 || (delta.getFlags() & 0x400) != 0) && (description = (ProjectDescription)TaglibIndex.this.fProjectDescriptions.remove(project = ((IJavaProject)element).getResource())) != null) {
                            if (_debugIndexCreation) {
                                Logger.log(1, "removing index of " + description.fProject.getName());
                            }
                            description.clear();
                        }
                    } else {
                        int i = 0;
                        while (i < deltas.length) {
                            this.elementChanged(deltas[i], false);
                            ++i;
                        }
                    }
                }
            } else if (((delta.getFlags() & 0x40) != 0 || (delta.getFlags() & 0x80) != 0) && (affectedProject = element.getJavaProject()) != null) {
                ProjectDescription affectedDescription;
                File indexFile = new File(TaglibIndex.this.computeIndexLocation(affectedProject.getProject().getFullPath()));
                if (indexFile.exists() && (affectedDescription = TaglibIndex.this.createDescription(affectedProject.getProject())) != null) {
                    affectedDescription.handleElementChanged(delta);
                }
                this.projectsIndexed.add(affectedProject.getProject());
            }
        }

        private void handleClasspathChange(IJavaProject project, boolean forceUpdate) {
            if (TaglibIndex.this.frameworkIsShuttingDown()) {
                return;
            }
            try {
                IResource resource = project.getCorrespondingResource();
                if (resource.getType() == 4 && !this.projectsIndexed.contains(resource)) {
                    ProjectDescription description = null;
                    description = forceUpdate ? TaglibIndex.this.createDescription((IProject)resource) : TaglibIndex.this.getDescription((IProject)resource);
                    if (description != null && !TaglibIndex.this.frameworkIsShuttingDown()) {
                        this.projectsIndexed.add(resource);
                        description.setBuildPathIsDirty();
                    }
                }
            }
            catch (JavaModelException e) {
                Logger.logException(e);
            }
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void resourceChanged(IResourceChangeEvent event) {
            if (!TaglibIndex.this.isIndexAvailable()) {
                return;
            }
            try {
                LOCK.acquire();
                switch (event.getType()) {
                    case 2: 
                    case 4: {
                        ProjectDescription description;
                        int i;
                        IResource resource;
                        IProject[] projects;
                        IResourceDelta[] deltas;
                        try {
                            deltas = new IResourceDelta[]{event.getDelta()};
                            projects = null;
                            if (deltas != null && deltas.length > 0) {
                                resource = null;
                                resource = deltas[0] != null ? deltas[0].getResource() : event.getResource();
                                if (resource != null) {
                                    if (resource.getType() == 8) {
                                        deltas = deltas[0].getAffectedChildren();
                                        projects = new IProject[deltas.length];
                                        i = 0;
                                        while (i < deltas.length) {
                                            if (deltas[i].getResource().getType() == 4) {
                                                projects[i] = (IProject)deltas[i].getResource();
                                            }
                                            ++i;
                                        }
                                    } else {
                                        projects = new IProject[]{resource.getType() != 4 ? resource.getProject() : (IProject)resource};
                                    }
                                }
                                i = 0;
                                while (i < projects.length) {
                                    if (_debugIndexCreation) {
                                        Logger.log(1, "TaglibIndex noticed " + projects[i].getName() + " is about to be deleted/closed");
                                    }
                                    if ((description = (ProjectDescription)TaglibIndex.this.fProjectDescriptions.remove(projects[i])) != null) {
                                        if (_debugIndexCreation) {
                                            Logger.log(1, "removing index of " + description.fProject.getName());
                                        }
                                        description.clear();
                                    }
                                    ++i;
                                }
                            }
                        }
                        catch (Exception e) {
                            Logger.logException("Exception while processing resource deletion", e);
                        }
                    }
                    case 1: {
                        ProjectDescription description;
                        int i;
                        IResource resource;
                        IProject[] projects;
                        IResourceDelta[] deltas;
                        try {
                            deltas = new IResourceDelta[]{event.getDelta()};
                            projects = null;
                            if (deltas == null || deltas.length <= 0) break;
                            resource = null;
                            resource = deltas[0] != null ? deltas[0].getResource() : event.getResource();
                            if (resource != null) {
                                if (resource.getType() == 8) {
                                    deltas = deltas[0].getAffectedChildren();
                                    projects = new IProject[deltas.length];
                                    i = 0;
                                    while (i < deltas.length) {
                                        if (deltas[i].getResource().getType() == 4) {
                                            projects[i] = (IProject)deltas[i].getResource();
                                        }
                                        ++i;
                                    }
                                } else {
                                    projects = new IProject[]{resource.getType() != 4 ? resource.getProject() : (IProject)resource};
                                }
                            }
                            i = 0;
                            while (i < projects.length) {
                                try {
                                    if (deltas[i] != null && deltas[i].getKind() != 2 && projects[i].isAccessible() && (description = TaglibIndex.this.getDescription(projects[i])) != null && !TaglibIndex.this.frameworkIsShuttingDown()) {
                                        deltas[i].accept(description.getVisitor());
                                    }
                                    if (!projects[i].isAccessible() || deltas[i] != null && deltas[i].getKind() == 2) {
                                        if (_debugIndexCreation) {
                                            Logger.log(1, "TaglibIndex noticed " + projects[i].getName() + " was removed or is no longer accessible");
                                        }
                                        if ((description = (ProjectDescription)TaglibIndex.this.fProjectDescriptions.remove(projects[i])) != null) {
                                            if (_debugIndexCreation) {
                                                Logger.log(1, "removing index of " + description.fProject.getName());
                                            }
                                            description.clear();
                                        }
                                    }
                                }
                                catch (CoreException e) {
                                    Logger.logException(e);
                                }
                                ++i;
                            }
                            break;
                        }
                        catch (Exception e) {
                            Logger.logException("Exception while processing resource change", e);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                LOCK.release();
                throw throwable;
            }
            {
                Object var7_12 = null;
            }
            LOCK.release();
        }
    }
}

