/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.project.build;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.core.project.build.IPHPBuilderExtension;
import org.eclipse.php.internal.core.PHPCorePlugin;

public class PHPBuilderExtensionsRegistry {
    private static final String EXTENSION_NAME = "phpBuilderExtensions";
    private static final String BUILDER_ELEMENT = "builder";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private Map extensions = new HashMap();
    private static PHPBuilderExtensionsRegistry instance;

    private PHPBuilderExtensionsRegistry() {
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.php.core", EXTENSION_NAME);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (BUILDER_ELEMENT.equals(iConfigurationElement.getName())) {
                try {
                    this.extensions.put(iConfigurationElement.getAttribute(ID_ATTRIBUTE), iConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE));
                }
                catch (CoreException coreException) {
                    PHPCorePlugin.log(coreException);
                }
            }
            ++n;
        }
    }

    public static synchronized PHPBuilderExtensionsRegistry getInstance() {
        if (instance == null) {
            instance = new PHPBuilderExtensionsRegistry();
        }
        return instance;
    }

    public IPHPBuilderExtension[] getExtensions() {
        Collection collection = PHPBuilderExtensionsRegistry.instance.extensions.values();
        return collection.toArray(new IPHPBuilderExtension[collection.size()]);
    }

    public IPHPBuilderExtension getExtension(String string) {
        return (IPHPBuilderExtension)PHPBuilderExtensionsRegistry.instance.extensions.get(string);
    }
}

