/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.ui.IWorkbenchPart;

public class AddOperation
extends RepositoryProviderOperation {
    private Map fModesForExtensions = Collections.EMPTY_MAP;
    private Map fModesForFiles = Collections.EMPTY_MAP;

    public AddOperation(IWorkbenchPart part, ResourceMapping[] mappers) {
        super(part, mappers);
    }

    public void addModesForExtensions(Map modes) {
        this.fModesForExtensions = modes;
    }

    public void addModesForNames(Map modes) {
        this.fModesForFiles = modes;
    }

    protected void execute(CVSTeamProvider provider, IResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        if (resources.length == 0) {
            return;
        }
        this.add(provider, resources, recurse ? 2 : 1, monitor);
    }

    protected String getTaskName() {
        return CVSUIMessages.AddAction_adding;
    }

    protected String getTaskName(CVSTeamProvider provider) {
        return NLS.bind((String)CVSUIMessages.AddOperation_0, (Object[])new String[]{provider.getProject().getName()});
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void add(CVSTeamProvider provider, IResource[] resources, int depth, IProgressMonitor progress) throws CVSException {
        final TreeSet<ICVSResource> folders = new TreeSet<ICVSResource>();
        final HashMap files = new HashMap();
        CVSException[] eHolder = new CVSException[1];
        int i = 0;
        while (true) {
            if (i >= resources.length) {
                if (eHolder[0] == null) break;
                throw eHolder[0];
            }
            final IResource currentResource = resources[i];
            try {
                IContainer parent = currentResource.getParent();
                ICVSResource cvsParentResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)parent);
                while (true) {
                    if (parent.getType() == 8 || parent.getType() == 4 || this.isManaged(cvsParentResource)) {
                        final TeamException[] exception = new TeamException[1];
                        currentResource.accept(new IResourceVisitor(){

                            public boolean visit(IResource resource) {
                                try {
                                    ICVSResource mResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
                                    if (!(AddOperation.this.isManaged(mResource) || !currentResource.equals((Object)resource) && mResource.isIgnored())) {
                                        if (resource.getType() == 1) {
                                            Command.KSubstOption ksubst = AddOperation.this.getKSubstOption((IFile)resource);
                                            HashSet<ICVSResource> set = (HashSet<ICVSResource>)files.get(ksubst);
                                            if (set == null) {
                                                set = new HashSet<ICVSResource>();
                                                files.put(ksubst, set);
                                            }
                                            set.add(mResource);
                                        } else if (!AddOperation.this.isManagedProject(resource, mResource)) {
                                            folders.add(mResource);
                                        }
                                    }
                                    return true;
                                }
                                catch (CVSException e) {
                                    exception[0] = e;
                                    return false;
                                }
                            }
                        }, depth, false);
                        if (exception[0] == null) break;
                        throw exception[0];
                    }
                    folders.add(cvsParentResource);
                    parent = parent.getParent();
                    cvsParentResource = cvsParentResource.getParent();
                }
            }
            catch (CoreException e) {
                throw CVSException.wrapException((CoreException)e);
            }
            ++i;
        }
        progress.beginTask(null, files.size() * 10 + (folders.isEmpty() ? 0 : 10));
        try {
            if (!folders.isEmpty()) {
                Object e;
                Session session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                session.open(Policy.subMonitorFor(progress, 2), true);
                try {
                    IStatus status = Command.ADD.execute(session, Command.NO_GLOBAL_OPTIONS, Command.NO_LOCAL_OPTIONS, folders.toArray(new ICVSResource[folders.size()]), null, Policy.subMonitorFor(progress, 8));
                    if (status.getCode() == -10) {
                        throw new CVSServerException(status);
                    }
                }
                catch (Throwable cvsParentResource) {
                    e = null;
                    session.close();
                    throw cvsParentResource;
                }
                {
                    e = null;
                }
                session.close();
            }
            Iterator it = files.entrySet().iterator();
            while (it.hasNext()) {
                Object var14_18;
                Map.Entry entry = it.next();
                Command.KSubstOption ksubst = (Command.KSubstOption)entry.getKey();
                Set set = (Set)entry.getValue();
                Session session = new Session(this.getRemoteLocation(provider), this.getLocalRoot(provider), true);
                session.open(Policy.subMonitorFor(progress, 2), true);
                try {
                    IStatus status = Command.ADD.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{ksubst}, set.toArray(new ICVSResource[set.size()]), null, Policy.subMonitorFor(progress, 8));
                    if (status.getCode() == -10) {
                        throw new CVSServerException(status);
                    }
                }
                catch (Throwable throwable) {
                    var14_18 = null;
                    session.close();
                    throw throwable;
                }
                {
                    var14_18 = null;
                }
                session.close();
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            progress.done();
            throw throwable;
        }
        {
            Object var16_22 = null;
        }
        progress.done();
    }

    protected boolean isManagedProject(IResource resource, ICVSResource resource2) throws CVSException {
        return resource.getType() == 4 && ((ICVSFolder)resource2).isCVSFolder();
    }

    protected boolean isManaged(ICVSResource cvsResource) throws CVSException {
        return cvsResource.isManaged() && (!cvsResource.isFolder() || ((ICVSFolder)cvsResource).isCVSFolder());
    }

    protected String getErrorMessage(IStatus[] failures, int totalOperations) {
        return CVSUIMessages.AddAction_addFailed;
    }

    protected Command.KSubstOption getKSubstOption(IFile file) {
        String extension = file.getFileExtension();
        Integer mode = extension == null ? (Integer)this.fModesForFiles.get(file.getName()) : (Integer)this.fModesForExtensions.get(extension);
        if (mode != null) {
            return mode == 2 ? Command.KSUBST_BINARY : Command.KSubstOption.getDefaultTextMode();
        }
        return Command.KSubstOption.fromFile((IFile)file);
    }
}

