/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editpolicies;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartListener;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;

public abstract class SelectionEditPolicy
extends GraphicalEditPolicy {
    private EditPartListener selectionListener;
    private int state = -1;
    boolean focus;

    public void activate() {
        super.activate();
        this.addSelectionListener();
        this.setSelectedState(this.getHost().getSelected());
        this.setFocus(this.getHost().hasFocus());
    }

    protected void addSelectionListener() {
        this.selectionListener = new EditPartListener.Stub(){

            public void selectedStateChanged(EditPart part) {
                SelectionEditPolicy.this.setSelectedState(part.getSelected());
                SelectionEditPolicy.this.setFocus(part.hasFocus());
            }
        };
        this.getHost().addEditPartListener(this.selectionListener);
    }

    public void deactivate() {
        this.removeSelectionListener();
        this.setSelectedState(0);
        this.setFocus(false);
        super.deactivate();
    }

    public EditPart getTargetEditPart(Request request) {
        if ("selection".equals(request.getType())) {
            return this.getHost();
        }
        return null;
    }

    protected void hideFocus() {
    }

    protected abstract void hideSelection();

    protected void removeSelectionListener() {
        this.getHost().removeEditPartListener(this.selectionListener);
    }

    protected void setFocus(boolean value) {
        if (this.focus == value) {
            return;
        }
        this.focus = value;
        if (this.focus) {
            this.showFocus();
        } else {
            this.hideFocus();
        }
    }

    protected void setSelectedState(int type) {
        if (this.state == type) {
            return;
        }
        this.state = type;
        if (type == 2) {
            this.showPrimarySelection();
        } else if (type == 1) {
            this.showSelection();
        } else {
            this.hideSelection();
        }
    }

    protected void showFocus() {
    }

    protected void showPrimarySelection() {
        this.showSelection();
    }

    protected abstract void showSelection();
}

