/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadAndBodyOutputStream;
import org.eclipse.help.internal.webapp.servlet.IFilter;

public class InjectionFilter
implements IFilter {
    private static final String narrowBook1 = "\n<link rel=\"stylesheet\" href=\"";
    private static final String narrowBook2 = "narrow_book.css\" charset=\"ISO-8859-1\" type=\"text/css\">";
    private static final String osNarrowBook2 = "_narrow_book.css\" charset=\"ISO-8859-1\" type=\"text/css\">";
    private static final String disabledBook1 = "\n<link rel=\"stylesheet\" href=\"";
    private static final String disabledBook2 = "disabled_book.css\" charset=\"ISO-8859-1\" type=\"text/css\">";
    private static final String disabledBook3 = "\n<script language=\"JavaScript\" src=\"";
    private static final String disabledBook4 = "livehelp.js\"> </script>";

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        if (BaseHelpSystem.getMode() != 0) {
            return out;
        }
        boolean addNarrow = false;
        boolean addDisabled = false;
        boolean needsLiveHelp = false;
        String uri = req.getRequestURI();
        if (uri == null || !uri.endsWith("html") && !uri.endsWith("htm")) {
            return out;
        }
        if (UrlUtil.isBot(req)) {
            return out;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return out;
        }
        boolean enabled = HelpBasePlugin.getActivitySupport().isRoleEnabled(pathInfo);
        if ("/ntopic".equals(req.getServletPath())) {
            addNarrow = true;
        }
        if (!enabled) {
            addDisabled = true;
        }
        if (!addNarrow && !addDisabled) {
            return out;
        }
        needsLiveHelp = HelpBasePlugin.getActivitySupport().getDocumentMessageUsesLiveHelp(addNarrow);
        Path path = new Path(pathInfo);
        int upLevels = path.segmentCount() - 1;
        StringBuffer script = new StringBuffer();
        StringBuffer disabledContent = new StringBuffer();
        if (addNarrow) {
            script.append("\n<link rel=\"stylesheet\" href=\"");
            this.appendRelativePath(script, upLevels);
            script.append(narrowBook2);
            script.append("\n<link rel=\"stylesheet\" href=\"");
            this.appendRelativePath(script, upLevels);
            script.append(Platform.getOS());
            script.append(osNarrowBook2);
        }
        if (addDisabled) {
            script.append("\n<link rel=\"stylesheet\" href=\"");
            this.appendRelativePath(script, upLevels);
            script.append(disabledBook2);
            if (needsLiveHelp) {
                script.append(disabledBook3);
                this.appendRelativePath(script, upLevels, "org.eclipse.help");
                script.append(disabledBook4);
            }
            this.appendDisabled(disabledContent, upLevels, addNarrow);
        }
        try {
            return new FilterHTMLHeadAndBodyOutputStream(out, script.toString().getBytes("ASCII"), addDisabled ? disabledContent.toString() : null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return out;
        }
    }

    private void appendRelativePath(StringBuffer buff, int nsteps, String pluginId) {
        int i = 0;
        while (i < nsteps) {
            buff.append("../");
            ++i;
        }
        buff.append(String.valueOf(pluginId) + "/");
    }

    private void appendRelativePath(StringBuffer buff, int nsteps) {
        this.appendRelativePath(buff, nsteps, "PRODUCT_PLUGIN");
    }

    private void appendDisabled(StringBuffer buff, int nsteps, boolean narrow) {
        String message = HelpBasePlugin.getActivitySupport().getDocumentMessage(narrow);
        if (message == null) {
            return;
        }
        buff.append("<div id=\"help-disabledTopic\">");
        buff.append("<img src=\"");
        this.appendRelativePath(buff, nsteps, "org.eclipse.help.webapp");
        buff.append("advanced/images/e_show_all.gif\" border=\"0\" align=\"bottom\">&nbsp;");
        buff.append(message);
        buff.append("<br><hr></div>");
    }
}

