/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal;

import com.sun.mirror.apt.AnnotationProcessorFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.JarClassLoader;
import org.eclipse.jdt.apt.core.internal.JarFactoryContainer;
import org.eclipse.jdt.apt.core.internal.Messages;
import org.eclipse.jdt.apt.core.internal.util.FactoryContainer;
import org.eclipse.jdt.apt.core.internal.util.FactoryPath;
import org.eclipse.jdt.apt.core.internal.util.FactoryPathUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessorFactoryLoader {
    private static AnnotationProcessorFactoryLoader LOADER;
    private static final String JAR_EXTENSION = "jar";
    private final Map<IJavaProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes>> _project2Factories = new HashMap<IJavaProject, Map<AnnotationProcessorFactory, FactoryPath.Attributes>>();
    private final Map<IJavaProject, ClassLoader> _iterativeLoaders = new HashMap<IJavaProject, ClassLoader>();
    private final Map<IJavaProject, ClassLoader> _batchLoaders = new HashMap<IJavaProject, ClassLoader>();
    private final Map<String, Set<IJavaProject>> _container2Project = new HashMap<String, Set<IJavaProject>>();

    public static synchronized AnnotationProcessorFactoryLoader getLoader() {
        if (LOADER == null) {
            LOADER = new AnnotationProcessorFactoryLoader();
            LOADER.registerListener();
        }
        return LOADER;
    }

    private void registerListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ResourceListener(), 12);
    }

    public synchronized void resetAll() {
        this.removeAptBuildProblemMarkers(null);
        this._project2Factories.clear();
        for (ClassLoader cl : this._iterativeLoaders.values()) {
            if (!(cl instanceof JarClassLoader)) continue;
            ((JarClassLoader)cl).close();
        }
        this._iterativeLoaders.clear();
        this._container2Project.clear();
        for (ClassLoader cl : this._batchLoaders.values()) {
            if (!(cl instanceof JarClassLoader)) continue;
            ((JarClassLoader)cl).close();
        }
        this._batchLoaders.clear();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = 0;
        int n2 = iProjectArray.length;
        while (n < n2) {
            IProject proj = iProjectArray[n];
            this.verifyFactoryPath(JavaCore.create((IProject)proj));
            ++n;
        }
    }

    public synchronized void resetBatchProcessors(IJavaProject javaProj) {
        ClassLoader c;
        Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories = this._project2Factories.get(javaProj);
        if (factories == null) {
            return;
        }
        boolean batchProcsFound = false;
        for (FactoryPath.Attributes attr : factories.values()) {
            if (!attr.runInBatchMode()) continue;
            batchProcsFound = true;
            break;
        }
        if (batchProcsFound) {
            this._project2Factories.remove(javaProj);
        }
        if ((c = this._batchLoaders.remove(javaProj)) instanceof JarClassLoader) {
            ((JarClassLoader)c).close();
        }
    }

    public synchronized Map<AnnotationProcessorFactory, FactoryPath.Attributes> getFactoriesAndAttributesForProject(IJavaProject jproj) {
        Map<AnnotationProcessorFactory, FactoryPath.Attributes> factories = this._project2Factories.get(jproj);
        if (factories != null) {
            return Collections.unmodifiableMap(factories);
        }
        FactoryPath fp = FactoryPathUtil.getFactoryPath(jproj);
        Map<FactoryContainer, FactoryPath.Attributes> containers = fp.getEnabledContainers();
        factories = this.loadFactories(containers, jproj);
        this._project2Factories.put(jproj, factories);
        return Collections.unmodifiableMap(factories);
    }

    public synchronized List<AnnotationProcessorFactory> getFactoriesForProject(IJavaProject jproj) {
        Map<AnnotationProcessorFactory, FactoryPath.Attributes> factoriesAndAttrs = this.getFactoriesAndAttributesForProject(jproj);
        ArrayList factories = new ArrayList(factoriesAndAttrs.keySet());
        return Collections.unmodifiableList(factories);
    }

    private void addToResourcesMap(String key, IJavaProject jproj) {
        Set<IJavaProject> s = this._container2Project.get(key);
        if (s == null) {
            s = new HashSet<IJavaProject>();
            this._container2Project.put(key, s);
        }
        s.add(jproj);
    }

    private Map<AnnotationProcessorFactory, FactoryPath.Attributes> loadFactories(Map<FactoryContainer, FactoryPath.Attributes> containers, IJavaProject project) {
        ClassLoader iterativeClassLoader;
        LinkedHashMap<AnnotationProcessorFactory, FactoryPath.Attributes> factoriesAndAttrs = new LinkedHashMap<AnnotationProcessorFactory, FactoryPath.Attributes>(containers.size() * 4 / 3 + 1);
        this.removeAptBuildProblemMarkers(project);
        Set<FactoryContainer> badContainers = this.verifyFactoryPath(project);
        if (badContainers != null) {
            this.reportMissingFactoryContainers(badContainers, project);
            for (FactoryContainer badFC : badContainers) {
                containers.remove(badFC);
            }
        }
        if ((iterativeClassLoader = this._iterativeLoaders.get(project)) == null) {
            iterativeClassLoader = this._createIterativeClassLoader(containers);
            this._iterativeLoaders.put(project, iterativeClassLoader);
        }
        this._createBatchClassLoader(containers, project);
        ClassLoader batchClassLoader = this._batchLoaders.get(project);
        for (Map.Entry<FactoryContainer, FactoryPath.Attributes> entry : containers.entrySet()) {
            try {
                List<AnnotationProcessorFactory> factories;
                FactoryContainer fc = entry.getKey();
                FactoryPath.Attributes attr = entry.getValue();
                if (attr.runInBatchMode()) {
                    assert (batchClassLoader != null);
                    factories = this.loadFactoryClasses(fc, batchClassLoader, project);
                } else {
                    factories = this.loadFactoryClasses(fc, iterativeClassLoader, project);
                }
                for (AnnotationProcessorFactory apf : factories) {
                    factoriesAndAttrs.put(apf, entry.getValue());
                }
            }
            catch (FileNotFoundException fnfe) {
                AptPlugin.log(fnfe, String.valueOf(Messages.AnnotationProcessorFactoryLoader_jarNotFound) + fnfe.getLocalizedMessage());
            }
            catch (IOException ioe) {
                AptPlugin.log(ioe, String.valueOf(Messages.AnnotationProcessorFactoryLoader_ioError) + ioe.getLocalizedMessage());
            }
        }
        return factoriesAndAttrs;
    }

    private List<AnnotationProcessorFactory> loadFactoryClasses(FactoryContainer fc, ClassLoader classLoader, IJavaProject jproj) throws IOException {
        List<String> factoryNames = fc.getFactoryNames();
        ArrayList<AnnotationProcessorFactory> factories = new ArrayList<AnnotationProcessorFactory>(factoryNames.size());
        for (String factoryName : factoryNames) {
            AnnotationProcessorFactory factory = fc.getType() == FactoryContainer.FactoryType.PLUGIN ? FactoryPathUtil.getFactoryFromPlugin(factoryName) : this.loadFactoryFromClassLoader(factoryName, classLoader, jproj);
            if (factory == null) continue;
            factories.add(factory);
        }
        return factories;
    }

    private AnnotationProcessorFactory loadFactoryFromClassLoader(String factoryName, ClassLoader cl, IJavaProject jproj) {
        AnnotationProcessorFactory f = null;
        try {
            Class<?> c = cl.loadClass(factoryName);
            f = (AnnotationProcessorFactory)c.newInstance();
        }
        catch (Exception e) {
            AptPlugin.log(e, "Failed to load " + factoryName);
            this.reportFailureToLoadFactory(factoryName, jproj);
        }
        catch (NoClassDefFoundError ncdfe) {
            AptPlugin.log(ncdfe, "Failed to load " + factoryName);
            this.reportFailureToLoadFactory(factoryName, jproj);
        }
        return f;
    }

    private void processChanges(Set<IJavaProject> affected) {
        for (IJavaProject jproj : affected) {
            this.removeAptBuildProblemMarkers(jproj);
            this.uncacheProject(jproj);
        }
        for (IJavaProject jproj : affected) {
            Set<FactoryContainer> badContainers;
            if (!jproj.exists() || (badContainers = this.verifyFactoryPath(jproj)) == null) continue;
            this.reportMissingFactoryContainers(badContainers, jproj);
        }
    }

    private void uncacheProject(IJavaProject jproj) {
        ClassLoader cl;
        this._project2Factories.remove(jproj);
        ClassLoader c = this._iterativeLoaders.remove(jproj);
        if (c instanceof JarClassLoader) {
            ((JarClassLoader)c).close();
        }
        if ((cl = this._batchLoaders.remove(jproj)) instanceof JarClassLoader) {
            ((JarClassLoader)cl).close();
        }
        this.removeProjectFromResourceMap(jproj);
    }

    private void removeAptBuildProblemMarkers(IJavaProject jproj) {
        Set<IJavaProject> jprojects = jproj == null ? this._project2Factories.keySet() : Collections.singleton(jproj);
        try {
            for (IJavaProject jp : jprojects) {
                IProject p;
                IMarker[] markers;
                if (!jp.exists() || (markers = (p = jp.getProject()).findMarkers("org.eclipse.jdt.apt.core.buildproblem", false, 0)) == null) continue;
                IMarker[] iMarkerArray = markers;
                int n = 0;
                int n2 = iMarkerArray.length;
                while (n < n2) {
                    IMarker marker = iMarkerArray[n];
                    marker.delete();
                    ++n;
                }
            }
        }
        catch (CoreException e) {
            AptPlugin.log(e, "Unable to delete APT build problem marker");
        }
    }

    private void removeProjectFromResourceMap(IJavaProject jproj) {
        Iterator<Map.Entry<String, Set<IJavaProject>>> i = this._container2Project.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Set<IJavaProject>> e = i.next();
            Set<IJavaProject> s = e.getValue();
            s.remove(jproj);
            if (!s.isEmpty()) continue;
            i.remove();
        }
    }

    private void reportMissingFactoryContainers(Set<FactoryContainer> badContainers, IJavaProject jproj) {
        IProject project = jproj.getProject();
        for (FactoryContainer fc : badContainers) {
            try {
                String message = Messages.bind((String)Messages.AnnotationProcessorFactoryLoader_factorypath_missingLibrary, (Object[])new String[]{fc.getId(), project.getName()});
                IMarker marker = project.createMarker("org.eclipse.jdt.apt.core.buildproblem");
                marker.setAttributes(new String[]{"message", "severity", "location"}, new Object[]{message, 2, Messages.AnnotationProcessorFactoryLoader_factorypath});
            }
            catch (CoreException e) {
                AptPlugin.log(e, "Unable to create APT build problem marker on project " + project.getName());
            }
        }
    }

    private void reportFailureToLoadFactory(String factoryName, IJavaProject jproj) {
        IProject project = jproj.getProject();
        try {
            String message = Messages.bind((String)Messages.AnnotationProcessorFactoryLoader_unableToLoadFactoryClass, (Object[])new String[]{factoryName, project.getName()});
            IMarker marker = project.createMarker("org.eclipse.jdt.apt.core.buildproblem");
            marker.setAttributes(new String[]{"message", "severity", "location"}, new Object[]{message, 4, Messages.AnnotationProcessorFactoryLoader_factorypath});
        }
        catch (CoreException e) {
            AptPlugin.log(e, "Unable to create build problem marker");
        }
    }

    private Set<FactoryContainer> verifyFactoryPath(IJavaProject jproj) {
        HashSet<FactoryContainer> badContainers = null;
        FactoryPath fp = FactoryPathUtil.getFactoryPath(jproj);
        Map<FactoryContainer, FactoryPath.Attributes> containers = fp.getEnabledContainers();
        for (FactoryContainer fc : containers.keySet()) {
            if (fc instanceof JarFactoryContainer) {
                try {
                    File jarFile = ((JarFactoryContainer)fc).getJarFile();
                    if (jarFile != null) {
                        String key = jarFile.getCanonicalPath();
                        this.addToResourcesMap(key, jproj);
                    }
                }
                catch (IOException iOException) {}
            }
            if (fc.exists()) continue;
            if (badContainers == null) {
                badContainers = new HashSet<FactoryContainer>();
            }
            badContainers.add(fc);
        }
        return badContainers;
    }

    private ClassLoader _createIterativeClassLoader(Map<FactoryContainer, FactoryPath.Attributes> containers) {
        ArrayList<File> fileList = new ArrayList<File>(containers.size());
        for (Map.Entry<FactoryContainer, FactoryPath.Attributes> entry : containers.entrySet()) {
            FactoryPath.Attributes attr = entry.getValue();
            FactoryContainer fc = entry.getKey();
            if (attr.runInBatchMode() || !(fc instanceof JarFactoryContainer)) continue;
            JarFactoryContainer jfc = (JarFactoryContainer)fc;
            fileList.add(jfc.getJarFile());
        }
        ClassLoader cl = fileList.size() > 0 ? AnnotationProcessorFactoryLoader.createClassLoader(fileList, AnnotationProcessorFactoryLoader.class.getClassLoader()) : AnnotationProcessorFactoryLoader.class.getClassLoader();
        return cl;
    }

    private void _createBatchClassLoader(Map<FactoryContainer, FactoryPath.Attributes> containers, IJavaProject p) {
        ArrayList<File> fileList = new ArrayList<File>(containers.size());
        for (Map.Entry<FactoryContainer, FactoryPath.Attributes> entry : containers.entrySet()) {
            FactoryPath.Attributes attr = entry.getValue();
            FactoryContainer fc = entry.getKey();
            if (!attr.runInBatchMode() || !(fc instanceof JarFactoryContainer)) continue;
            JarFactoryContainer jfc = (JarFactoryContainer)fc;
            File f = jfc.getJarFile();
            fileList.add(f);
        }
        ClassLoader parentCL = this._iterativeLoaders.get(p);
        if (parentCL == null) {
            parentCL = AnnotationProcessorFactoryLoader.class.getClassLoader();
        }
        if (fileList.size() > 0) {
            this._batchLoaders.put(p, AnnotationProcessorFactoryLoader.createClassLoader(fileList, parentCL));
        }
    }

    private static ClassLoader createClassLoader(List<File> files, ClassLoader parentCL) {
        ArrayList<URL> urls = new ArrayList<URL>(files.size());
        int i = 0;
        while (i < files.size()) {
            try {
                urls.add(files.get(i).toURL());
            }
            catch (MalformedURLException malformedURLException) {}
            ++i;
        }
        URL[] urlArray = urls.toArray(new URL[urls.size()]);
        return new URLClassLoader(urlArray, parentCL);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FactoryPathDeltaVisitor
    implements IResourceDeltaVisitor {
        private Set<IJavaProject> _affected = null;

        private FactoryPathDeltaVisitor() {
        }

        private void addAffected(Set<IJavaProject> projects) {
            if (this._affected == null) {
                this._affected = new HashSet<IJavaProject>(5);
            }
            this._affected.addAll(projects);
        }

        public Set<IJavaProject> getAffectedProjects() {
            return this._affected;
        }

        public boolean visit(IResourceDelta delta) {
            switch (delta.getKind()) {
                default: {
                    return true;
                }
                case 1: 
                case 2: 
                case 4: 
            }
            IResource res = delta.getResource();
            if (res == null) {
                return true;
            }
            IProject proj = res.getProject();
            if (FactoryPathUtil.isFactoryPathFile(res)) {
                this.addAffected(Collections.singleton(JavaCore.create((IProject)proj)));
                return true;
            }
            if (res.getType() != 1) {
                return true;
            }
            IPath relativePath = res.getFullPath();
            String ext = relativePath.getFileExtension();
            try {
                if (AnnotationProcessorFactoryLoader.JAR_EXTENSION.equals(ext)) {
                    IPath absolutePath = res.getLocation();
                    if (absolutePath == null) {
                        for (Map.Entry entry : AnnotationProcessorFactoryLoader.this._container2Project.entrySet()) {
                            Path jarPath = new Path((String)entry.getKey());
                            if (!relativePath.lastSegment().equals(jarPath.lastSegment())) continue;
                            this.addAffected((Set)entry.getValue());
                        }
                    } else {
                        String key = null;
                        key = absolutePath.toFile().getCanonicalPath();
                        Set projects = (Set)AnnotationProcessorFactoryLoader.this._container2Project.get(key);
                        if (projects != null) {
                            this.addAffected(projects);
                        }
                    }
                }
            }
            catch (Exception e) {
                AptPlugin.log(e, "Couldn't determine whether any factory paths were affected by change to resource " + res.getName());
            }
            return true;
        }
    }

    private class ResourceListener
    implements IResourceChangeListener {
        private ResourceListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            AnnotationProcessorFactoryLoader annotationProcessorFactoryLoader = AnnotationProcessorFactoryLoader.this;
            synchronized (annotationProcessorFactoryLoader) {
                switch (event.getType()) {
                    case 4: {
                        IJavaProject jproj;
                        IResource project = event.getResource();
                        if (project == null || !(project instanceof IProject) || (jproj = JavaCore.create((IProject)((IProject)project))) == null) break;
                        AnnotationProcessorFactoryLoader.this.uncacheProject(jproj);
                        break;
                    }
                    case 8: {
                        IResourceDelta rootDelta = event.getDelta();
                        FactoryPathDeltaVisitor visitor = new FactoryPathDeltaVisitor();
                        try {
                            rootDelta.accept((IResourceDeltaVisitor)visitor);
                        }
                        catch (CoreException e) {
                            AptPlugin.log(e, "Unable to determine whether resource change affects annotation processor factory path");
                        }
                        Set<IJavaProject> affected = visitor.getAffectedProjects();
                        if (affected == null) break;
                        AnnotationProcessorFactoryLoader.this.processChanges(affected);
                    }
                }
            }
        }
    }
}

