/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.util.Arrays;
import org.eclipse.core.runtime.Platform;

public abstract class OS {
    private static final String INSTALLED_PLATFORM = Platform.getOS();
    public static final char[] INVALID_RESOURCE_CHARACTERS;
    public static final String[] INVALID_RESOURCE_NAMES;

    static {
        if (INSTALLED_PLATFORM.equals("win32")) {
            INVALID_RESOURCE_CHARACTERS = new char[]{'\\', '/', ':', '*', '?', '\"', '<', '>', '|'};
            INVALID_RESOURCE_NAMES = new String[]{"aux", "clock$", "com1", "com2", "com3", "com4", "com5", "com6", "com7", "com8", "com9", "con", "lpt1", "lpt2", "lpt3", "lpt4", "lpt5", "lpt6", "lpt7", "lpt8", "lpt9", "nul", "prn"};
            Arrays.sort(INVALID_RESOURCE_NAMES);
        } else {
            char[] cArray = new char[2];
            cArray[0] = 47;
            INVALID_RESOURCE_CHARACTERS = cArray;
            INVALID_RESOURCE_NAMES = new String[0];
        }
    }

    public static boolean isNameValid(String name) {
        if (name.equals(".") || name.equals("..")) {
            return false;
        }
        if (INSTALLED_PLATFORM.equals("win32")) {
            int length = name.length();
            if (length == 0) {
                return false;
            }
            char lastChar = name.charAt(length - 1);
            if (lastChar == '.') {
                return false;
            }
            if (Character.isWhitespace(lastChar)) {
                return false;
            }
            int dot = name.indexOf(46);
            String string = name = dot == -1 ? name : name.substring(0, dot);
        }
        return Arrays.binarySearch(INVALID_RESOURCE_NAMES, name.toLowerCase()) < 0;
    }
}

