/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.basic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.MessageReference;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11AddPartAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetExistingMessageAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.actions.W11SetNewMessageAction;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11Operation;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddFaultParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddInputParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11AddOutputParameterCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11DeleteCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11ReorderParametersCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddFaultAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDAddOperationAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDDeleteAction;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObjectListener;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IMessageReference;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IOperation;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IParameter;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;
import org.eclipse.wst.wsdl.ui.internal.visitor.WSDLVisitorForParameters;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ProductCustomizationProvider;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDTypeDefinition;

public class W11MessageReference
extends WSDLBaseAdapter
implements IMessageReference,
IASDObjectListener {
    protected int messageKind = -1;
    protected List parameters = null;
    protected List otherThingsToListenTo = null;
    private String previewString = "";

    public W11MessageReference(int messageKind) {
        this.messageKind = messageKind;
    }

    public IOperation getOwnerOperation() {
        return (IOperation)((Object)this.owner);
    }

    public String getPreview() {
        return "  (" + this.previewString + ")  ";
    }

    private String getMessageString(String key, Object[] args) {
        ProductCustomizationProvider productCustomizationProvider;
        String newString;
        String string = null;
        ProductCustomizationProvider object = WSDLEditorPlugin.getInstance().getProductCustomizationProvider();
        if (object instanceof ProductCustomizationProvider && (newString = (productCustomizationProvider = object).getProductString(key, args)) != null) {
            string = newString;
        }
        return string;
    }

    private String getInvalidElementReferenceString() {
        String string = null;
        Object[] args = new String[]{"element"};
        string = this.getMessageString("_UI_LABEL_INVALID_ARG_REFERENCE", args);
        if (string == null) {
            string = "Invalid element reference";
        }
        return string;
    }

    public MessageReference getMessageReference() {
        return (MessageReference)this.target;
    }

    protected void computeMessageKind() {
        if (this.getMessageReference() instanceof Input) {
            this.messageKind = 1;
        } else if (this.getMessageReference() instanceof Output) {
            this.messageKind = 2;
        } else if (this.getMessageReference() instanceof Fault) {
            this.messageKind = 3;
        }
    }

    public int getKind() {
        if (this.messageKind == -1) {
            this.computeMessageKind();
        }
        return this.messageKind;
    }

    public String getName() {
        MessageReference messageRef = this.getMessageReference();
        if (messageRef.getName() != null) {
            return messageRef.getName();
        }
        return "";
    }

    public List getParameters() {
        Object[] args;
        ArrayList parameters = new ArrayList();
        EList parts = new ArrayList();
        MessageReference messageRef = this.getMessageReference();
        if (messageRef != null && messageRef.getEMessage() != null && messageRef.getEMessage().getEParts() != null) {
            parts = messageRef.getEMessage().getEParts();
        }
        this.populateAdapterList((List)parts, parameters);
        this.otherThingsToListenTo = new ArrayList();
        WSDLVisitorForParameters visitorForParameters = new WSDLVisitorForParameters();
        visitorForParameters.visitMessageReference(messageRef);
        this.populateAdapterList(visitorForParameters.concreteComponents, this.otherThingsToListenTo);
        this.populateAdapterList(visitorForParameters.thingsToListenTo, this.otherThingsToListenTo);
        Iterator i = this.otherThingsToListenTo.iterator();
        while (i.hasNext()) {
            Adapter adapter = (Adapter)i.next();
            if (!(adapter instanceof IASDObject)) continue;
            IASDObject asdObject = (IASDObject)adapter;
            asdObject.registerListener(this);
        }
        if (messageRef == null || messageRef.getEMessage() == null) {
            args = new String[]{"message"};
            this.previewString = this.getMessageString("_UI_LABEL_INVALID_ARG_REFERENCE", args);
            if (this.previewString == null) {
                this.previewString = "Invalid message reference";
            }
        } else if (parts.size() <= 0) {
            args = new String[]{"part"};
            this.previewString = this.getMessageString("_UI_LABEL_INVALID_ARG_REFERENCE", args);
            if (this.previewString == null) {
                this.previewString = "Invalid part reference";
            }
        }
        return parameters;
    }

    public void propertyChanged(Object object, String property) {
        if (object instanceof Adapter) {
            ((Adapter)object).getTarget();
        }
        this.clearParameters();
        this.notifyListeners(this, null);
    }

    protected void clearParameters() {
        if (this.otherThingsToListenTo != null) {
            Iterator i = this.otherThingsToListenTo.iterator();
            while (i.hasNext()) {
                Adapter adapter = (Adapter)i.next();
                if (!(adapter instanceof IASDObject)) continue;
                IASDObject asdObject = (IASDObject)adapter;
                asdObject.unregisterListener(this);
            }
        }
        this.parameters = null;
        this.otherThingsToListenTo = null;
    }

    public void notifyChanged(Notification msg) {
        this.clearParameters();
        super.notifyChanged(msg);
    }

    public String[] getActions(Object object) {
        ArrayList<String> actions = new ArrayList<String>();
        actions.add(ASDAddOperationAction.ID);
        actions.addAll(((W11Operation)this.getOwnerOperation()).getValidInputOutpuActions());
        actions.add(ASDAddFaultAction.ID);
        actions.add(W11AddPartAction.ID);
        actions.add(ASDDeleteAction.ID);
        actions.add("SUBMENU_START_ID: " + Messages._UI_ACTION_SET_MESSAGE);
        actions.add(W11SetNewMessageAction.ID);
        actions.add(W11SetExistingMessageAction.ID);
        actions.add("SUBMENU_END_ID: ");
        String[] actionIDs = new String[actions.size()];
        int index = 0;
        while (index < actions.size()) {
            actionIDs[index] = (String)actions.get(index);
            ++index;
        }
        return actionIDs;
    }

    public Command getReorderParametersCommand(IParameter leftSibling, IParameter rightSibling, IParameter movingParameter) {
        return new W11ReorderParametersCommand(leftSibling, rightSibling, movingParameter);
    }

    public Command getDeleteCommand() {
        return new W11DeleteCommand(this);
    }

    public Command getAddParamterCommand() {
        W11TopLevelElementCommand command = null;
        Operation operation = (Operation)this.getMessageReference().eContainer();
        command = this.getKind() == 1 ? new W11AddInputParameterCommand(operation) : (this.getKind() == 2 ? new W11AddOutputParameterCommand(operation) : new W11AddFaultParameterCommand(operation, (Fault)this.getMessageReference()));
        return command;
    }

    public Image getImage() {
        if (this.getKind() == 1) {
            return WSDLEditorPlugin.getInstance().getImage("icons/input_obj.gif");
        }
        if (this.getKind() == 2) {
            return WSDLEditorPlugin.getInstance().getImage("icons/output_obj.gif");
        }
        if (this.getKind() == 3) {
            return WSDLEditorPlugin.getInstance().getImage("icons/fault_obj.gif");
        }
        return null;
    }

    public String getText() {
        if (this.getKind() == 1) {
            return "input";
        }
        if (this.getKind() == 2) {
            return "output";
        }
        if (this.getKind() == 3) {
            return this.getName();
        }
        return "NoName";
    }

    public List getParameters2() {
        Object[] args;
        MessageReference messageRef;
        if (this.parameters == null) {
            this.parameters = new ArrayList();
            this.otherThingsToListenTo = new ArrayList();
            WSDLVisitorForParameters visitorForParameters = new WSDLVisitorForParameters();
            visitorForParameters.visitMessageReference(this.getMessageReference());
            this.populateAdapterList(visitorForParameters.concreteComponents, this.parameters);
            this.populateAdapterList(visitorForParameters.thingsToListenTo, this.otherThingsToListenTo);
            Iterator i = this.otherThingsToListenTo.iterator();
            while (i.hasNext()) {
                Adapter adapter = (Adapter)i.next();
                if (!(adapter instanceof IASDObject)) continue;
                IASDObject asdObject = (IASDObject)adapter;
                asdObject.registerListener(this);
            }
        }
        if ((messageRef = this.getMessageReference()) == null || messageRef.getEMessage() == null) {
            args = new String[]{"message"};
            this.previewString = this.getMessageString("_UI_LABEL_INVALID_ARG_REFERENCE", args);
            if (this.previewString == null) {
                this.previewString = "Invalid message reference";
            }
        } else if (messageRef.getEMessage().getEParts().size() <= 0) {
            args = new String[]{"part"};
            this.previewString = this.getMessageString("_UI_LABEL_INVALID_ARG_REFERENCE", args);
            if (this.previewString == null) {
                this.previewString = "Invalid part reference";
            }
        } else {
            Part part = (Part)messageRef.getEMessage().getEParts().get(0);
            XSDElementDeclaration xsdElement = part.getElementDeclaration();
            if (xsdElement == null) {
                this.previewString = this.getInvalidElementReferenceString();
            } else {
                XSDTypeDefinition xsdType = xsdElement.getAnonymousTypeDefinition();
                if (xsdType == null) {
                    this.previewString = this.getInvalidElementReferenceString();
                } else {
                    EList contents = xsdType.eContents();
                    if (contents.size() > 0 && contents.get(0) instanceof XSDParticle) {
                        XSDParticle particle = (XSDParticle)contents.get(0);
                        EList particleContents = particle.eContents();
                        if (particleContents.size() > 0 && particleContents.get(0) instanceof XSDModelGroup) {
                            XSDModelGroup modelGroup = (XSDModelGroup)particleContents.get(0);
                            EList modelContents = modelGroup.eContents();
                            if (modelContents.size() > 0 && modelContents.get(0) instanceof XSDParticle) {
                                XSDParticle innerParticle = (XSDParticle)modelContents.get(0);
                                EList innerContents = innerParticle.eContents();
                                if (innerContents.size() <= 0 || !(innerContents.get(0) instanceof XSDElementDeclaration)) {
                                    this.previewString = this.getInvalidElementReferenceString();
                                }
                            } else {
                                this.previewString = this.getInvalidElementReferenceString();
                            }
                        } else {
                            this.previewString = this.getInvalidElementReferenceString();
                        }
                    } else {
                        this.previewString = this.getInvalidElementReferenceString();
                    }
                }
            }
        }
        return this.parameters;
    }

    public ITreeElement[] getChildren() {
        return ITreeElement.EMPTY_LIST;
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public ITreeElement getParent() {
        return null;
    }
}

