/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.core.phpModel.phpElementData.PHPCodeData;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.ReorgMoveAction;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class MoveAction
extends SelectionDispatchAction {
    private PHPStructuredEditor fEditor;
    private ReorgMoveAction fReorgMoveAction;

    public MoveAction(IWorkbenchSite iWorkbenchSite) {
        super(iWorkbenchSite);
        this.setText(PHPUIMessages.MoveAction_text);
        this.fReorgMoveAction = new ReorgMoveAction(iWorkbenchSite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.php.ui.move_action");
    }

    public MoveAction(PHPStructuredEditor pHPStructuredEditor) {
        super((IWorkbenchSite)pHPStructuredEditor.getEditorSite());
        this.fEditor = pHPStructuredEditor;
        this.setText(PHPUIMessages.MoveAction_text);
        this.fReorgMoveAction = new ReorgMoveAction((IWorkbenchSite)pHPStructuredEditor.getEditorSite());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.php.ui.move_action");
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.fReorgMoveAction.selectionChanged(selectionChangedEvent);
        this.setEnabled(this.computeEnableState());
    }

    public void run(IStructuredSelection iStructuredSelection) {
        if (this.fReorgMoveAction.isEnabled()) {
            this.fReorgMoveAction.run();
        }
    }

    public void run(ITextSelection iTextSelection) {
        if (!ActionUtils.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        if (this.tryReorgMove(iTextSelection)) {
            return;
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)PHPUIMessages.MoveAction_Move, (String)PHPUIMessages.MoveAction_select);
    }

    private boolean tryReorgMove(ITextSelection iTextSelection) {
        PHPCodeData pHPCodeData = SelectionConverter.getElementAtOffset(this.fEditor);
        if (pHPCodeData == null) {
            return false;
        }
        StructuredSelection structuredSelection = new StructuredSelection((Object)pHPCodeData);
        this.fReorgMoveAction.selectionChanged((IStructuredSelection)structuredSelection);
        if (!this.fReorgMoveAction.isEnabled()) {
            return false;
        }
        this.fReorgMoveAction.run((IStructuredSelection)structuredSelection);
        return true;
    }

    public void update(ISelection iSelection) {
        this.fReorgMoveAction.update(iSelection);
        this.setEnabled(this.computeEnableState());
    }

    private boolean computeEnableState() {
        return this.fReorgMoveAction.isEnabled();
    }
}

