/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.autoEdit;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.format.CurlyCloseIndentationStrategy;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class CurlyCloseAutoEditStrategy
extends CurlyCloseIndentationStrategy
implements IAutoEditStrategy {
    private StringBuffer helpBuffer = new StringBuffer();

    public void customizeDocumentCommand(IDocument iDocument, DocumentCommand documentCommand) {
        if (documentCommand.text != null && documentCommand.text.endsWith("}")) {
            this.autoIndentAfterCurlyClose((IStructuredDocument)iDocument, documentCommand);
        }
    }

    private void autoIndentAfterCurlyClose(IStructuredDocument iStructuredDocument, DocumentCommand documentCommand) {
        this.helpBuffer.setLength(0);
        int n = documentCommand.offset;
        int n2 = iStructuredDocument.getLineOfOffset(n);
        try {
            IRegion iRegion = iStructuredDocument.getLineInformation(n2);
            if (CurlyCloseAutoEditStrategy.isBlanks(iStructuredDocument, iRegion.getOffset(), documentCommand.offset)) {
                this.placeMatchingBlanks(iStructuredDocument, this.helpBuffer, n2, n);
                documentCommand.offset = iRegion.getOffset();
                documentCommand.length += n - iRegion.getOffset();
            }
        }
        catch (BadLocationException badLocationException) {
            Logger.logException(badLocationException);
        }
        documentCommand.text = String.valueOf(this.helpBuffer.toString()) + documentCommand.text;
    }

    protected static boolean isBlanks(IStructuredDocument iStructuredDocument, int n, int n2) throws BadLocationException {
        return iStructuredDocument.get(n, n2 - n).trim().length() == 0;
    }
}

