/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.php.internal.core.documentModel.provisional.contenttype.ContentTypeIdForPHP;
import org.eclipse.php.internal.ui.editor.highlighter.LineStyleProviderForPhp;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;

public class PHPSourceViewer
extends Composite {
    private Dictionary fContextStyleMap = null;
    private Color fDefaultBackground = this.getDisplay().getSystemColor(25);
    private Color fDefaultForeground = this.getDisplay().getSystemColor(24);
    private String fInput = "";
    private IStructuredDocumentRegion fNodes = null;
    private RegionParser fParser = null;
    private StyledText fText = null;
    private LineStyleProviderForPhp styleProvider;

    public PHPSourceViewer(Composite composite, int n) {
        super(composite, n);
        FillLayout fillLayout = new FillLayout();
        this.setLayout((Layout)fillLayout);
        this.createControls(this);
        this.setupViewer();
    }

    public void createControls(Composite composite) {
        this.fText = new StyledText(composite, 2818);
        this.fText.getContent().addTextChangeListener(new TextChangeListener(){
            DocumentReader docReader;
            Document document;

            public void textChanging(TextChangingEvent textChangingEvent) {
            }

            public void textChanged(TextChangedEvent textChangedEvent) {
                if (this.docReader == null) {
                    this.document = new Document();
                    this.docReader = new DocumentReader();
                }
                PHPSourceViewer.this.fInput = PHPSourceViewer.this.getText();
                this.document.set(PHPSourceViewer.this.fInput);
                this.docReader.reset((IDocument)this.document, 0);
                PHPSourceViewer.this.getParser().reset((Reader)this.docReader);
                PHPSourceViewer.this.fNodes = PHPSourceViewer.this.getParser().getDocumentRegions();
                PHPSourceViewer.this.applyStyles();
            }

            public void textSet(TextChangedEvent textChangedEvent) {
            }
        });
        this.fText.setBackground(this.fDefaultBackground);
        this.fText.setFont(JFaceResources.getTextFont());
        this.setAccessible((Control)this.fText, SSEUIMessages.Sample_text__UI_);
    }

    public void setEditable(boolean bl) {
        this.fText.setEditable(bl);
    }

    public Dictionary getContextStyleMap() {
        return this.fContextStyleMap;
    }

    public Color getDefaultBackground() {
        return this.fDefaultBackground;
    }

    public Color getDefaultForeground() {
        return this.fDefaultForeground;
    }

    public Font getFont() {
        return this.fText.getFont();
    }

    public RegionParser getParser() {
        return this.fParser;
    }

    public String getText() {
        return this.fText.getText();
    }

    public void refresh() {
        this.fText.setRedraw(false);
        this.fText.setFont(JFaceResources.getTextFont());
        this.applyStyles();
        this.fText.setRedraw(true);
    }

    public void releasePickerResources() {
    }

    private void setAccessible(Control control, String string) {
        if (control == null) {
            return;
        }
        final String string2 = string;
        control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                if (accessibleEvent.childID == -1) {
                    accessibleEvent.result = string2;
                }
            }
        });
    }

    public void setContextStyleMap(Dictionary dictionary) {
        this.fContextStyleMap = dictionary;
    }

    public void setDefaultBackground(Color color) {
        this.fDefaultBackground = color;
    }

    public void setDefaultForeground(Color color) {
        this.fDefaultForeground = color;
    }

    public void setFont(Font font) {
        this.fText.setFont(font);
        this.fText.redraw();
    }

    public void setParser(RegionParser regionParser) {
        this.fParser = regionParser;
    }

    public TextAttribute getAttribute(String string) {
        TextAttribute textAttribute = new TextAttribute(this.getDefaultForeground(), this.getDefaultBackground(), 0);
        if (string != null && this.styleProvider != null) {
            textAttribute = this.styleProvider.getTextAttributeForColor(string);
        }
        return textAttribute;
    }

    public void applyStyles() {
        if (this.fText == null || this.fText.isDisposed() || this.fInput == null || this.fInput.length() == 0) {
            return;
        }
        IStructuredDocumentRegion iStructuredDocumentRegion = this.fNodes;
        LineStyleProviderForPhp lineStyleProviderForPhp = new LineStyleProviderForPhp();
        ArrayList arrayList = new ArrayList();
        lineStyleProviderForPhp.prepareTextRegions(iStructuredDocumentRegion, 0, this.fNodes.getEnd(), arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            StyleRange styleRange = (StyleRange)iterator.next();
            this.fText.setStyleRange(styleRange);
        }
    }

    public void setText(String string) {
        this.fInput = string;
        DocumentReader documentReader = new DocumentReader((IDocument)new Document(this.fInput));
        this.getParser().reset((Reader)documentReader);
        this.fNodes = this.getParser().getDocumentRegions();
        if (this.fText != null) {
            this.fText.setText(string);
        }
        this.applyStyles();
    }

    public void setupViewer() {
        IModelManager iModelManager = StructuredModelManager.getModelManager();
        this.setParser(iModelManager.createStructuredDocumentFor(ContentTypeIdForPHP.ContentTypeID_PHP).getParser());
        this.styleProvider = new LineStyleProviderForPhp();
        Hashtable hashtable = new Hashtable(this.styleProvider.getColorTypesMap());
        this.setContextStyleMap(hashtable);
    }

    public StyledText getTextWidget() {
        return this.fText;
    }
}

