/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.php.internal.core.phpModel.phpElementData.CodeData;
import org.eclipse.php.internal.ui.search.IPHPSearchScope;

public class PHPSearchScope
implements IPHPSearchScope {
    protected static final IPath[] EMPTY_PATHS = new IPath[0];
    protected HashSet fullProjects;
    protected HashSet partialProjects;
    protected HashMap paths;
    protected int searchFor;
    static /* synthetic */ Class class$0;

    public PHPSearchScope(int n) {
        this.searchFor = n;
        this.fullProjects = new HashSet(5);
        this.partialProjects = new HashSet(5);
        this.paths = new HashMap();
    }

    public IProject[] getAllEnclosingProjects() {
        IProject[] iProjectArray = new IProject[this.fullProjects.size()];
        IProject[] iProjectArray2 = new IProject[this.partialProjects.size()];
        this.fullProjects.toArray(iProjectArray);
        this.partialProjects.toArray(iProjectArray2);
        IProject[] iProjectArray3 = new IProject[iProjectArray.length + iProjectArray2.length];
        System.arraycopy(iProjectArray, 0, iProjectArray3, 0, iProjectArray.length);
        System.arraycopy(iProjectArray2, 0, iProjectArray3, iProjectArray.length, iProjectArray2.length);
        return iProjectArray3;
    }

    public IProject[] getFullScopeProjects() {
        IProject[] iProjectArray = new IProject[this.fullProjects.size()];
        this.fullProjects.toArray(iProjectArray);
        return iProjectArray;
    }

    public IProject[] getPartialScopeProjects() {
        IProject[] iProjectArray = new IProject[this.partialProjects.size()];
        this.partialProjects.toArray(iProjectArray);
        return iProjectArray;
    }

    public IPath[] getPartialResourcesPaths(IProject iProject) {
        List list = (List)this.paths.get(iProject);
        if (list == null) {
            return EMPTY_PATHS;
        }
        IPath[] iPathArray = new IPath[list.size()];
        list.toArray(iPathArray);
        return iPathArray;
    }

    public boolean isInScope(CodeData codeData) {
        CodeData codeData2 = codeData;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IFile iFile = (IFile)codeData2.getAdapter((Class)clazz);
        Iterator iterator = this.fullProjects.iterator();
        while (iterator.hasNext()) {
            if (!((IProject)iterator.next()).exists(iFile.getFullPath())) continue;
            return true;
        }
        Iterator iterator2 = this.paths.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry = iterator2.next();
            List list = (List)entry.getValue();
            if (!list.contains(iFile.getFullPath())) continue;
            return true;
        }
        return false;
    }

    public void add(IProject iProject) {
        if (iProject.isAccessible()) {
            this.fullProjects.add(iProject);
        }
        this.partialProjects.remove(iProject);
        this.paths.remove(iProject);
    }

    public void add(IResource iResource) {
        ArrayList<IPath> arrayList;
        IProject iProject = iResource.getProject();
        if (!this.fullProjects.contains(iProject)) {
            this.partialProjects.add(iProject);
        }
        if ((arrayList = (ArrayList<IPath>)this.paths.get(iProject)) == null) {
            arrayList = new ArrayList<IPath>(5);
            this.paths.put(iProject, arrayList);
        }
        arrayList.add(iResource.getFullPath());
    }

    public int getSearchFor() {
        return this.searchFor;
    }
}

