/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.util;

import java.text.MessageFormat;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.swt.custom.BusyIndicator;
import org.osgi.framework.Bundle;

public class CoreUtility {
    public static void createFolder(IFolder iFolder, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws CoreException {
        if (!iFolder.exists()) {
            IContainer iContainer = iFolder.getParent();
            if (iContainer instanceof IFolder) {
                CoreUtility.createFolder((IFolder)iContainer, bl, bl2, null);
            }
            iFolder.create(bl, bl2, iProgressMonitor);
        }
    }

    public static Object createExtension(final IConfigurationElement iConfigurationElement, final String string) throws CoreException {
        String string2 = iConfigurationElement.getNamespaceIdentifier();
        Bundle bundle = Platform.getBundle((String)string2);
        if (bundle != null && bundle.getState() == 32) {
            return iConfigurationElement.createExecutableExtension(string);
        }
        final Object[] objectArray = new Object[1];
        final CoreException[] coreExceptionArray = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    objectArray[0] = iConfigurationElement.createExecutableExtension(string);
                }
                catch (CoreException coreException) {
                    coreExceptionArray[0] = coreException;
                }
            }
        });
        if (coreExceptionArray[0] != null) {
            throw coreExceptionArray[0];
        }
        return objectArray[0];
    }

    public static void startBuildInBackground(IProject iProject) {
        CoreUtility.getBuildJob(iProject).schedule();
    }

    public static Job getBuildJob(IProject iProject) {
        BuildJob buildJob = new BuildJob(PHPUIMessages.CoreUtility_job_title, iProject);
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        return buildJob;
    }

    public static boolean enableAutoBuild(boolean bl) throws CoreException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription iWorkspaceDescription = iWorkspace.getDescription();
        boolean bl2 = iWorkspaceDescription.isAutoBuilding();
        if (bl2 != bl) {
            iWorkspaceDescription.setAutoBuilding(bl);
            iWorkspace.setDescription(iWorkspaceDescription);
        }
        return bl2;
    }

    private static final class BuildJob
    extends Job {
        private final IProject fProject;

        private BuildJob(String string, IProject iProject) {
            super(string);
            this.fProject = iProject;
        }

        public boolean isCoveredBy(BuildJob buildJob) {
            if (buildJob.fProject == null) {
                return true;
            }
            return this.fProject != null && this.fProject.equals((Object)this.fProject);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor iProgressMonitor) {
            Job job;
            Job[] jobArray;
            Class<?> clazz = ((Object)((Object)this)).getClass();
            synchronized (clazz) {
                if (iProgressMonitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                jobArray = Platform.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                int n = 0;
                while (n < jobArray.length) {
                    BuildJob buildJob;
                    job = jobArray[n];
                    if (job != this && job instanceof BuildJob && (buildJob = (BuildJob)job).isCoveredBy(this)) {
                        job.cancel();
                    }
                    ++n;
                }
            }
            try {
                try {
                    if (this.fProject != null) {
                        iProgressMonitor.beginTask(MessageFormat.format(PHPUIMessages.CoreUtility_buildproject_taskname, this.fProject.getName()), 2);
                        this.fProject.build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                        PHPUiPlugin.getWorkspace().build(10, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    } else {
                        iProgressMonitor.beginTask(PHPUIMessages.CoreUtility_buildall_taskname, 2);
                        PHPUiPlugin.getWorkspace().build(6, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 2));
                    }
                }
                catch (CoreException coreException) {
                    job = coreException.getStatus();
                    jobArray = null;
                    iProgressMonitor.done();
                    return job;
                }
                catch (OperationCanceledException operationCanceledException) {
                    job = Status.CANCEL_STATUS;
                    jobArray = null;
                    iProgressMonitor.done();
                    return job;
                }
            }
            catch (Throwable throwable) {
                jobArray = null;
                iProgressMonitor.done();
                throw throwable;
            }
            {
                jobArray = null;
            }
            iProgressMonitor.done();
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object object) {
            return ResourcesPlugin.FAMILY_MANUAL_BUILD == object;
        }
    }
}

