/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTableComposite;
import org.eclipse.wst.server.ui.internal.viewers.LockedTableViewer;
import org.eclipse.wst.server.ui.internal.viewers.RuntimeContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.RuntimeTableLabelProvider;

public class RuntimeComposite
extends AbstractTableComposite {
    protected IRuntime selection;
    protected IRuntime defaultRuntime;
    protected RuntimeSelectionListener listener;

    public RuntimeComposite(Composite parent, int style, RuntimeSelectionListener listener2) {
        super(parent, style);
        this.listener = listener2;
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        this.table.setHeaderVisible(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(60, 160, true));
        TableColumn col = new TableColumn(this.table, 0);
        col.setText(Messages.columnName);
        col.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeComposite.this.tableViewer.setSorter((ViewerSorter)new RuntimeViewerSorter(true));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(45, 125, true));
        col = new TableColumn(this.table, 0);
        col.setText(Messages.columnType);
        col.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RuntimeComposite.this.tableViewer.setSorter((ViewerSorter)new RuntimeViewerSorter(false));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new RuntimeContentProvider());
        RuntimeTableLabelProvider labelProvider = new RuntimeTableLabelProvider();
        labelProvider.addListener(new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                Object[] obj = event.getElements();
                if (obj == null) {
                    RuntimeComposite.this.tableViewer.refresh(true);
                } else {
                    int size = obj.length;
                    int i = 0;
                    while (i < size) {
                        RuntimeComposite.this.tableViewer.refresh(obj[i], true);
                        ++i;
                    }
                }
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.tableViewer.setInput((Object)"root");
        this.tableViewer.setColumnProperties(new String[]{"name", "type"});
        this.tableViewer.setSorter((ViewerSorter)new RuntimeViewerSorter(true));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = RuntimeComposite.this.getSelection(event.getSelection());
                RuntimeComposite.this.selection = obj instanceof IRuntime ? (IRuntime)obj : null;
                RuntimeComposite.this.listener.runtimeSelected(RuntimeComposite.this.selection);
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == 'l') {
                    try {
                        IRuntime runtime = RuntimeComposite.this.getSelectedRuntime();
                        IRuntimeWorkingCopy wc = runtime.createWorkingCopy();
                        wc.setReadOnly(!runtime.isReadOnly());
                        wc.save(false, null);
                        RuntimeComposite.this.refresh(runtime);
                    }
                    catch (Exception exception) {}
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    protected void createTable() {
        this.table = new Table((Composite)this, 68356);
    }

    protected void createTableViewer() {
        this.tableViewer = new LockedTableViewer(this.table);
    }

    public IRuntime getSelectedRuntime() {
        return this.selection;
    }

    public static interface RuntimeSelectionListener {
        public void runtimeSelected(IRuntime var1);
    }

    class RuntimeViewerSorter
    extends ViewerSorter {
        boolean sortByName;

        public RuntimeViewerSorter(boolean sortByName) {
            this.sortByName = sortByName;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            IRuntime r1 = (IRuntime)e1;
            IRuntime r2 = (IRuntime)e2;
            if (this.sortByName) {
                return this.collator.compare(this.notNull(r1.getName()), this.notNull(r2.getName()));
            }
            if (r1.getRuntimeType() == null) {
                return -1;
            }
            if (r2.getRuntimeType() == null) {
                return 1;
            }
            return this.collator.compare(this.notNull(r1.getRuntimeType().getName()), this.notNull(r2.getRuntimeType().getName()));
        }

        protected String notNull(String s) {
            if (s == null) {
                return "";
            }
            return s;
        }
    }
}

