/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.launching;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.php.internal.debug.ui.launching.TreeAndListGroup;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileSelectionDialog
extends MessageDialog {
    private IAdaptable root;
    private TreeAndListGroup selectionGroup;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;
    private IStructuredSelection result = null;
    private boolean allowMultiselection = false;
    private Pattern fPattern;

    public FileSelectionDialog(Shell shell, IAdaptable iAdaptable, String string) {
        super(shell, "Choose Location", null, string, 0, new String[]{"OK", "Cancel"}, 0);
        this.root = iAdaptable;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setFileFilter(String string, boolean bl) {
        this.fPattern = string != null ? (bl ? Pattern.compile(string, 2) : Pattern.compile(string)) : null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
        this.initializeDialog();
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        this.selectionGroup = new TreeAndListGroup(composite2, this.root, this.getResourceProvider(14), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1), (ILabelProvider)new WorkbenchLabelProvider(), 0, 400, 300, this.allowMultiselection);
        composite2.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent controlEvent) {
            }

            public void controlResized(ControlEvent controlEvent) {
                TableColumn[] tableColumnArray = FileSelectionDialog.this.selectionGroup.getListTable().getColumns();
                int n = 0;
                while (n < tableColumnArray.length) {
                    tableColumnArray[n].pack();
                    ++n;
                }
            }
        });
        return composite2;
    }

    private ITreeContentProvider getResourceProvider(final int n) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object object) {
                if (object instanceof IContainer) {
                    int n2;
                    ArrayList<IResource> arrayList;
                    IResource[] iResourceArray = null;
                    try {
                        iResourceArray = ((IContainer)object).members();
                        arrayList = new ArrayList<IResource>(iResourceArray.length);
                        n2 = 0;
                        while (n2 < iResourceArray.length) {
                            IResource iResource = iResourceArray[n2];
                            if (iResource.isAccessible()) {
                                arrayList.add(iResource);
                            }
                            ++n2;
                        }
                        iResourceArray = arrayList.toArray(new IResource[arrayList.size()]);
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    arrayList = new ArrayList();
                    n2 = 0;
                    while (n2 < iResourceArray.length) {
                        if ((iResourceArray[n2].getType() & n) > 0 && (iResourceArray[n2].getType() != 1 || FileSelectionDialog.this.fPattern == null || FileSelectionDialog.this.fPattern.matcher(iResourceArray[n2].getName()).find())) {
                            arrayList.add(iResourceArray[n2]);
                        }
                        ++n2;
                    }
                    return arrayList.toArray();
                }
                return new Object[0];
            }
        };
    }

    private void initializeDialog() {
        this.selectionGroup.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                FileSelectionDialog.this.getButton(0).setEnabled(!FileSelectionDialog.this.selectionGroup.getListTableSelection().isEmpty());
            }
        });
        this.selectionGroup.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                FileSelectionDialog.this.buttonPressed(0);
            }
        });
        this.getButton(0).setEnabled(false);
    }

    public IStructuredSelection getResult() {
        return this.result;
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.result = this.selectionGroup.getListTableSelection();
        }
        super.buttonPressed(n);
    }

    public void setAllowMultiselection(boolean bl) {
        this.allowMultiselection = bl;
    }
}

