/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.core.text;

import java.io.IOException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.internal.core.text.DocumentCharSequence;
import org.eclipse.search.internal.core.text.FileCharSequenceProvider;
import org.eclipse.search.internal.ui.Messages;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextSearchVisitor {
    private final TextSearchRequestor fCollector;
    private final Matcher fMatcher;
    private Map fDocumentsInEditors;
    private IProgressMonitor fProgressMonitor;
    private int fNumberOfScannedFiles;
    private int fNumberOfFilesToScan;
    private IFile fCurrentFile;
    private final MultiStatus fStatus;
    private final FileCharSequenceProvider fFileCharSequenceProvider;
    private final ReusableMatchAccess fMatchAccess;

    public TextSearchVisitor(TextSearchRequestor collector, Pattern searchPattern) {
        this.fCollector = collector;
        this.fStatus = new MultiStatus("org.eclipse.search", 0, SearchMessages.TextSearchEngine_statusMessage, null);
        this.fMatcher = searchPattern.pattern().length() == 0 ? null : searchPattern.matcher(new String());
        this.fFileCharSequenceProvider = new FileCharSequenceProvider();
        this.fMatchAccess = new ReusableMatchAccess();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus search(IFile[] files, IProgressMonitor monitor) {
        MultiStatus multiStatus;
        this.fProgressMonitor = monitor == null ? new NullProgressMonitor() : monitor;
        this.fNumberOfScannedFiles = 0;
        this.fNumberOfFilesToScan = files.length;
        this.fCurrentFile = null;
        Job monitorUpdateJob = new Job(SearchMessages.TextSearchVisitor_progress_updating_job){
            private int fLastNumberOfScannedFiles = 0;

            public IStatus run(IProgressMonitor inner) {
                while (!inner.isCanceled()) {
                    IFile file = TextSearchVisitor.this.fCurrentFile;
                    if (file != null) {
                        String fileName = file.getName();
                        Object[] args = new Object[]{fileName, new Integer(TextSearchVisitor.this.fNumberOfScannedFiles), new Integer(TextSearchVisitor.this.fNumberOfFilesToScan)};
                        TextSearchVisitor.this.fProgressMonitor.subTask(Messages.format(SearchMessages.TextSearchVisitor_scanning, args));
                        int steps = TextSearchVisitor.this.fNumberOfScannedFiles - this.fLastNumberOfScannedFiles;
                        TextSearchVisitor.this.fProgressMonitor.worked(steps);
                        this.fLastNumberOfScannedFiles += steps;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.OK_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        try {
            String taskName = this.fMatcher == null ? SearchMessages.TextSearchVisitor_filesearch_task_label : Messages.format(SearchMessages.TextSearchVisitor_textsearch_task_label, this.fMatcher.pattern().pattern());
            this.fProgressMonitor.beginTask(taskName, this.fNumberOfFilesToScan);
            monitorUpdateJob.setSystem(true);
            monitorUpdateJob.schedule();
            try {
                this.fCollector.beginReporting();
                this.processFiles(files);
                multiStatus = this.fStatus;
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                monitorUpdateJob.cancel();
                throw throwable;
            }
            monitorUpdateJob.cancel();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.fProgressMonitor.done();
            this.fCollector.endReporting();
            throw throwable;
        }
        this.fProgressMonitor.done();
        this.fCollector.endReporting();
        return multiStatus;
    }

    public IStatus search(TextSearchScope scope, IProgressMonitor monitor) {
        return this.search(scope.evaluateFilesInScope(this.fStatus), monitor);
    }

    private void processFiles(IFile[] files) {
        this.fDocumentsInEditors = this.evalNonFileBufferDocuments();
        int i = 0;
        while (i < files.length) {
            this.fCurrentFile = files[i];
            boolean res = this.processFile(this.fCurrentFile);
            if (!res) break;
            ++i;
        }
        this.fDocumentsInEditors = null;
    }

    private Map evalNonFileBufferDocuments() {
        HashMap result = new HashMap();
        IWorkbench workbench = SearchPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int x = 0;
            while (x < pages.length) {
                IEditorReference[] editorRefs = pages[x].getEditorReferences();
                int z = 0;
                while (z < editorRefs.length) {
                    IEditorPart ep = editorRefs[z].getEditor(false);
                    if (ep instanceof ITextEditor && ep.isDirty()) {
                        this.evaluateTextEditor(result, ep);
                    }
                    ++z;
                }
                ++x;
            }
            ++i;
        }
        return result;
    }

    private void evaluateTextEditor(Map result, IEditorPart ep) {
        IFile file;
        IEditorInput input = ep.getEditorInput();
        if (input instanceof IFileEditorInput && !result.containsKey(file = ((IFileEditorInput)input).getFile())) {
            ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
            ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(file.getFullPath());
            if (textFileBuffer != null) {
                result.put(file, textFileBuffer.getDocument());
            } else {
                IDocument document = ((ITextEditor)ep).getDocumentProvider().getDocument((Object)input);
                if (document != null) {
                    result.put(file, document);
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processFile(IFile file) {
        try {
            try {
                block22: {
                    block21: {
                        block24: {
                            block23: {
                                if (!this.fCollector.acceptFile(file)) break block21;
                                if (this.fMatcher != null) break block23;
                                break block21;
                            }
                            document = this.getOpenDocument(file);
                            if (document == null) break block24;
                            documentCharSequence = new DocumentCharSequence(document);
                            this.locateMatches(file, documentCharSequence);
                            ** GOTO lbl-1000
                        }
                        seq = null;
                        try {
                            try {
                                seq = this.fFileCharSequenceProvider.newCharSequence(file);
                                if (this.hasBinaryContent(seq, file) && !this.fCollector.reportBinaryFile(file)) {
                                    var5_19 = null;
                                    if (seq == null) break block21;
                                    break block22;
                                }
                                this.locateMatches(file, seq);
                            }
                            catch (FileCharSequenceProvider.FileCharSequenceException e) {
                                e.throwWrappedException();
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var6_30) {
                            var5_20 = null;
                            if (seq == null) throw var6_30;
                            try {
                                this.fFileCharSequenceProvider.releaseCharSequence(seq);
                                throw var6_30;
                            }
                            catch (IOException e) {
                                SearchPlugin.log(e);
                            }
                            throw var6_30;
                        }
                    }
lbl39:
                    // 3 sources

                    while (true) {
                        var8_2 = null;
                        ++this.fNumberOfScannedFiles;
                        return true;
                    }
                }
                ** try [egrp 4[TRYBLOCK] [5 : 121->132)] { 
lbl45:
                // 1 sources

                this.fFileCharSequenceProvider.releaseCharSequence(seq);
lbl47:
                // 1 sources

                catch (IOException e) {
                    SearchPlugin.log(e);
                }
                ** continue;
lbl-1000:
                // 2 sources

                {
                    var5_21 = null;
                    if (seq != null) {
                        ** try [egrp 4[TRYBLOCK] [5 : 121->132)] { 
lbl53:
                        // 1 sources

                        this.fFileCharSequenceProvider.releaseCharSequence(seq);
lbl55:
                        // 1 sources

                        catch (IOException e) {
                            SearchPlugin.log(e);
                        }
                    }
                }
            }
            catch (UnsupportedCharsetException e) {
                args = new String[]{this.getCharSetName(file), file.getFullPath().makeRelative().toString()};
                message = Messages.format(SearchMessages.TextSearchVisitor_unsupportedcharset, args);
                this.fStatus.add((IStatus)new Status(2, "org.eclipse.search", 2, message, (Throwable)e));
            }
            catch (IllegalCharsetNameException e) {
                args = new String[]{this.getCharSetName(file), file.getFullPath().makeRelative().toString()};
                message = Messages.format(SearchMessages.TextSearchVisitor_illegalcharset, args);
                this.fStatus.add((IStatus)new Status(2, "org.eclipse.search", 2, message, (Throwable)e));
            }
            catch (IOException e) {
                args = new String[]{this.getExceptionMessage(e), file.getFullPath().makeRelative().toString()};
                message = Messages.format(SearchMessages.TextSearchVisitor_error, args);
                this.fStatus.add((IStatus)new Status(2, "org.eclipse.search", 2, message, (Throwable)e));
            }
            catch (CoreException e) {
                args = new String[]{this.getExceptionMessage((Exception)e), file.getFullPath().makeRelative().toString()};
                message = Messages.format(SearchMessages.TextSearchVisitor_error, args);
                this.fStatus.add((IStatus)new Status(2, "org.eclipse.search", 2, message, (Throwable)e));
            }
            catch (StackOverflowError e) {
                message = SearchMessages.TextSearchVisitor_patterntoocomplex0;
                this.fStatus.add((IStatus)new Status(4, "org.eclipse.search", 4, message, (Throwable)e));
                var8_3 = null;
                ++this.fNumberOfScannedFiles;
                return false;
            }
        }
        catch (Throwable var9_31) {
            var8_4 = null;
            ++this.fNumberOfScannedFiles;
            throw var9_31;
        }
lbl-1000:
        // 7 sources

        {
            var8_5 = null;
            ++this.fNumberOfScannedFiles;
        }
        if (this.fProgressMonitor.isCanceled() == false) return true;
        throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasBinaryContent(CharSequence seq, IFile file) throws CoreException {
        IContentType contentType;
        IContentDescription desc = file.getContentDescription();
        if (desc != null && (contentType = desc.getContentType()) != null && contentType.isKindOf(Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text"))) {
            return false;
        }
        try {
            int limit = FileCharSequenceProvider.BUFFER_SIZE;
            int i = 0;
            while (true) {
                if (i >= limit) {
                    return false;
                }
                if (seq.charAt(i) == '\u0000') {
                    return true;
                }
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void locateMatches(IFile file, CharSequence searchInput) throws CoreException {
        try {
            this.fMatcher.reset(searchInput);
            int k = 0;
            while (this.fMatcher.find()) {
                int start = this.fMatcher.start();
                int end = this.fMatcher.end();
                if (end != start) {
                    this.fMatchAccess.initialize(file, start, end - start, searchInput);
                    boolean res = this.fCollector.acceptPatternMatch(this.fMatchAccess);
                    if (!res) {
                        Object var7_7 = null;
                        this.fMatchAccess.initialize(null, 0, 0, new String());
                        return;
                    }
                }
                if (k++ != 20) continue;
                if (this.fProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException(SearchMessages.TextSearchVisitor_canceled);
                }
                k = 0;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.fMatchAccess.initialize(null, 0, 0, new String());
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.fMatchAccess.initialize(null, 0, 0, new String());
            return;
        }
    }

    private String getExceptionMessage(Exception e) {
        String message = e.getLocalizedMessage();
        if (message == null) {
            return e.getClass().getName();
        }
        return message;
    }

    private IDocument getOpenDocument(IFile file) {
        ITextFileBufferManager bufferManager;
        ITextFileBuffer textFileBuffer;
        IDocument document = (IDocument)this.fDocumentsInEditors.get(file);
        if (document == null && (textFileBuffer = (bufferManager = FileBuffers.getTextFileBufferManager()).getTextFileBuffer(file.getFullPath())) != null) {
            document = textFileBuffer.getDocument();
        }
        return document;
    }

    private String getCharSetName(IFile file) {
        try {
            return file.getCharset();
        }
        catch (CoreException coreException) {
            return "unknown";
        }
    }

    public static class ReusableMatchAccess
    extends TextSearchMatchAccess {
        private int fOffset;
        private int fLength;
        private IFile fFile;
        private CharSequence fContent;

        public void initialize(IFile file, int offset, int length, CharSequence content) {
            this.fFile = file;
            this.fOffset = offset;
            this.fLength = length;
            this.fContent = content;
        }

        public IFile getFile() {
            return this.fFile;
        }

        public int getMatchOffset() {
            return this.fOffset;
        }

        public int getMatchLength() {
            return this.fLength;
        }

        public int getFileContentLength() {
            return this.fContent.length();
        }

        public char getFileContentChar(int offset) {
            return this.fContent.charAt(offset);
        }

        public String getFileContent(int offset, int length) {
            return this.fContent.subSequence(offset, offset + length).toString();
        }
    }
}

