/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.daemon.communication;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.php.debug.daemon.communication.ICommunicationDaemon;
import org.eclipse.php.internal.debug.daemon.DaemonPlugin;

public class CommunicationDaemonRegistry {
    private static final String EXTENSION_POINT_NAME = "debugCommunicationDaemon";
    private static final String DAEMON_TAG = "daemon";
    private static final String ID_ATTRIBUTE = "id";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String DEFAULT_DEBUG_DAEMONS_NAMESPACE = "org.eclipse.php.debug.core";
    private Dictionary daemons = new Hashtable();
    private static CommunicationDaemonRegistry instance = null;

    private CommunicationDaemonRegistry() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(DaemonPlugin.getID(), EXTENSION_POINT_NAME);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            IConfigurationElement iConfigurationElement = iConfigurationElementArray[n];
            if (DAEMON_TAG.equals(iConfigurationElement.getName())) {
                this.daemons.put(iConfigurationElement.getAttribute(ID_ATTRIBUTE), new CommunicationDaemonFactory(iConfigurationElement));
            }
            ++n;
        }
    }

    private static CommunicationDaemonRegistry getInstance() {
        if (instance == null) {
            instance = new CommunicationDaemonRegistry();
        }
        return instance;
    }

    private Dictionary getDaemons() {
        return this.daemons;
    }

    public static ICommunicationDaemon getDaemon(String string) throws Exception {
        return (ICommunicationDaemon)CommunicationDaemonRegistry.getInstance().getDaemons().get(string);
    }

    public static ICommunicationDaemon[] getBestMatchCommunicationDaemons() {
        try {
            ICommunicationDaemon[] iCommunicationDaemonArray;
            ICommunicationDaemon iCommunicationDaemon = null;
            Dictionary dictionary = CommunicationDaemonRegistry.getInstance().getDaemons();
            Enumeration enumeration = dictionary.elements();
            ArrayList<ICommunicationDaemon> arrayList = new ArrayList<ICommunicationDaemon>(4);
            while (enumeration.hasMoreElements()) {
                iCommunicationDaemonArray = (ICommunicationDaemon[])enumeration.nextElement();
                ICommunicationDaemon iCommunicationDaemon2 = iCommunicationDaemonArray.createDaemon();
                if (DEFAULT_DEBUG_DAEMONS_NAMESPACE.equals(iCommunicationDaemonArray.element.getNamespaceIdentifier())) {
                    if (!iCommunicationDaemon2.isEnabled()) continue;
                    iCommunicationDaemon = iCommunicationDaemon2;
                    continue;
                }
                if (!iCommunicationDaemon2.isEnabled()) continue;
                arrayList.add(iCommunicationDaemon2);
            }
            if (arrayList.isEmpty() && iCommunicationDaemon != null) {
                return new ICommunicationDaemon[]{iCommunicationDaemon};
            }
            iCommunicationDaemonArray = new ICommunicationDaemon[arrayList.size()];
            arrayList.toArray(iCommunicationDaemonArray);
            return iCommunicationDaemonArray;
        }
        catch (Exception exception) {
            DaemonPlugin.log(exception);
            return null;
        }
    }

    class CommunicationDaemonFactory {
        ICommunicationDaemon daemon;
        IConfigurationElement element;

        public CommunicationDaemonFactory(IConfigurationElement iConfigurationElement) {
            this.element = iConfigurationElement;
        }

        public ICommunicationDaemon createDaemon() {
            if (this.daemon == null) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(this, "Error creation extension for extension-point org.eclipse.php.internal.debug.daemon.communication"){
                    final /* synthetic */ CommunicationDaemonFactory this$1;
                    {
                        this.this$1 = communicationDaemonFactory;
                        super(string);
                    }

                    public void run() throws Exception {
                        this.this$1.daemon = (ICommunicationDaemon)this.this$1.element.createExecutableExtension("class");
                    }
                });
            }
            return this.daemon;
        }
    }
}

